/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.content.MatchingService;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.furi.URIPattern;
import org.pageseeder.berlioz.furi.URIResolver;
import org.pageseeder.berlioz.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceRegistry {
    private final Map<HttpMethod, ServiceMap> registry = new EnumMap<HttpMethod, ServiceMap>(HttpMethod.class);
    private long version;

    public ServiceRegistry() {
        for (HttpMethod m : HttpMethod.mappable()) {
            this.registry.put(m, new ServiceMap());
        }
        this.version = System.currentTimeMillis();
    }

    public void register(Service service, URIPattern pattern, HttpMethod method) {
        Objects.requireNonNull(service, "No service to register.");
        Objects.requireNonNull(pattern, "URL Pattern must be specified to register a service.");
        Objects.requireNonNull(method, "HTTP Method must be specified to register a service.");
        this.getMapping(method).put(pattern, service);
    }

    public @Nullable MatchingService get(String url) {
        for (Map.Entry<HttpMethod, ServiceMap> allMethods : this.registry.entrySet()) {
            ServiceMap mapping = allMethods.getValue();
            MatchingService service = mapping.match(url);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public List<String> allows(String url) {
        ArrayList<String> methods = new ArrayList<String>();
        for (Map.Entry<HttpMethod, ServiceMap> e : this.registry.entrySet()) {
            HttpMethod m = e.getKey();
            ServiceMap mapping = e.getValue();
            MatchingService service = mapping.match(url);
            if (service == null) continue;
            methods.add(m.toString());
            if (m != HttpMethod.GET) continue;
            methods.add(HttpMethod.HEAD.name());
        }
        return methods;
    }

    public @Nullable HttpMethod getMethod(Service service) {
        if (service == null) {
            return null;
        }
        for (Map.Entry<HttpMethod, ServiceMap> e : this.registry.entrySet()) {
            ServiceMap mapping = e.getValue();
            if (!mapping.isMapped(service)) continue;
            return e.getKey();
        }
        return null;
    }

    public List<String> matches(Service service) {
        if (service == null) {
            return Collections.emptyList();
        }
        for (ServiceMap mapping : this.registry.values()) {
            boolean mapped = mapping.isMapped(service);
            if (!mapped) continue;
            return mapping.matches(service);
        }
        return Collections.emptyList();
    }

    public @Nullable MatchingService get(String url, String method) {
        if (method == null) {
            return null;
        }
        HttpMethod m = this.getHttpMethod(method);
        if (m == null) {
            return null;
        }
        return this.get(url, m);
    }

    public @Nullable MatchingService get(String url, HttpMethod method) {
        if (method == null) {
            return null;
        }
        HttpMethod m = method;
        if (method == HttpMethod.HEAD) {
            m = HttpMethod.GET;
        }
        ServiceMap mapping = this.getMapping(m);
        return mapping.match(url);
    }

    public Map<String, Service> getServiceMap(HttpMethod method) {
        ServiceMap map = this.getMapping(method);
        return Collections.unmodifiableMap(map.mapping);
    }

    public List<Service> getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        for (ServiceMap map : this.registry.values()) {
            services.addAll(map.mapping.values());
        }
        return services;
    }

    public List<Service> getServices(HttpMethod method) {
        ServiceMap map = this.getMapping(method);
        HashSet services = new HashSet(map.mapping.values());
        return new ArrayList<Service>(services);
    }

    public void clear() {
        for (ServiceMap map : this.registry.values()) {
            map.clear();
        }
    }

    public long version() {
        return this.version;
    }

    void touch() {
        this.version = System.currentTimeMillis();
    }

    private @Nullable HttpMethod getHttpMethod(String method) {
        for (HttpMethod m : HttpMethod.values()) {
            if (!m.name().equals(method.toUpperCase())) continue;
            return m;
        }
        return null;
    }

    private ServiceMap getMapping(HttpMethod method) {
        ServiceMap mapping = this.registry.get((Object)method);
        if (mapping == null) {
            throw new IllegalStateException("Failure to initialize service registry");
        }
        return mapping;
    }

    private static class ServiceMap {
        private final Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
        private final Map<String, Service> mapping = new Hashtable<String, Service>();
        private final List<URIPattern> patterns = new ArrayList<URIPattern>();

        private ServiceMap() {
        }

        public boolean put(URIPattern pattern, Service service) {
            Service previous = this.mapping.put(pattern.toString(), service);
            if (previous != null) {
                this.logger.warn("Service ID={} was already registered to {}", (Object)previous, (Object)pattern);
            }
            this.patterns.add(pattern);
            return true;
        }

        public @Nullable MatchingService match(String url) {
            MatchingService match = null;
            Service service = this.mapping.get(url);
            if (service != null) {
                URIPattern p = new URIPattern(url);
                match = new MatchingService(service, p, new URIResolver(url).resolve(p));
            } else {
                URIResolver resolver = new URIResolver(url);
                URIPattern p = resolver.find(this.patterns, URIResolver.MatchRule.BEST_MATCH);
                if (p != null && (service = this.mapping.get(p.toString())) != null) {
                    match = new MatchingService(service, p, resolver.resolve(p));
                }
            }
            return match;
        }

        public boolean isMapped(Service service) {
            return this.mapping.containsValue(service);
        }

        public List<String> matches(Service service) {
            ArrayList<String> urls = new ArrayList<String>();
            for (Map.Entry<String, Service> e : this.mapping.entrySet()) {
                if (e.getValue() != service) continue;
                urls.add(e.getKey());
            }
            return urls;
        }

        public void clear() {
            this.mapping.clear();
            this.patterns.clear();
        }
    }
}

