/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.content;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class ParameterTemplate {
    private static final Pattern VARIABLE = Pattern.compile("\\{[^}{]+}");
    private final Token[] _tokens;

    private ParameterTemplate(Token ... tokens) {
        this._tokens = tokens;
    }

    public String toString(Map<String, String> map) {
        StringBuilder value = new StringBuilder();
        for (Token t : this._tokens) {
            value.append(t.toString(map));
        }
        return value.toString();
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        for (Token t : this._tokens) {
            value.append(t.toString());
        }
        return value.toString();
    }

    public static ParameterTemplate parse(String template) {
        String text;
        if (template.indexOf(123) < 0) {
            return ParameterTemplate.value(template);
        }
        Matcher m = VARIABLE.matcher(template);
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        while (m.find()) {
            Token t;
            if (m.start() > start) {
                text = template.substring(start, m.start());
                tokens.add(new Literal(text));
            }
            if ((t = ParameterTemplate.parseToken(m.group())) != null) {
                tokens.add(t);
            }
            start = m.end();
        }
        if (start < template.length()) {
            text = template.substring(start);
            tokens.add(new Literal(text));
        }
        return new ParameterTemplate(tokens.toArray(new Token[0]));
    }

    public static ParameterTemplate value(String value) {
        Literal token = new Literal(value);
        return new ParameterTemplate(token);
    }

    public static ParameterTemplate parameter(String name, String def) {
        Variable token = new Variable(name, def);
        return new ParameterTemplate(token);
    }

    public static @Nullable Token parseToken(@Nullable String token) {
        if (token == null || token.isEmpty()) {
            return null;
        }
        if (token.length() > 1 && token.charAt(0) == '{' && token.charAt(token.length() - 1) == '}') {
            int eq = token.indexOf(61);
            if (eq == 1) {
                String text = token.substring(2, token.length() - 1);
                return new Literal(text);
            }
            if (eq > 1) {
                String name = token.substring(1, eq);
                String text = token.substring(eq + 1, token.length() - 1);
                return new Variable(name, text);
            }
            String name = token.substring(1, token.length() - 1);
            return new Variable(name, "");
        }
        return new Literal(token);
    }

    private static class Variable
    implements Token {
        private final String _name;
        private final String _text;

        public Variable(String name, String text) {
            this._name = Objects.requireNonNull(name, "Variables require a name");
            this._text = Objects.toString(text, "");
        }

        @Override
        public String toString(Map<String, String> map) {
            String value = map.get(this._name);
            return value != null ? value : this._text;
        }

        public String toString() {
            if (this._text.length() > 0) {
                return '{' + this._name + '=' + this._text + '}';
            }
            return '{' + this._name + '}';
        }
    }

    private static class Literal
    implements Token {
        private final String _text;

        private Literal(String text) {
            this._text = Objects.requireNonNull(text, "Literal must have a value");
        }

        @Override
        public String toString(Map<String, String> map) {
            return this._text;
        }

        public String toString() {
            return this._text;
        }
    }

    private static interface Token {
        public String toString(Map<String, String> var1);
    }
}

