/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.config.ConfigException;
import org.pageseeder.berlioz.config.ConfigLoader;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public final class GlobalConfig
implements Serializable,
XMLWritable {
    private static final long serialVersionUID = 20230216L;
    private static final Pattern VALID_XML_NAME = Pattern.compile("[a-zA-Z_][-a-zA-Z0-9_.]*");
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalConfig.class);
    private final Map<String, String> _properties;

    public GlobalConfig() {
        this._properties = new HashMap<String, String>();
    }

    public GlobalConfig(Map<String, String> properties) {
        this._properties = properties;
    }

    public static GlobalConfig newInstance(File file) throws ConfigException {
        return ConfigLoader.parse(new Handler(), file);
    }

    public Map<String, String> properties() {
        return this._properties;
    }

    public synchronized void load(InputStream in) throws ConfigException {
        GlobalConfig copy = ConfigLoader.parse(new Handler(), in);
        this._properties.putAll(copy.properties());
    }

    public void save(OutputStream out) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            XMLWriterImpl xml = new XMLWriterImpl((Writer)w, true);
            this.toXML((XMLWriter)xml);
        }
    }

    public void toXML(XMLWriter xml) throws IOException {
        TreeMap<String, String> sorted = new TreeMap<String, String>(this._properties);
        xml.openElement("global", true);
        GlobalConfig.toXML(xml, sorted);
        xml.closeElement();
    }

    private static void toXML(XMLWriter xml, SortedMap<String, String> map) throws IOException {
        GlobalConfig.attributes(xml, map);
        for (String node : GlobalConfig.nodes(map)) {
            if (VALID_XML_NAME.matcher(node).matches()) {
                xml.openElement(node, true);
                GlobalConfig.toXML(xml, GlobalConfig.sub(map, node));
                xml.closeElement();
                continue;
            }
            LOGGER.warn("Unable to write this element as xml (invalid name): {}", (Object)node);
        }
    }

    private static void attributes(XMLWriter xml, Map<String, String> map) throws IOException {
        for (Map.Entry<String, String> x : map.entrySet()) {
            String property = x.getKey();
            if (property.indexOf(46) >= 0) continue;
            if (VALID_XML_NAME.matcher(property).matches()) {
                xml.attribute(property, x.getValue());
                continue;
            }
            LOGGER.warn("Unable to write this attribute as xml (invalid name): {}", (Object)property);
        }
    }

    private static SortedSet<String> nodes(Map<String, String> map) {
        TreeSet<String> nodes = new TreeSet<String>();
        for (String property : map.keySet()) {
            int dot = property.indexOf(46);
            if (dot < 0) continue;
            nodes.add(property.substring(0, dot));
        }
        return nodes;
    }

    private static SortedMap<String, String> sub(SortedMap<String, String> map, String node) {
        String prefix = node + ".";
        TreeMap<String, String> sub = new TreeMap<String, String>();
        for (Map.Entry<String, String> e : map.entrySet()) {
            String property = e.getKey();
            if (!property.startsWith(prefix)) continue;
            sub.put(property.substring(prefix.length()), e.getValue());
        }
        return sub;
    }

    private static final class Handler
    extends ConfigLoader.ConfigHandler<GlobalConfig> {
        private Map<String, String> properties;
        private @Nullable Stack<String> nodes = null;

        private Handler() {
        }

        @Override
        public String getSchema() {
            return null;
        }

        @Override
        public void startDocument() {
            this.properties = new HashMap<String, String>();
            this.nodes = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            block4: {
                block3: {
                    Stack<String> nodes = this.nodes;
                    if (nodes == null) break block3;
                    nodes.push(localName);
                    int attCount = atts.getLength();
                    if (attCount <= 0) break block4;
                    String prefix = Handler.getPrefix(nodes);
                    for (int i = 0; i < attCount; ++i) {
                        String name = atts.getLocalName(i);
                        String value = atts.getValue(i);
                        if (value == null) continue;
                        this.properties.put(prefix + name, value);
                    }
                    break block4;
                }
                this.nodes = new Stack();
                int attCount = atts.getLength();
                if (attCount > 0) {
                    for (int i = 0; i < attCount; ++i) {
                        String name = atts.getLocalName(i);
                        String value = atts.getValue(i);
                        if (name == null || value == null) continue;
                        this.properties.put(name, value);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            Stack<String> nodes = this.nodes;
            if (nodes != null) {
                if (nodes.size() > 0) {
                    nodes.pop();
                } else {
                    this.nodes = null;
                }
            }
        }

        private static String getPrefix(Stack<String> nodes) {
            StringBuilder prefix = new StringBuilder();
            for (String node : nodes) {
                prefix.append(node).append('.');
            }
            return prefix.toString();
        }

        @Override
        public GlobalConfig getConfig() {
            return new GlobalConfig(this.properties);
        }
    }
}

