/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.bundler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.pageseeder.berlioz.bundler.ParsingException;

public final class JSMin {
    private static final int EOF = -1;
    private static final int WRITE = 1;
    private static final int COPY = 2;
    private static final int NEXT = 3;
    private final PushbackInputStream _in;
    private OutputStream out;
    private int theA;
    private int theB;
    private int line;
    private int column;

    public JSMin(InputStream in, OutputStream out) {
        this._in = new PushbackInputStream(in);
        this.out = out;
        this.line = 0;
        this.column = 0;
    }

    private static boolean isAlphanum(int c) {
        int lastPrintableAscii = 126;
        return c >= 97 && c <= 122 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c == 95 || c == 36 || c == 92 || c > 126;
    }

    int get() throws IOException {
        int c = this._in.read();
        if (c == 10) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        if (c >= 32 || c == 10 || c == -1) {
            return c;
        }
        if (c == 13) {
            this.column = 0;
            return 10;
        }
        return 32;
    }

    int peek() throws IOException {
        int lookaheadChar = this._in.read();
        this._in.unread(lookaheadChar);
        return lookaheadChar;
    }

    int next() throws IOException, UnterminatedCommentException {
        int c = this.get();
        if (c == 47) {
            switch (this.peek()) {
                case 47: {
                    while ((c = this.get()) > 10) {
                    }
                    return c;
                }
                case 42: {
                    this.get();
                    block9: while (true) {
                        switch (this.get()) {
                            case 42: {
                                if (this.peek() != 47) continue block9;
                                this.get();
                                return 32;
                            }
                            case -1: {
                                throw new UnterminatedCommentException(this.line, this.column);
                            }
                        }
                    }
                }
            }
            return c;
        }
        return c;
    }

    private void process(int action) throws IOException, UnterminatedRegExpLiteralException, UnterminatedCommentException, UnterminatedStringLiteralException {
        switch (action) {
            case 1: {
                this.out.write(this.theA);
            }
            case 2: {
                this.theA = this.theB;
                if (this.theA == 39 || this.theA == 34) {
                    while (true) {
                        this.out.write(this.theA);
                        this.theA = this.get();
                        if (this.theA == this.theB) break;
                        if (this.theA <= 10) {
                            throw new UnterminatedStringLiteralException(this.line, this.column);
                        }
                        if (this.theA != 92) continue;
                        this.out.write(this.theA);
                        this.theA = this.get();
                    }
                }
            }
            case 3: {
                this.theB = this.next();
                if (this.theB != 47 || this.theA != 40 && this.theA != 44 && this.theA != 61 && this.theA != 58 && this.theA != 91 && this.theA != 33 && this.theA != 38 && this.theA != 124 && this.theA != 63 && this.theA != 123 && this.theA != 125 && this.theA != 59 && this.theA != 10) break;
                this.out.write(this.theA);
                this.out.write(this.theB);
                while (true) {
                    this.theA = this.get();
                    if (this.theA == 47) break;
                    if (this.theA == 92) {
                        this.out.write(this.theA);
                        this.theA = this.get();
                    } else if (this.theA <= 10) {
                        throw new UnterminatedRegExpLiteralException(this.line, this.column);
                    }
                    this.out.write(this.theA);
                }
                this.theB = this.next();
            }
        }
    }

    public void jsmin() throws IOException, ParsingException {
        this.theA = 10;
        this.process(3);
        block15: while (this.theA != -1) {
            switch (this.theA) {
                case 32: {
                    if (JSMin.isAlphanum(this.theB)) {
                        this.process(1);
                        continue block15;
                    }
                    this.process(2);
                    continue block15;
                }
                case 10: {
                    switch (this.theB) {
                        case 40: 
                        case 43: 
                        case 45: 
                        case 91: 
                        case 123: {
                            this.process(1);
                            continue block15;
                        }
                        case 32: {
                            this.process(3);
                            continue block15;
                        }
                    }
                    if (JSMin.isAlphanum(this.theB)) {
                        this.process(1);
                        continue block15;
                    }
                    this.process(2);
                    continue block15;
                }
            }
            switch (this.theB) {
                case 32: {
                    if (JSMin.isAlphanum(this.theA)) {
                        this.process(1);
                        continue block15;
                    }
                    this.process(3);
                    continue block15;
                }
                case 10: {
                    switch (this.theA) {
                        case 34: 
                        case 39: 
                        case 41: 
                        case 43: 
                        case 45: 
                        case 93: 
                        case 125: {
                            this.process(1);
                            continue block15;
                        }
                    }
                    if (JSMin.isAlphanum(this.theA)) {
                        this.process(1);
                        continue block15;
                    }
                    this.process(3);
                    continue block15;
                }
            }
            this.process(1);
        }
        this.out.flush();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: ");
            System.out.println("JSMin [filepath]");
            return;
        }
        try {
            File file = new File(args[0]).getCanonicalFile();
            String currentPath = new File(".").getCanonicalPath();
            if (!file.toPath().startsWith(currentPath) || !file.exists() || file.isDirectory()) {
                throw new IllegalArgumentException("Illegal filepath argument");
            }
            JSMin jsmin = new JSMin(Files.newInputStream(file.toPath(), new OpenOption[0]), System.out);
            jsmin.jsmin();
        }
        catch (IOException | IllegalArgumentException | ParsingException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    public static class UnterminatedRegExpLiteralException
    extends ParsingException {
        public UnterminatedRegExpLiteralException(int line, int column) {
            super("Unterminated regular expression", line, column);
        }
    }

    public static class UnterminatedStringLiteralException
    extends ParsingException {
        public UnterminatedStringLiteralException(int line, int column) {
            super("Unterminated string literal", line, column);
        }
    }

    public static class UnterminatedCommentException
    extends ParsingException {
        public UnterminatedCommentException(int line, int column) {
            super("Unterminated comment at line", line, column);
        }
    }
}

