/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.aeson;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import javax.json.JsonException;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.aeson.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class J2EEJSONWriter
implements JSONWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(J2EEJSONWriter.class);
    private static @Nullable JsonGeneratorFactory factory = null;
    private final JsonGenerator _json;

    private J2EEJSONWriter(JsonGenerator json) {
        this._json = json;
    }

    @Override
    public JSONWriter startArray(String name) {
        this._json.writeStartArray(name);
        return this;
    }

    @Override
    public JSONWriter startArray() {
        this._json.writeStartArray();
        return this;
    }

    @Override
    public JSONWriter startObject(String name) {
        this._json.writeStartObject(name);
        return this;
    }

    @Override
    public JSONWriter startObject() {
        this._json.writeStartObject();
        return this;
    }

    @Override
    public JSONWriter end() {
        this._json.writeEnd();
        return this;
    }

    @Override
    public JSONWriter writeNull(String name) {
        this._json.write(name, JsonValue.NULL);
        return this;
    }

    @Override
    public JSONWriter writeNull() {
        this._json.write(JsonValue.NULL);
        return this;
    }

    @Override
    public JSONWriter value(double number) {
        this._json.write(number);
        return this;
    }

    @Override
    public JSONWriter value(long number) {
        this._json.write(number);
        return this;
    }

    @Override
    public JSONWriter value(String value) {
        this._json.write(value);
        return this;
    }

    @Override
    public JSONWriter value(boolean number) {
        this._json.write(number);
        return this;
    }

    @Override
    public JSONWriter property(String name, String value) {
        this._json.write(name, value);
        return this;
    }

    @Override
    public JSONWriter property(String name, boolean value) {
        this._json.write(name, value);
        return this;
    }

    @Override
    public JSONWriter property(String name, double value) {
        this._json.write(name, value);
        return this;
    }

    @Override
    public JSONWriter property(String name, long value) {
        this._json.write(name, value);
        return this;
    }

    @Override
    public void close() {
        this._json.close();
    }

    public static J2EEJSONWriter newInstance(OutputStream out) {
        JsonGenerator json = J2EEJSONWriter.factory().createGenerator(out);
        return new J2EEJSONWriter(json);
    }

    public static J2EEJSONWriter newInstance(Writer writer) {
        JsonGenerator json = J2EEJSONWriter.factory().createGenerator(writer);
        return new J2EEJSONWriter(json);
    }

    protected static synchronized boolean init() {
        try {
            J2EEJSONWriter.factory();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    private static synchronized JsonGeneratorFactory factory() {
        JsonGeneratorFactory f = factory;
        if (f == null) {
            factory = f = J2EEJSONWriter.loadFactory();
        }
        return f;
    }

    private static synchronized JsonGeneratorFactory loadFactory() {
        try {
            JsonProvider provider = JsonProvider.provider();
            LOGGER.debug("JSON Provider found using {}", (Object)provider.getClass().getName());
            return provider.createGeneratorFactory(Collections.emptyMap());
        }
        catch (JsonException ex) {
            LOGGER.warn("JSON Provider not found: {}", (Object)ex.getMessage());
            throw new UnsupportedOperationException("Unable to find suitable provider");
        }
    }
}

