/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.web;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;

public final class WebTransaction {
    private static final String SESSION_PREFIX = "weborganic";
    private final String name;
    private final HttpSession session;
    private @Nullable Date expires;
    private Map<String, Object> objects;

    public WebTransaction(HttpSession session, String name, boolean create) {
        this.session = session;
        this.name = name;
        this.expires = null;
        if (!create) {
            this.objects = (Hashtable)session.getAttribute("weborganic." + name);
            this.expires = (Date)session.getAttribute("weborganic." + name + ".expires");
        }
        if (this.objects == null || this.expires != null && this.expires.before(new Date())) {
            this.objects = new Hashtable<String, Object>();
            this.expires = null;
            session.setAttribute("weborganic." + this.name, this.objects);
        }
    }

    public WebTransaction(HttpSession session, String name, boolean create, int seconds) {
        this(session, name, create);
        if (this.expires == null) {
            int ms = 1000;
            this.expires = new Date(new Date().getTime() + (long)(seconds * 1000));
            session.setAttribute("weborganic." + this.name + ".expires", (Object)this.expires);
        }
    }

    public void add(String name, @Nullable Object o) {
        if (o != null) {
            this.objects.put(name, o);
        }
    }

    public void close() {
        this.session.removeAttribute("weborganic." + this.name);
        this.session.removeAttribute("weborganic." + this.name + ".expires");
    }

    public Object get(String name) {
        return this.objects.get(name);
    }

    public String getName() {
        return this.name;
    }

    public @Nullable Map<String, Object> getObjects() {
        return this.objects;
    }

    public void remove(String name) {
        this.objects.remove(name);
    }
}

