/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.web;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.common.http.HttpWebRequest;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.OpenDatabaseException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebRequest
extends HttpWebRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebRequest.class);

    public WebRequest(HttpServletRequest req, HttpServletResponse res) {
        super(req, res);
    }

    public @Nullable Database getDatabase() {
        Database db;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            this.sendErrorSilently(502, "Failed to open database: " + ex.getMessage());
            db = null;
        }
        return db;
    }

    public static @Nullable Database getDatabase(HttpServletResponse res) throws IOException {
        Database db = null;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            res.sendError(502, "Unable to open database connection: " + ex.getMessage());
        }
        return db;
    }

    public void sendError(Exception ex) throws IOException {
        if (this.hasError()) {
            return;
        }
        if (ex instanceof DatabaseException) {
            this.sendError(502, ex);
        } else {
            this.sendError(500, ex);
        }
    }

    public void sendErrorSilently(Exception ex) {
        try {
            this.sendError(ex);
        }
        catch (IOException io) {
            LoggerFactory.getLogger(HttpWebRequest.class).error("Swallowed IO exception while trying to send error", (Throwable)io);
        }
    }

    public static void sendError(HttpServletRequest req, HttpServletResponse res, Throwable ex, ServletConfig conf) throws IOException {
        req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
        req.setAttribute("javax.servlet.error.servlet_name", (Object)conf.getServletName());
        req.setAttribute("javax.servlet.error.exception", (Object)ex);
        res.sendError(500, ex.getMessage());
    }

    public static void sendError(HttpServletRequest req, HttpServletResponse res, int status, ErrorID error) {
        WebRequest.sendError(req, res, status, error, null);
    }

    public static void sendError(HttpServletRequest req, HttpServletResponse res, int status, ErrorID error, @Nullable String errorMessage) {
        try {
            req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
            req.setAttribute("javax.servlet.error.message", (Object)(errorMessage != null ? errorMessage : error.message()));
            req.setAttribute("com.pageseeder.error.id", (Object)error.id());
            res.sendError(status, errorMessage != null ? errorMessage : error.message());
        }
        catch (IOException ex) {
            LOGGER.error("Unable to print error details.", (Throwable)ex);
        }
    }
}

