/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.web;

import com.pageseeder.base.util.RuleUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.eclipse.jdt.annotation.Nullable;

public final class Error {
    private final Date date;
    private @Nullable Exception exception = null;
    private @Nullable String message;
    private @Nullable String data = null;

    public Error(Exception ex) {
        this.exception = ex;
        this.message = ex.getMessage();
        this.date = new Date();
    }

    public Error(String message, String data) {
        this.message = message;
        this.data = data;
        this.date = new Date();
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setErrorMessage(String message) {
        this.message = message;
    }

    public @Nullable Exception getException() {
        return this.exception;
    }

    public String toXML() {
        Object err = "<error>\n";
        if (this.data != null) {
            int i;
            String theData = this.data;
            if (theData.startsWith("<?xml") && (i = theData.indexOf("?>")) != -1) {
                theData = theData.substring(i + 2);
            }
            err = (String)err + "<data>" + theData + "</data>\n";
        }
        if (this.exception != null) {
            StringWriter sw = new StringWriter();
            this.exception.printStackTrace(new PrintWriter(sw));
            err = (String)err + "<stacktrace>" + RuleUtils.makeXMLSafe(sw.toString()) + "</stacktrace>\n";
        }
        if (this.message != null) {
            err = (String)err + "<message>" + RuleUtils.makeXMLSafe(this.message) + "</message>\n";
        }
        err = (String)err + "<date>" + this.date + "</date>\n";
        return (String)err + "</error>";
    }
}

