/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public final class HTMLSanitizer {
    private static final String[] XREF_ATTRIBUTES = new String[]{"class", "data-uriid", "data-title", "data-display", "data-docid", "href", "data-type", "data-reversetype", "data-reverselink", "data-reversetitle", "data-frag", "data-level", "data-config", "data-labels", "data-urititle"};
    private static final PolicyFactory COMMENT_POLICY = new HtmlPolicyBuilder().allowElements(new String[]{"p", "div", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "li", "blockquote", "dd", "dl", "dt", "hr", "pre", "table", "caption", "table", "tbody", "td", "tfoot", "th", "thead", "tr"}).allowElements(new String[]{"b", "i", "s", "u", "sup", "sub", "ins", "del", "strong", "code", "small", "br", "span", "em", "a", "big", "strike", "tt"}).allowUrlProtocols(new String[]{"https", "http", "mailto"}).allowAttributes(new String[]{"start", "type"}).onElements(new String[]{"ol"}).allowAttributes(new String[]{"value"}).onElements(new String[]{"li"}).allowAttributes(new String[]{"colspan", "rowspan"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"class"}).onElements(new String[]{"pre"}).toFactory();
    private static final PolicyFactory PSML_POLICY = new HtmlPolicyBuilder().allowElements(new String[]{"p", "div", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "li", "blockquote", "body", "dd", "dl", "dt", "hr", "pre", "table", "caption", "table", "tbody", "colgroup", "col", "td", "tfoot", "th", "thead", "tr"}).allowElements(new String[]{"b", "i", "s", "u", "sup", "sub", "ins", "img", "del", "strong", "code", "small", "br", "span", "em", "a", "big", "strike", "tt", "var"}).allowUrlProtocols(new String[]{"https", "http", "mailto"}).allowAttributes(new String[]{"data-type", "id"}).onElements(new String[]{"body"}).allowAttributes(new String[]{"data-name", "data-datatype", "data-multiple", "data-count", "data-align", "data-role"}).onElements(new String[]{"tr"}).allowAttributes(new String[]{"data-label", "label", "class"}).onElements(new String[]{"div"}).allowAttributes(new String[]{"data-label", "label", "class", "style"}).onElements(new String[]{"span"}).allowAttributes(XREF_ATTRIBUTES).onElements(new String[]{"div", "a"}).allowAttributes(new String[]{"id", "name"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"data-name"}).onElements(new String[]{"var"}).allowAttributes(new String[]{"class", "style", "data-prefix", "data-numbered"}).onElements(new String[]{"h1", "h2", "h3", "h4", "h5", "h6"}).allowAttributes(new String[]{"data-indent", "class", "style", "data-prefix", "data-numbered"}).onElements(new String[]{"p"}).allowAttributes(new String[]{"data-type", "style", "data-role", "start"}).onElements(new String[]{"ol"}).allowAttributes(new String[]{"data-type", "style", "data-role"}).onElements(new String[]{"ul"}).allowAttributes(new String[]{"data-role"}).onElements(new String[]{"pre"}).allowAttributes(new String[]{"width", "style", "data-height", "height", "data-role", "cellspacing", "cellpadding", "summary"}).onElements(new String[]{"table"}).allowAttributes(new String[]{"span", "data-role", "data-part", "data-align", "width", "style"}).onElements(new String[]{"col"}).allowAttributes(new String[]{"width", "style", "align", "colspan", "rowspan", "valign", "data-role"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"src", "data-uriid", "data-labels", "width", "height", "style", "alt"}).onElements(new String[]{"img"}).toFactory();
    private static final PolicyFactory EMAIL_POLICY = Sanitizers.BLOCKS.and(Sanitizers.STYLES).and(Sanitizers.TABLES).and(Sanitizers.FORMATTING).and(Sanitizers.LINKS).and(Sanitizers.IMAGES).and(new HtmlPolicyBuilder().allowElements(new String[]{"html", "body", "head", "meta", "title"}).allowAttributes(new String[]{"name", "content"}).onElements(new String[]{"meta"}).toFactory());

    private HTMLSanitizer() {
    }

    public static String sanitizeForComments(String html) {
        return COMMENT_POLICY.sanitize(html).trim();
    }

    public static String sanitizeForPSML(String html) {
        return PSML_POLICY.sanitize(html).trim();
    }

    public static String sanitizeForEmails(String html) {
        return EMAIL_POLICY.sanitize(html).trim();
    }
}

