/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import com.pageseeder.common.properties.GlobalSettings;

public final class ExportUtils {
    private ExportUtils() {
    }

    public static String relativiseFullPath(String fullpath, String parent, String exportCtxt, String groupCtxt, int independent) {
        Object extraFolder;
        Object dad;
        String suffix;
        String siteprefix = GlobalSettings.getSitePrefix();
        String path = fullpath.replaceAll("\\.xml$", ".psml");
        Object parentFolder = parent.replaceFirst("/$", "") + "/";
        String exportContext = exportCtxt.replaceFirst("/$", "") + "/";
        String groupContext = groupCtxt.replaceFirst("/$", "") + "/";
        boolean parentInContext = ((String)parentFolder).startsWith(exportContext);
        boolean parentInGroupCtxt = ((String)parentFolder).startsWith(groupContext);
        boolean targetInContext = fullpath.startsWith(exportContext);
        boolean targetInGroupCtxt = fullpath.startsWith(groupContext);
        String prefix = independent > 0 ? "" : "_";
        String string = suffix = independent <= 1 ? "" : Integer.toString(independent);
        if (targetInContext) {
            if (parentInContext) {
                return ExportUtils.relativise(path.substring(exportContext.length()), ((String)parentFolder).substring(exportContext.length()));
            }
            if (parentInGroupCtxt) {
                dad = ((String)parentFolder).substring(groupContext.length());
            } else {
                if (((String)parentFolder).startsWith(siteprefix + "/")) {
                    parentFolder = ((String)parentFolder).substring(siteprefix.length() + 1);
                }
                dad = parentFolder;
            }
            dad = "extra/" + (String)dad;
            extraFolder = "";
            path = path.substring(exportContext.length());
        } else if (targetInGroupCtxt) {
            if (!parentInContext && parentInGroupCtxt) {
                return ExportUtils.relativise(path.substring(groupContext.length()), ((String)parentFolder).substring(groupContext.length()));
            }
            if (parentInContext) {
                dad = ((String)parentFolder).substring(exportContext.length());
            } else {
                if (((String)parentFolder).startsWith(siteprefix + "/")) {
                    parentFolder = ((String)parentFolder).substring(siteprefix.length() + 1);
                }
                dad = "extra/" + (String)parentFolder;
            }
            extraFolder = prefix + "local" + suffix + "/";
            path = path.substring(groupContext.length());
        } else {
            if (!parentInContext && !parentInGroupCtxt) {
                return ExportUtils.relativise(path, (String)parentFolder);
            }
            if (path.startsWith(siteprefix + "/")) {
                path = path.substring(siteprefix.length() + 1);
            }
            dad = parentInContext ? ((String)parentFolder).substring(exportContext.length()) : "extra/" + ((String)parentFolder).substring(groupContext.length());
            extraFolder = prefix + "external" + suffix + "/";
        }
        Object href = "";
        for (int i = 0; !((String)dad).isEmpty() && i < ((String)dad).split("/").length; ++i) {
            href = (String)href + "../";
        }
        return (String)href + (String)extraFolder + path;
    }

    protected static String relativise(String path, String parent) {
        int i;
        if (parent.isEmpty()) {
            return path;
        }
        if (((String)path).startsWith(parent + "/")) {
            return ((String)path).substring(parent.length() + 1);
        }
        String[] pathElements = ((String)path).split("/");
        String[] parentElements = parent.split("/");
        int left = parentElements.length - pathElements.length + 1;
        for (i = 0; i < pathElements.length - 1 && i < parentElements.length; ++i) {
            if (!pathElements[i].equals(parentElements[i])) {
                left = parentElements.length - i;
                break;
            }
            path = ((String)path).substring(pathElements[i].length() + 1);
        }
        for (i = 0; i < left; ++i) {
            path = "../" + (String)path;
        }
        return path;
    }
}

