/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.thread;

import com.pageseeder.base.logback.XLoggable;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.common.xml.XMLUtils;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;

public final class ProcessStage
implements XLoggable {
    private Status status = Status.INITIALISED;
    private @Nullable String message = null;
    private final ProcessThread thread;

    public ProcessStage(ProcessThread dad) {
        this.thread = dad;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isFinished() {
        return this.status.equals((Object)Status.CANCELLED) || this.status.equals((Object)Status.FAILED) || this.status.equals((Object)Status.COMPLETED);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public @Nullable String getMessage() {
        return this.message;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public void toXMLLog(Appendable xml) throws IOException {
        xml.append("<thread");
        ProcessStage.attribute(xml, "status", this.status.toString());
        if (this.message != null && this.message.startsWith("<threadid ")) {
            xml.append(">");
            xml.append(this.message);
            xml.append("</thread>");
        } else if (this.message != null) {
            ProcessStage.attribute(xml, "message", this.message);
            xml.append(" />");
        } else {
            xml.append(" />");
        }
    }

    @Override
    public @Nullable String getTicket() {
        return this.thread.getThreadID();
    }

    @Override
    public String getUser() {
        return this.thread.getUsername();
    }

    @Override
    public String getTitle() {
        return this.thread.getName();
    }

    @Override
    public Long getGroupID() {
        return this.thread.getGroupID();
    }

    @Override
    public String getGroup() {
        return this.thread.getGroup();
    }

    @Override
    public @Nullable XLoggable.TYPE getType() {
        if (this.status == Status.INITIALISED) {
            return XLoggable.TYPE.START;
        }
        if (this.isFinished()) {
            return XLoggable.TYPE.END;
        }
        return null;
    }

    static void attribute(Appendable xml, String name, String value) throws IOException {
        xml.append(' ');
        xml.append(name).append('=').append('\"');
        xml.append(XMLUtils.escapeAttValue((String)value));
        xml.append('\"');
    }

    public static enum Status {
        INITIALISED,
        INPROGRESS,
        ERROR,
        WARNING,
        CANCELLED,
        COMPLETED,
        FAILED;

    }
}

