/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.thread;

import com.pageseeder.base.thread.ProcessLogger;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.common.util.MD5;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessManager.class);
    private static volatile @Nullable ProcessManager singleton = null;
    private final ProcessLogger processLogger;
    private static final int THREAD_PRIORITY = Math.round(4.0f);
    private final Map<String, ProcessThread> threadsList = new ConcurrentHashMap<String, ProcessThread>();
    private final Map<Long, Collection<String>> threadsPerGroup = new ConcurrentHashMap<Long, Collection<String>>();
    private final ExecutorService threadPool;
    private AtomicInteger threadCounter = new AtomicInteger(0);
    private CleanUpThread cleanupThread = null;

    private ProcessManager() {
        this.threadPool = Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r, "ps-process-p" + THREAD_PRIORITY);
            t.setPriority(THREAD_PRIORITY);
            return t;
        });
        try {
            this.processLogger = new ProcessLogger();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to create PSThread Logger: " + ex.getMessage());
        }
        this.cleanupThread = new CleanUpThread();
        this.threadPool.execute(this.cleanupThread);
    }

    public static ProcessManager getInstance() {
        if (singleton == null) {
            singleton = new ProcessManager();
        }
        return singleton;
    }

    public ProcessLogger getLogger() {
        return this.processLogger;
    }

    public void start(ProcessThread thread) {
        this.prepareForStart(thread, false);
        this.execute(thread, true);
    }

    public void prepareForStart(ProcessThread thread, boolean logStartEvent) {
        String id = MD5.hash((String)(System.currentTimeMillis() + "-" + this.threadCounter.getAndIncrement()));
        thread.setIDAndLogger(id, this.processLogger);
        this.threadsList.put(thread.getThreadID(), thread);
        Collection<String> forGroup = this.threadsPerGroup.get(thread.getGroupID());
        if (forGroup == null) {
            forGroup = new ConcurrentLinkedQueue<String>();
            this.threadsPerGroup.put(thread.getGroupID(), forGroup);
        }
        if (!forGroup.contains(thread.getThreadID())) {
            forGroup.add(thread.getThreadID());
        }
        if (logStartEvent) {
            this.processLogger.startThread(thread);
        }
    }

    public void execute(ProcessThread thread, boolean logStartEvent) {
        this.threadsList.put(thread.getThreadID(), thread);
        Collection<String> forGroup = this.threadsPerGroup.get(thread.getGroupID());
        if (forGroup == null) {
            forGroup = new ConcurrentLinkedQueue<String>();
            this.threadsPerGroup.put(thread.getGroupID(), forGroup);
        }
        if (!forGroup.contains(thread.getThreadID())) {
            forGroup.add(thread.getThreadID());
        }
        if (logStartEvent) {
            this.processLogger.startThread(thread);
        }
        this.threadPool.execute(thread);
    }

    public void clearIfFinished(String threadId) {
        ProcessThread thread = this.threadsList.get(threadId);
        if (thread != null && thread.isFinished()) {
            Collection<String> ids = this.threadsPerGroup.get(thread.getGroupID());
            ids.remove(thread.getThreadID());
            this.threadsList.remove(thread.getThreadID());
        }
    }

    public void cancel(String id) {
        ProcessThread t = this.threadsList.get(id);
        if (t != null) {
            t.cancel();
        }
    }

    public void outputAllThreads(XMLWriter xml) throws IOException {
        xml.openElement("threads");
        for (ProcessThread t : this.threadsList.values()) {
            if (t == null) continue;
            t.toXML(xml);
        }
        xml.closeElement();
    }

    public void outputThreadsForGroup(@Nullable Long groupId, XMLWriter xml) throws IOException {
        if (groupId == null) {
            this.outputAllThreads(xml);
            return;
        }
        xml.openElement("threads");
        Collection<String> ids = this.threadsPerGroup.get(groupId);
        if (ids != null) {
            for (String id : ids) {
                if (!this.threadsList.containsKey(id)) continue;
                this.threadsList.get(id).toXML(xml);
            }
        }
        xml.closeElement();
    }

    public void outputSingleThread(String id, XMLWriter xml) throws IOException {
        ProcessThread t = this.threadsList.get(id);
        if (t != null) {
            t.toXML(xml);
        }
    }

    public Set<String> getThreadIDs() {
        return Collections.unmodifiableSet(this.threadsList.keySet());
    }

    public ProcessThread getThread(String id) {
        return this.threadsList.get(id);
    }

    public void shutdown() {
        this.threadPool.shutdown();
        this.cleanupThread.stop();
        if (!this.threadsList.isEmpty()) {
            try {
                this.threadPool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Shutdown interrupted before cancelling all threads", (Throwable)ex);
            }
            for (ProcessThread thread : this.threadsList.values()) {
                thread.cancel();
            }
            try {
                this.threadPool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Shutdown interrupted after cancelling all threads", (Throwable)ex);
            }
        }
    }

    public final class CleanUpThread
    implements Runnable {
        private static final long DELAY = 5000L;
        private static final long TIMEOUT = 61000L;
        private boolean shouldStop = false;

        @Override
        public void run() {
            while (!this.shouldStop) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                for (ProcessThread th : ProcessManager.this.threadsList.values()) {
                    if (System.currentTimeMillis() - th.getLastUpdated() <= 61000L) continue;
                    ProcessManager.this.clearIfFinished(th.getThreadID());
                }
            }
        }

        public void stop() {
            this.shouldStop = true;
        }
    }
}

