/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.security.HOTPGenerator;
import java.security.InvalidKeyException;
import java.security.Key;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;

public class TOTPGenerator {
    private final HOTPGenerator hotp;
    private final Duration timeStep;
    public static final Duration DEFAULT_TIME_STEP = Duration.ofSeconds(30L);
    public static final String TOTP_ALGORITHM_HMAC_SHA1 = "HmacSHA1";
    public static final String TOTP_ALGORITHM_HMAC_SHA256 = "HmacSHA256";
    public static final String TOTP_ALGORITHM_HMAC_SHA512 = "HmacSHA512";

    public TOTPGenerator() {
        this(DEFAULT_TIME_STEP);
    }

    public TOTPGenerator(Duration timeStep) {
        this(timeStep, HOTPGenerator.DEFAULT_CODE_LENGTH);
    }

    public TOTPGenerator(Duration timeStep, HOTPGenerator.CodeLength codeLength) {
        this(timeStep, codeLength, TOTP_ALGORITHM_HMAC_SHA1);
    }

    public TOTPGenerator(Duration timeStep, HOTPGenerator.CodeLength codeLength, String algorithm) {
        this.hotp = new HOTPGenerator(codeLength, algorithm);
        this.timeStep = timeStep;
    }

    public int generateOneTimePassword(Key key, Instant timestamp) throws InvalidKeyException {
        return this.hotp.generateOneTimePassword(key, timestamp.toEpochMilli() / this.timeStep.toMillis());
    }

    public String generateOneTimePasswordString(Key key, Instant timestamp) throws InvalidKeyException {
        return this.generateOneTimePasswordString(key, timestamp, Locale.getDefault());
    }

    public String generateOneTimePasswordString(Key key, Instant timestamp, Locale locale) throws InvalidKeyException {
        return this.hotp.formatOneTimePassword(this.generateOneTimePassword(key, timestamp), locale);
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }

    public int getCodeLength() {
        return this.hotp.getCodeLength();
    }

    public String getAlgorithm() {
        return this.hotp.getAlgorithm();
    }
}

