/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.jwt.IDTokenValidator;
import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.logback.AccessLogger;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.SecurityConfig;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.security.AccountLockout;
import com.pageseeder.base.security.ArgonPassword;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.security.ClamAVClient;
import com.pageseeder.base.security.IdentityConfig;
import com.pageseeder.base.security.LockedAccountException;
import com.pageseeder.base.security.MalwareScanner;
import com.pageseeder.base.security.MalwareTestClient;
import com.pageseeder.base.security.PasswordFormat;
import com.pageseeder.base.security.PasswordFormatException;
import com.pageseeder.base.security.SimplePassword;
import com.pageseeder.base.util.Cookies;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.base.web.WebTransaction;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import io.jsonwebtoken.Claims;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.smith.PasswordConfig;
import org.pageseeder.smith.PasswordMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityUtils.class);
    public static final String COOKIE_NAME_TOKEN = "pslogin.token";
    public static final String COOKIE_NAME_USER = "pslogin.cookie1";
    public static final String COOKIE_NAME_PASSWORD = "pslogin.cookie2";
    public static final String IGNORE_LOGIN_COOKIE = "pslogin.ignore.cookie";
    private static final String PASSWORD_ALGORITHM_PROPERTY = "passwordAlgorithm";
    private static final String PASSWORD_ALGORITHM_DEFAULT = "s5";
    private static final int DEFAULT_SESSION_TIMEOUT = 120;
    private static final String LOGIN_TRANSACTION_NAME = "Login";
    public static final String SESSION_MEMBERID = "ps-memberid";
    public static final String SESSION_USERNAME = "ps-username";
    private static final String ARCHIVED_GROUPS_OBJECT = "ps-archived-groups";
    public static final String REQUEST_MEMBERID = "ps-memberid";
    public static final String REQUEST_USERNAME = "ps-username";
    public static final String REQUEST_TOKEN = "ps-token";
    public static final String CONTEXT_ATTRIBUTE_MEMBER_ID = "last.login.memberid";
    public static final String CONTEXT_ATTRIBUTE_TIMESTAMP = "last.login.timestamp";
    private static volatile @Nullable PasswordConfig passwordConfig = null;
    private static volatile @Nullable IdentityConfig identityConfig = null;

    private SecurityUtils() {
    }

    public static boolean checkPassword(Database db, String[] credentials, String remoteIP) throws LockedAccountException {
        if (credentials.length < 2) {
            return false;
        }
        boolean res = false;
        String username = credentials[0];
        String password = credentials[1];
        if (AccountLockout.isLoginLocked(username)) {
            SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Attempt to access locked out account");
            throw new LockedAccountException(username);
        }
        try {
            String storedPassword;
            Member mem = DatabaseQuery.getMemberByUsername((Database)db, (String)username);
            if (mem == null) {
                mem = DatabaseQuery.getMemberByEmail((Database)db, (String)username);
            }
            if (SecurityUtils.checkApiAccount(username) && !SecurityUtils.checkApiAccountIP(remoteIP)) {
                SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Attempt to login using API account from invalid IP address");
                LOGGER.warn("Attempt to login using API account {} from invalid IP address {}", (Object)username, (Object)remoteIP);
                mem = null;
            } else if (mem != null && SecurityUtils.checkPassword(password, storedPassword = mem.getPassword())) {
                res = true;
            }
            if (res) {
                credentials[0] = mem.getUsername();
                AccountLockout.unlockLogin(username);
            } else {
                if (!SecurityUtils.checkApiAccount(username)) {
                    AccountLockout.badLogin(username);
                } else {
                    SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Failed login attempt for API account {}", username);
                }
                if (mem == null) {
                    try {
                        SecurityUtils.encodeAndSaltPassword(password == null ? "a password" : password);
                    }
                    catch (PasswordFormatException ex) {
                        LOGGER.debug("Failed to encode password", (Throwable)ex);
                    }
                }
            }
        }
        catch (FoundationException | DatabaseException ex) {
            SecurityLog.error(SecurityLog.EventType.AUTHENTICATION, "Error while trying check password for member: " + username);
            LOGGER.error("Unable to check password for member: {}", (Object)username, (Object)ex);
        }
        return res;
    }

    public static boolean checkIDToken(Database db, String token, String remoteIP) {
        Member member = SecurityUtils.identifyMember(db, token, remoteIP);
        return member != null;
    }

    public static @Nullable Member identifyMember(Database db, String token, String remoteIP) {
        IDTokenValidator validator = new IDTokenValidator();
        Member mem = null;
        try {
            Claims claims = validator.validate(token);
            if (claims == null) {
                return null;
            }
            String email = (String)claims.get("email", String.class);
            LOGGER.debug("ID Token email: {}", (Object)email);
            if (email == null) {
                return null;
            }
            mem = DatabaseQuery.getMemberByEmail((Database)db, (String)email);
            LOGGER.debug("ID Token member: {}", (Object)(mem != null ? mem.getUsername() : null));
            if (mem == null) {
                return null;
            }
            String username = mem.getUsername();
            if (SecurityUtils.checkApiAccount(username) && !SecurityUtils.checkApiAccountIP(remoteIP)) {
                SecurityLog.warn(SecurityLog.EventType.AUTHENTICATION, "Attempt to login using API account {} from invalid IP address {}", username, remoteIP);
                return null;
            }
            AccountLockout.unlockLogin(username);
        }
        catch (DatabaseException ex) {
            LOGGER.error("Unable to identify member", (Throwable)ex);
        }
        return mem;
    }

    public static PasswordFormat toPasswordFormat(@Nullable String algorithmOrPasswordHash) throws PasswordFormatException {
        if (algorithmOrPasswordHash == null || algorithmOrPasswordHash.isEmpty()) {
            throw new PasswordFormatException("Unspecified password format");
        }
        String alg = algorithmOrPasswordHash;
        char c = algorithmOrPasswordHash.charAt(0);
        if (c == 's') {
            if (alg.length() > 2) {
                alg = alg.substring(0, 2);
            }
            return SimplePassword.getInstance(alg);
        }
        if (c == 'a') {
            int endOfAlgorithm = alg.indexOf(36);
            if (endOfAlgorithm != -1) {
                alg = alg.substring(0, endOfAlgorithm);
            }
            return ArgonPassword.getInstance(alg);
        }
        if (c == 'p' && alg.length() == 2) {
            return ArgonPassword.getPreset(alg);
        }
        throw new PasswordFormatException("Unrecognized password format");
    }

    public static boolean checkPassword(String enteredPassword, @Nullable String storedPassword) throws PasswordFormatException {
        return SecurityUtils.toPasswordFormat(storedPassword).check(enteredPassword, storedPassword);
    }

    public static boolean checkApiAccount(String username) {
        if (Strings.isEmpty((String)username)) {
            return false;
        }
        String usernames = GlobalSettings.getString((String)"apiAccountUsernames", (String)"") + ",";
        return usernames.contains(username + ",");
    }

    public static boolean checkApiAccountIP(String ip) {
        String ips = GlobalSettings.getString((String)"apiAccountIPs", (String)"") + ",";
        return ips.contains(ip + ",");
    }

    public static String getRemoteIP(HttpServletRequest req) {
        String real = req.getHeader("X-Real-IP");
        return real != null ? real : req.getRemoteAddr();
    }

    public static String getUserAgent(HttpServletRequest req) {
        String userAgent = req.getHeader("User-Agent");
        if (userAgent == null) {
            return "";
        }
        if (userAgent.length() > 255) {
            userAgent = userAgent.substring(0, 255);
        }
        userAgent = userAgent.replaceAll("[^a-zA-Z0-9 .;,_/)(-]", "");
        return userAgent;
    }

    public static String encodeAndSaltPassword(String password) throws PasswordFormatException {
        String algorithm = GlobalSettings.getString((String)PASSWORD_ALGORITHM_PROPERTY, (String)PASSWORD_ALGORITHM_DEFAULT);
        return SecurityUtils.toPasswordFormat(algorithm).encode(password);
    }

    public static UserDetails getDefaultUserDetails() {
        UserDetails.Builder details = new UserDetails.Builder();
        details.setFlags("public", "");
        return details.build();
    }

    public static UserDetails getUserDetails(Database db, @Nullable Long memberid, boolean archivedGroups) {
        UserDetails.Builder details = new UserDetails.Builder();
        details.setFlags("public", "");
        if (memberid != null) {
            try {
                Member mem = DatabaseQuery.getMemberById((Database)db, (Long)memberid);
                if (mem != null) {
                    List<Membership> memberships = MemberForGroupRule.getMemberMemberships(mem.getGroupsForMemberCol((Object)Predicates.predicateMemberForGroupRegistered((Database)db, (boolean)archivedGroups)), true, db);
                    for (Membership membership : memberships) {
                        Object flags;
                        Group grp = membership.getGroup();
                        if (grp.hasFlag('d') && !archivedGroups) continue;
                        Role role = membership.getRole();
                        Object object = flags = role == null ? "" : role.getFlags();
                        if (flags == null) {
                            flags = "";
                        }
                        if (role != null && role.isEditor()) {
                            flags = (String)flags + "c";
                            if (grp.hasFlag('u')) {
                                flags = (String)flags + "u";
                            }
                        }
                        details.setFlags(grp.getName(), (String)flags);
                        if (grp.getName().indexOf(45) == -1) continue;
                        String grpname = grp.getName();
                        while (grpname.indexOf(45) != -1) {
                            Group project;
                            String projectname;
                            grpname = projectname = grpname.substring(0, grpname.lastIndexOf(45));
                            if (details.contains(projectname) || (project = DatabaseQuery.getGroupByName((Database)db, (String)projectname)) == null || project.getFlags() == null || project.getFlags().indexOf(102) == -1) continue;
                            details.setFlags(projectname, "gi");
                        }
                    }
                }
            }
            catch (DatabaseException ex) {
                LOGGER.error("Unable to get user details", (Throwable)ex);
            }
        }
        return details.build();
    }

    public static @Nullable String getUsername(HttpServletRequest req) {
        Object usernameObj;
        HttpSession session;
        String username = (String)req.getAttribute("ps-username");
        if (username == null && (session = req.getSession(false)) != null && (usernameObj = session.getAttribute("ps-username")) != null) {
            username = usernameObj.toString();
        }
        return username;
    }

    public static @Nullable String getUserToken(HttpServletRequest req) {
        return (String)req.getAttribute(REQUEST_TOKEN);
    }

    public static boolean getArchivedGroups(HttpSession session) {
        Boolean archivedGroups = (Boolean)session.getAttribute(ARCHIVED_GROUPS_OBJECT);
        return archivedGroups == Boolean.TRUE;
    }

    public static boolean isLoggedIn(HttpServletRequest req) {
        return SecurityUtils.getAuthenticatedMemberId(req) != null;
    }

    public static boolean isLicenseExpired() {
        String expires = GlobalSettings.getString((String)"licenseExpires", (String)"");
        if (!expires.isEmpty()) {
            try {
                if (!ISO8601.CALENDAR_DATE.parse(expires).after(new Date())) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    public static @Nullable MalwareScanner getMalwareScanner() {
        String host;
        String malwareScannerType = GlobalSettings.getString((String)"malwareScannerType", (String)"none");
        if (malwareScannerType.equalsIgnoreCase("clamav-daemon") && (host = GlobalSettings.get((String)"malwareScannerHost")) != null) {
            int port = GlobalSettings.getInt((String)"malwareScannerPort", (int)3310);
            return new ClamAVClient(host, port);
        }
        return null;
    }

    public static @Nullable Long getSessionMemberId(HttpSession session) {
        return (Long)session.getAttribute("ps-memberid");
    }

    public static @Nullable Long getAuthenticatedMemberId(HttpServletRequest req) {
        return (Long)req.getAttribute("ps-memberid");
    }

    public static @Nullable MalwareScanner getMalwareClient() {
        ClamAVClient client = null;
        String scanner = GlobalSettings.getString((String)"malwareScanner", (String)"");
        int i = scanner.indexOf(58);
        if (i != -1) {
            String host = scanner.substring(0, i);
            try {
                int port = Integer.parseInt(scanner.substring(i + 1));
                client = new ClamAVClient(host, port);
            }
            catch (NumberFormatException ex) {
                LOGGER.error("malwareScanner global property port invalid");
            }
        }
        if ("test".equals(scanner)) {
            return new MalwareTestClient();
        }
        return client;
    }

    public static void logout(Database db, HttpServletRequest req, @Nullable HttpServletResponse res) throws DatabaseException {
        HttpSession session;
        if (res != null) {
            SecurityUtils.removeRememberMeCookie(db, req, res);
        }
        if ((session = req.getSession(false)) != null) {
            SecurityLog.info(SecurityLog.EventType.AUTHENTICATION, "User signed out");
            SecurityUtils.logEvent(req, (String)session.getAttribute("ps-username"), "logout");
            session.removeAttribute("ps-memberid");
            session.removeAttribute(ARCHIVED_GROUPS_OBJECT);
            session.removeAttribute("ps-username");
            session.setAttribute(IGNORE_LOGIN_COOKIE, (Object)"true");
            session.invalidate();
        }
    }

    private static void logEvent(HttpServletRequest req, String username, String page) {
        AccessEvent access = AccessEvent.newInstance(req, username);
        access.setComponent("security", page);
        access.setPermission(AccessEvent.Permission.MEMBER);
        AccessLogger.track(access);
    }

    public static void resource(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        String loginPath = "/ui/signin.html";
        String location = null;
        if ("GET".equalsIgnoreCase(req.getMethod())) {
            location = req.getRequestURL().toString() + "?" + (String)(req.getQueryString() != null && !"".equals(req.getQueryString()) ? req.getQueryString() + "&t=" : "t=") + new Date().getTime();
        }
        if (session != null) {
            WebTransaction wtr = new WebTransaction(session, LOGIN_TRANSACTION_NAME, false);
            if (location != null) {
                wtr.add("location", location);
            }
        }
        res.setStatus(401);
        req.setAttribute("com.pageseeder.http_method", (Object)"GET");
        req.getRequestDispatcher(loginPath).forward((ServletRequest)req, (ServletResponse)res);
    }

    public static void setArchivedGroups(boolean archived, HttpSession session) {
        session.setAttribute(ARCHIVED_GROUPS_OBJECT, (Object)archived);
    }

    public static void updateUserDetails(HttpServletRequest req) {
        Long memberId = SecurityUtils.getAuthenticatedMemberId(req);
        if (memberId != null) {
            UserDetailsManager userManager = new UserDetailsManager();
            userManager.remove(memberId);
        }
    }

    public static UserDetails login(Database db, String username, HttpServletRequest req) {
        return SecurityUtils.login(db, username, req, false);
    }

    public static UserDetails login(Database db, String username, HttpServletRequest req, boolean reload) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        session = req.getSession(true);
        session.setMaxInactiveInterval(GlobalSettings.getInt((String)"sessionTimeout", (int)120) * 60);
        UserDetails details = SecurityUtils.getDefaultUserDetails();
        try {
            Member mem = DatabaseQuery.getMemberByUsername((Database)db, (String)username);
            if (mem != null) {
                SecurityLog.setupUser(mem);
                UserDetailsManager userManager = new UserDetailsManager();
                if (reload) {
                    userManager.remove(mem.getId());
                }
                session.setAttribute("ps-memberid", (Object)mem.getId());
                session.setAttribute(ARCHIVED_GROUPS_OBJECT, (Object)Boolean.FALSE);
                session.setAttribute("ps-username", (Object)username);
                CSRF.attachAntiCSRFToken(session);
                details = userManager.get(db, mem.getId(), false);
                Long memid = (Long)req.getServletContext().getAttribute(CONTEXT_ATTRIBUTE_MEMBER_ID);
                Long timestamp = (Long)req.getServletContext().getAttribute(CONTEXT_ATTRIBUTE_TIMESTAMP);
                if (memid == null || !memid.equals(mem.getId()) || timestamp != null && System.currentTimeMillis() - timestamp > 5000L) {
                    req.getServletContext().setAttribute(CONTEXT_ATTRIBUTE_MEMBER_ID, (Object)mem.getId());
                    req.getServletContext().setAttribute(CONTEXT_ATTRIBUTE_TIMESTAMP, (Object)System.currentTimeMillis());
                    mem.setLastLogin(new Date());
                    new MembershipCache().remove(mem.getId());
                }
            } else {
                LOGGER.error("Unable to login for username: {}", (Object)username);
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Unable login for username: {}", (Object)username, (Object)ex);
        }
        SecurityLog.info(SecurityLog.EventType.AUTHENTICATION, "User signed in");
        SecurityUtils.logEvent(req, username, "login");
        return details;
    }

    public static void setRememberMeCookie(Database db, HttpServletRequest req, HttpServletResponse res, Member member) throws DatabaseException {
        PersistentToken token = PersistentToken.issuePSToken((Database)db, (Member)member, (PersistentToken.Purpose)PersistentToken.Purpose.remember_me, (String)req.getHeader("User-Agent"), (Duration)OrganizationManager.instance().getSecurityConfig().getTokenExpiration(SecurityConfig.TokenType.REMEMBER_ME));
        Cookies.setCookie(res, COOKIE_NAME_TOKEN, member.getId() + "!" + token.getActualToken());
    }

    public static @Nullable RememberMe checkRememberMeCookie(Database db, HttpServletRequest req, HttpServletResponse res) throws DatabaseException {
        HttpSession session = req.getSession(false);
        if (session != null && "true".equals(session.getAttribute(IGNORE_LOGIN_COOKIE))) {
            return null;
        }
        String tokenString = Cookies.getCookieValue(req, COOKIE_NAME_TOKEN);
        if (tokenString == null) {
            return null;
        }
        try {
            int i = tokenString.indexOf(33);
            if (i == -1) {
                return null;
            }
            String memberid = tokenString.substring(0, i);
            tokenString = tokenString.substring(i + 1);
            Member member = DatabaseQuery.getMemberById((Database)db, (Long)Long.valueOf(memberid));
            if (member == null || MemberRule.isMemberDisabled(member)) {
                return null;
            }
            PersistentToken token = OAuthQuery.getPersistentToken((Database)db, (String)tokenString, (Member)member);
            if (token == null || !token.hasPurpose(PersistentToken.Purpose.remember_me) || token.hasExpired()) {
                return null;
            }
            SecurityUtils.setRememberMeCookie(db, req, res, member);
            Transaction tr = new Transaction(db);
            tr.commitAndStart();
            return new RememberMe(member, token);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void removeRememberMeCookie(Database db, HttpServletRequest req, HttpServletResponse res) throws DatabaseException {
        String tokenString = Cookies.getCookieValue(req, COOKIE_NAME_TOKEN);
        if (tokenString != null) {
            try {
                int i = tokenString.indexOf(33);
                if (i != -1) {
                    PersistentToken token;
                    String memberid = tokenString.substring(0, i);
                    tokenString = tokenString.substring(i + 1);
                    Member member = DatabaseQuery.getMemberById((Database)db, (Long)Long.valueOf(memberid));
                    if (member != null && (token = OAuthQuery.getPersistentToken((Database)db, (String)tokenString, (Member)member)) != null && token.hasPurpose(PersistentToken.Purpose.remember_me)) {
                        token.delete(db);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Cookies.removeCookie(res, COOKIE_NAME_TOKEN);
    }

    public static PasswordConfig getPasswordConfig() {
        PasswordConfig config = passwordConfig;
        if (config == null) {
            config = passwordConfig = SecurityUtils.loadPasswordConfig();
        }
        return config;
    }

    public static IdentityConfig getIdentityConfig() {
        return SecurityUtils.getIdentityConfig(false);
    }

    public static IdentityConfig getIdentityConfig(boolean reload) {
        if (identityConfig == null || reload) {
            identityConfig = SecurityUtils.loadIdentityConfig();
        }
        return identityConfig;
    }

    public static boolean isPasswordAtLeast(String password, String level) {
        PasswordConfig c = SecurityUtils.getPasswordConfig();
        PasswordMeter meter = new PasswordMeter(c);
        return meter.isAtLeast(password, level);
    }

    public static void reloadPasswordConfig() {
        passwordConfig = SecurityUtils.loadPasswordConfig();
    }

    public static synchronized PasswordConfig loadPasswordConfig() {
        String context = Settings.getContextPath();
        File file = new File(context, "WEB-INF/config/password.xml");
        if (!file.exists()) {
            file = new File(context, "WEB-INF/sysconfig/password.xml");
        }
        PasswordConfig conf = PasswordConfig.load((File)file);
        PasswordMeter meter = new PasswordMeter(conf);
        File js = new File(context, "weborganic/ui/js/password.js");
        try (FileWriter script = new FileWriter(js);){
            meter.toScript((Appendable)script);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load password configuration", (Throwable)ex);
        }
        return conf;
    }

    public static synchronized IdentityConfig loadIdentityConfig() {
        String context = Settings.getContextPath();
        File file = new File(context, "WEB-INF/config/identity-config.xml");
        File legacyFile = new File(context, "WEB-INF/config/external-identity.xml");
        if (file.exists()) {
            if (legacyFile.exists()) {
                LOGGER.warn("Your configuration defines both `identity-config.xml` and `external-identity.xml`");
            }
            LOGGER.info("Loading identity config file: {} ", (Object)file.getAbsolutePath());
            return IdentityConfig.load(file);
        }
        if (legacyFile.exists()) {
            LOGGER.warn("Loading legacy identity config file: {} ", (Object)legacyFile.getAbsolutePath());
            return IdentityConfig.load(legacyFile);
        }
        LOGGER.info("No identity config file found");
        return IdentityConfig.defaultConfig();
    }

    public static class RememberMe {
        public final Member member;
        public final PersistentToken token;

        private RememberMe(Member member, PersistentToken token) {
            this.member = member;
            this.token = token;
        }
    }
}

