/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.security.DigestException;
import com.pageseeder.base.security.KeyStorage;
import com.pageseeder.base.security.KeyStorageException;
import com.pageseeder.common.util.BinaryFormat;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HMAC {
    private static final Logger LOGGER = LoggerFactory.getLogger(HMAC.class);
    private static final String HMAC_ALGORITHM = "HmacSHA256";

    private HMAC() {
    }

    public static String digest(String keyAlias, String value, BinaryFormat format) throws KeyStorageException, DigestException {
        SecretKey key = KeyStorage.getInstance().getSecretKey(keyAlias, KeyStorage.KeyType.HMAC_SHA_256);
        return HMAC.digest(key, value, format);
    }

    public static String digest(Key key, String value, BinaryFormat format) throws DigestException {
        try {
            Mac mac = Mac.getInstance(HMAC_ALGORITHM);
            mac.init(key);
            byte[] bytes = mac.doFinal(value.getBytes(StandardCharsets.UTF_8));
            return format.encode(bytes);
        }
        catch (GeneralSecurityException ex) {
            throw new DigestException("Unable to generate digest", ex);
        }
    }

    public static @Nullable String digestSilently(String keyAlias, String value, BinaryFormat format) {
        try {
            return HMAC.digest(keyAlias, value, format);
        }
        catch (GeneralSecurityException ex) {
            LOGGER.warn("Unable to generate digest: {}", (Object)ex.getMessage());
            return null;
        }
    }

    public static @Nullable String digestSilently(Key key, String value, BinaryFormat format) {
        try {
            return HMAC.digest(key, value, format);
        }
        catch (DigestException ex) {
            LOGGER.warn("Unable to generate digest: {}", (Object)ex.getMessage());
            return null;
        }
    }
}

