/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.security.MalwareScanner;
import com.pageseeder.base.security.ScanResult;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClamAVClient
implements MalwareScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClamAVClient.class);
    private static final int CHUNK_SIZE = 2048;
    private static final int CONNECTION_TIMEOUT_MS = 2000;
    private static final int READ_TIMEOUT_MS = 300000;
    public static final int DEFAULT_PORT = 3310;
    private final String hostname;
    private final int port;

    public ClamAVClient(String hostname) {
        this.hostname = hostname;
        this.port = 3310;
    }

    public ClamAVClient(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public boolean isAvailable() {
        return this.ping();
    }

    /*
     * Exception decompiling
     */
    @Override
    public ScanResult scan(InputStream input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ScanResult parseResults(@Nullable String result) {
        if (result == null || result.isEmpty()) {
            return new ScanResult(ScanResult.Status.ERROR, "");
        }
        if ("stream: OK".equals(result)) {
            return new ScanResult(ScanResult.Status.OK, result);
        }
        if (result.endsWith("FOUND")) {
            String signature = result.substring("stream:".length(), result.lastIndexOf("FOUND") - 1).trim();
            return new ScanResult(ScanResult.Status.VIRUS_FOUND, result, signature);
        }
        if (result.endsWith("ERROR")) {
            return new ScanResult(ScanResult.Status.ERROR, result);
        }
        return new ScanResult(ScanResult.Status.VIRUS_FOUND, result);
    }

    public boolean ping() {
        try {
            return this.sendCommand(Command.PING).trim().equalsIgnoreCase("PONG");
        }
        catch (Exception ex) {
            SecurityLog.warn(SecurityLog.EventType.OTHER, "Unable to ping ClamAV", ex.getMessage());
            return false;
        }
    }

    public String version() throws IOException {
        return this.sendCommand(Command.VERSION).trim();
    }

    public String stats() throws IOException {
        return this.sendCommand(Command.STATS).trim();
    }

    private String sendCommand(Command command) throws IOException {
        StringWriter response = new StringWriter();
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(this.hostname, this.port), 2000);
            socket.setSoTimeout(300000);
            try (DataOutputStream dos = new DataOutputStream(socket.getOutputStream());){
                dos.write(command.toBytes());
                dos.flush();
                InputStream is = socket.getInputStream();
                int read = 2048;
                byte[] buffer = new byte[2048];
                while (read == 2048) {
                    try {
                        read = is.read(buffer);
                    }
                    catch (IOException ex) {
                        LOGGER.error("Error reading result from socket", (Throwable)ex);
                        break;
                    }
                    response.write(new String(buffer, 0, read));
                }
            }
        }
        return response.toString();
    }

    public static enum Command {
        INSTREAM,
        PING,
        VERSION,
        STATS;


        byte[] toBytes() {
            return ("z" + this.name() + "\u0000").getBytes();
        }
    }
}

