/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URISharing;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.FragmentIDsLoader;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.io.CharsetDetector;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.net.URLs;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Rules;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.db.util.URIs;
import com.pageseeder.db.util.XLinks;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public final class URIRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(URIRule.class);
    public static final String SLASH = "/";

    private URIRule() {
    }

    public static boolean belongsToGroup(Database db, Long uri, String group) throws DatabaseException {
        Collection groups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri);
        for (Group g : groups) {
            if (!group.equals(g.getName())) continue;
            return true;
        }
        return false;
    }

    public static URI createURIForSchemeHostPortPathType(Database db, Transaction tr, String scheme, String host, Integer port, String path, String type) throws DatabaseException {
        return URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleType(db, tr, scheme, host, port, path, null, null, null, type, true);
    }

    public static URI createURIForSchemeHostPortPathBehaviorDescLabels(Database db, Transaction tr, String scheme, String host, Integer port, String path, String behavior, String description, String[] labels, Member author) throws DatabaseException {
        return URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabels(db, tr, scheme, host, port, path, behavior, description, null, null, labels, true);
    }

    public static URI createURIForSchemeHostPortPathBehaviorDescUserTitleType(Database db, @Nullable Transaction tr, String uriScheme, String uriHost, Integer uriPort, String uriPath, @Nullable String behavior, @Nullable String description, @Nullable String userTitle, @Nullable String type, boolean guriReq) throws DatabaseException {
        return URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeGroupURIs(db, tr, uriScheme, uriHost, uriPort, uriPath, behavior, description, userTitle, type, guriReq, URIRule.matchGroupURIs(db, uriScheme, uriHost, uriPort, uriPath));
    }

    public static URI createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabels(Database db, @Nullable Transaction tr, String uriScheme, String uriHost, Integer uriPort, String uriPath, @Nullable String behavior, @Nullable String description, @Nullable String userTitle, @Nullable String type, String @Nullable [] labels, boolean guriReq) throws DatabaseException {
        return URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabelsGroupURIs(db, tr, uriScheme, uriHost, uriPort, uriPath, behavior, description, userTitle, type, labels, guriReq, URIRule.matchGroupURIs(db, uriScheme, uriHost, uriPort, uriPath));
    }

    public static URI createURIForSchemeHostPortPathBehaviorDescUserTitleTypeGroupURIs(Database db, @Nullable Transaction tr, String uriScheme, String uriHost, Integer uriPort, String uriPath, @Nullable String behavior, @Nullable String description, @Nullable String userTitle, @Nullable String type, boolean guriReq, Collection<GroupURI> groupuris) throws DatabaseException {
        return URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabelsGroupURIs(db, tr, uriScheme, uriHost, uriPort, uriPath, behavior, description, userTitle, type, null, guriReq, groupuris);
    }

    public static URI createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabelsGroupURIs(Database db, @Nullable Transaction tr, String uriScheme, String uriHost, Integer uriPort, String uriPath, @Nullable String behavior, @Nullable String description, @Nullable String userTitle, @Nullable String type, String @Nullable [] labels, boolean guriReq, Collection<GroupURI> groupuris) throws DatabaseException {
        URI uri = null;
        Iterator<GroupURI> imatches = groupuris.iterator();
        if (imatches.hasNext() || !guriReq) {
            Host host = DatabaseQuery.getHostByName((Database)db, (String)uriHost);
            if (host == null) {
                throw new DatabaseException("Host does not exist: " + uriHost);
            }
            uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)uriScheme, (String)host.getName(), (Integer)uriPort, (String)uriPath);
            if (uri != null) {
                throw new DatabaseException("URI already exist: " + uriPath);
            }
            uri = URI.create((Database)db);
            uri.setScheme(uriScheme);
            uri.setPath(uriPath);
            uri.setHost(host);
            uri.setPort(uriPort);
            uri.setBehavior(behavior);
            uri.setType(type);
            uri = uri.insert(db);
            if (userTitle != null && !userTitle.isEmpty()) {
                uri.setUserTitle(userTitle);
            }
            if (description != null && !description.isEmpty()) {
                uri.setDescription(description);
            }
            while (imatches.hasNext()) {
                GroupURI guri = imatches.next();
                uri.addGroupURIs(guri);
            }
            if (labels != null && labels.length != 0) {
                Labels.setLabels((URI)uri, (String[])labels);
            }
            if (tr != null) {
                tr.commitAndStart();
            }
        }
        return uri;
    }

    public static URI createURIForSchemeHostPortPathUserTitle(Database db, Transaction tr, String uriScheme, String uriHost, Integer uriPort, String uriPath, String userTitle, boolean guriReq) throws DatabaseException {
        return URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleType(db, tr, uriScheme, uriHost, uriPort, uriPath, null, null, userTitle, null, guriReq);
    }

    public static URI createURIForURLDocidBehaviorDescUserTitleType(Database db, Transaction tr, URL url, @Nullable String docid, @Nullable String behavior, @Nullable String description, @Nullable String userTitle, @Nullable String type) throws DatabaseException {
        return URIRule.createURIForURLDocidBehaviorDescUserTitleType(db, tr, url, docid, behavior, description, userTitle, type, true);
    }

    public static URI createURIForURLDocidBehaviorDescUserTitleType(Database db, Transaction tr, URL url, String docid, String behavior, String description, String userTitle, String type, boolean externalHost) throws DatabaseException {
        boolean external;
        URI uri;
        String path;
        if (url.getHost() == null || url.getHost().isEmpty()) {
            throw new DatabaseException("URL host invalid: " + url);
        }
        if (!URIRule.isValidDocumentID(docid)) {
            throw new DatabaseException("Invalid characters in Document ID");
        }
        int url_port = url.getPort() == -1 ? Rules.getDefaultPort((String)url.getProtocol()) : url.getPort();
        String hostname = url.getHost().toLowerCase();
        Host host = DatabaseQuery.getHostByName((Database)db, (String)(hostname = HostRule.resolveAlias(db, hostname)));
        if (host == null) {
            host = HostRule.createHost(db, hostname, externalHost);
        }
        if ((path = url.getFile()) == null || path.isEmpty()) {
            path = SLASH;
        }
        if ((uri = (external = URIRule.isExternal(url, host)) ? DatabaseQuery.getURIBySchemeHostIDPortPathCase((Database)db, (String)url.getProtocol(), (Long)host.getId(), (Integer)url_port, (String)path) : DatabaseQuery.getURIBySchemeHostIDPortPath((Database)db, (String)url.getProtocol(), (Long)host.getId(), (Integer)url_port, (String)path)) == null) {
            Iterator<GroupURI> imatches = URIRule.matchGroupURIs(db, url.getProtocol(), hostname, url_port, path).iterator();
            if (external || imatches.hasNext()) {
                uri = URI.create((Database)db);
                uri.setScheme(url.getProtocol());
                uri.setBehavior(behavior);
                uri.setType(type);
                uri.setHost(host);
                uri.setPort(Integer.valueOf(url_port));
                uri.setPath(path);
                uri = uri.insert(db);
                if (userTitle != null && !userTitle.isEmpty()) {
                    uri.setUserTitle(userTitle);
                }
                if (docid != null && !docid.isEmpty()) {
                    uri.setDocID(docid);
                }
                if (description != null && !description.isEmpty()) {
                    uri.setDescription(description);
                }
                while (imatches.hasNext()) {
                    GroupURI guri = imatches.next();
                    uri.addGroupURIs(guri);
                }
                if (tr != null) {
                    tr.commitAndStart();
                }
            }
        }
        return uri;
    }

    public static URL computeURL(String url, Database db) throws DatabaseException, MalformedURLException {
        URL original = new URL(url);
        String host = original.getHost();
        String protocol = original.getProtocol();
        int port = original.getPort();
        if (port == -1) {
            port = "https".equals(original.getProtocol()) ? 443 : 80;
        }
        String path = original.getPath();
        StringBuilder suffix = new StringBuilder();
        while (true) {
            URI uri;
            if ((uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)protocol, (String)host, (Integer)port, (String)RuleUtils.urlEncodeFilepath(path))) != null) {
                try {
                    return new URL(URLDecoder.decode(URIRule.getURIString(uri) + suffix, StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException ex) {
                    LOGGER.error("Failed to create URL {}", (Object)uri, (Object)ex);
                    continue;
                }
            }
            int slash = path.lastIndexOf(47);
            if (slash == -1) break;
            suffix.insert(0, path.substring(slash));
            path = path.substring(0, slash);
        }
        return original;
    }

    public static void deleteURI(Database db, URI uri) throws DatabaseException {
        Iterator loci = uri.getLocators();
        while (loci.hasNext()) {
            Locator loc = (Locator)loci.next();
            LocatorRule.deleteLocator(db, uri, loc);
            loc = null;
        }
        XLink xl = uri.getXLink();
        if (xl != null) {
            uri.setXLink(null);
            xl.removeReplies(xl);
            XLinkRule.deleteXLink(db, xl, true);
            xl = null;
        }
        uri.delete(db);
    }

    public static void deleteDirectory(String uriPath) throws DatabaseException {
        String real_path = URIRule.getRealPath(Settings.getContextPath(), uriPath);
        File dir = new File(real_path);
        String[] dir_list = dir.list();
        if (dir_list == null) {
            return;
        }
        for (String element : dir_list) {
            String file_path = real_path + File.separator + element;
            File file = new File(file_path);
            if (file.isDirectory()) {
                URIRule.deleteDir(file);
                continue;
            }
            if (file.delete()) continue;
            throw new DatabaseException("Could not delete " + file_path);
        }
        if (!dir.delete()) {
            throw new DatabaseException("Could not delete " + real_path);
        }
    }

    public static void deleteDir(File dir) throws DatabaseException {
        if (!dir.isDirectory()) {
            return;
        }
        String[] listing = dir.list();
        if (listing == null) {
            throw new DatabaseException("Directory does not exist " + dir.getPath());
        }
        for (String name : listing) {
            String file_path = dir.getPath() + File.separator + name;
            File file = new File(file_path);
            if (file.isDirectory()) {
                URIRule.deleteDir(file);
                continue;
            }
            if (file.delete()) continue;
            throw new DatabaseException("Could not delete " + file_path);
        }
        if (!dir.delete()) {
            throw new DatabaseException("Could not delete " + dir.getPath());
        }
    }

    public static URI getContainingURI(Database db, Long uri_id, Long reply_to_id, Long xlink_id) throws DatabaseException {
        URI uri = null;
        if (uri_id != null) {
            uri = DatabaseQuery.getURIById((Database)db, (Long)uri_id);
            if (uri == null) {
                throw new DatabaseException("URIRule: URIId not found: " + uri_id);
            }
        } else {
            XLink xl;
            if (reply_to_id != null) {
                xlink_id = reply_to_id;
            }
            if ((xl = DatabaseQuery.getXLinkById((Database)db, (Long)xlink_id)) == null) {
                throw new DatabaseException("URIRule: XLinkId not found: " + xlink_id);
            }
            Locator loc = LocatorRule.getLocatorByXLink(db, xl);
            uri = loc.getURI();
        }
        return uri;
    }

    public static String getContentType(URI uri) {
        if (uri == null) {
            return null;
        }
        String type = uri.getType();
        if (type == null) {
            String path = uri.getPath();
            int i = path.lastIndexOf(47);
            String filename = path.substring(i + 1);
            String ext = "";
            i = filename.lastIndexOf(46);
            if (i != -1) {
                ext = filename.substring(i + 1).toLowerCase();
            }
            type = Medias.getMediaType(ext);
        }
        return type;
    }

    public static Group getGroupForURI(Database db, Long id) throws DatabaseException {
        if (id == null) {
            return null;
        }
        URI uri = DatabaseQuery.getURIById((Database)db, (Long)id);
        Collection guris = uri.getGroupURIsCol();
        Collection grps = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)id);
        Iterator grpi = grps.iterator();
        Group uri_group = null;
        while (grpi.hasNext()) {
            Group grp = (Group)grpi.next();
            if (GroupRule.isPublicGroup(grp.getName())) continue;
            if (guris.contains(GroupURIRule.getDefaultGroupURI(grp))) {
                return grp;
            }
            uri_group = grp;
        }
        return uri_group;
    }

    public static Group getDefaultGroupForURI(Database db, Long id) throws DatabaseException {
        if (id == null) {
            return null;
        }
        return URIRule.getDefaultGroupForURI(DatabaseQuery.getURIById((Database)db, (Long)id));
    }

    public static Group getDefaultGroupForURI(URI uri) {
        if (uri == null) {
            return null;
        }
        Group found = null;
        Collection guris = uri.getGroupURIsCol();
        for (GroupURI guri : guris) {
            for (Group grp : guri.getGroupsCol()) {
                if (!GroupURIRule.isDefaultGroupURI(guri, grp) || found != null && found.getName().length() >= grp.getName().length()) continue;
                found = grp;
            }
        }
        return found;
    }

    public static @Nullable Group getDefaultGroupForURL(Database db, URL url) throws DatabaseException {
        if (url == null) {
            return null;
        }
        Group found = null;
        int url_port = url.getPort() == -1 ? Rules.getDefaultPort((String)url.getProtocol()) : url.getPort();
        String hostname = url.getHost();
        Host host = DatabaseQuery.getHostByName((Database)db, (String)(hostname = HostRule.resolveAlias(db, hostname)));
        if (host == null) {
            return null;
        }
        Collection<GroupURI> guris = URIRule.matchGroupURIs(db, url.getProtocol(), hostname, url_port, url.getFile());
        for (GroupURI guri : guris) {
            for (Group grp : guri.getGroupsCol()) {
                if (!GroupURIRule.isDefaultGroupURI(guri, grp) || found != null && found.getName().length() >= grp.getName().length()) continue;
                found = grp;
            }
        }
        return found;
    }

    public static Group getDefaultGroupForURINonNull(URI uri) throws QueryFailedException {
        Group group = URIRule.getDefaultGroupForURI(uri);
        if (group == null) {
            throw new QueryFailedException("Default group not found for URI ID: " + uri.getId());
        }
        return group;
    }

    public static Group getGroupForURI(Database db, Long uriId, Permissions perm) throws DatabaseException {
        return URIRule.getGroupForURI(db, uriId, perm.getUserDetails());
    }

    public static Group getGroupForURI(Database db, Long uriId, UserDetails userDetails) throws DatabaseException {
        if (uriId == null) {
            return null;
        }
        Set<String> disp_grps = userDetails.flags().keySet();
        URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriId);
        if (URIs.isExternal((URI)uri)) {
            for (String gname : disp_grps) {
                Group gp = DatabaseQuery.getGroupByName((Database)db, (String)gname);
                if (GroupRule.isProject(gp)) continue;
                return gp;
            }
        }
        Collection grps = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uriId);
        Group def_grp = null;
        for (Group group : grps) {
            if (!URIRule.isDefaultGroup(uri, group) || !disp_grps.contains((def_grp = group).getName())) continue;
            return def_grp;
        }
        Iterator grpi = grps.iterator();
        Group grp = null;
        while (grpi.hasNext()) {
            Group temp_grp = (Group)grpi.next();
            if (GroupRule.isPublicGroup(temp_grp.getName())) continue;
            if (disp_grps.contains(temp_grp.getName())) {
                grp = temp_grp;
                def_grp = null;
                break;
            }
            if (grp == null) {
                grp = temp_grp;
                continue;
            }
            if (grp.getFlags() != null && grp.getFlags().indexOf(112) != -1 || temp_grp.getFlags() == null || temp_grp.getFlags().indexOf(112) == -1) continue;
            grp = temp_grp;
            def_grp = null;
        }
        return def_grp != null ? def_grp : grp;
    }

    public static String getRealPath(String path) {
        return URIRule.getRealPath(Settings.getContextPath(), path);
    }

    public static String @Nullable [] getBehavior(@Nullable URI uri) {
        String behavior;
        String string = behavior = uri == null ? null : uri.getBehavior();
        if (behavior != null) {
            String[] beh = RuleUtils.delimitedEmptyToArray(behavior, "-", null);
            if (beh.length != 3) {
                LOGGER.warn("Behavior invalid: {}", (Object)behavior);
            } else {
                return beh;
            }
        }
        return null;
    }

    public static @Nullable String getStyleFormat(URI uri) {
        String[] behavior = URIRule.getBehavior(uri);
        if (behavior != null && behavior.length >= 1) {
            return behavior[0];
        }
        return null;
    }

    public static @Nullable String getStyleConfig(URI uri) {
        String[] behavior = URIRule.getBehavior(uri);
        if (behavior != null && behavior.length >= 2) {
            return behavior[1];
        }
        return null;
    }

    public static String getRealPath(String context_path, String uriPath) {
        uriPath = URLCoder.decode((String)uriPath);
        uriPath = uriPath.substring(GlobalSettings.getSitePrefix().length());
        Object real_path = context_path;
        if (((String)real_path).endsWith(File.separator)) {
            real_path = ((String)real_path).substring(0, ((String)real_path).length() - File.separator.length());
        }
        if (!(uriPath.toLowerCase().startsWith("/weborganic/") || uriPath.toLowerCase().startsWith("/woconfig/") || uriPath.toLowerCase().startsWith("/web-inf/"))) {
            real_path = Settings.getDocumentPath();
        }
        real_path = (String)real_path + uriPath.replace('/', File.separatorChar);
        return real_path;
    }

    public static List<XLink> getReleasesForURI(Database db, URI uri) throws QueryFailedException {
        return URIRule.getReleasesForURI(db, uri, null, 1, -1, null);
    }

    public static List<XLink> getReleasesForURI(Database db, URI uri, @Nullable Publication publication, int page, int pagesize, @Nullable LimitReached limit) throws QueryFailedException {
        ArrayList<XLink> releases = new ArrayList<XLink>();
        List root_releases = DatabaseQuery.getXLinksByURIRootReleaseAllGroups((Database)db, (URI)uri, (int)page, (int)pagesize, (limit != null ? 1 : 0) != 0);
        if (limit != null) {
            limit.reached = pagesize >= 0 && root_releases.size() > pagesize;
        }
        Iterator releasesi = root_releases.iterator();
        while (releasesi.hasNext()) {
            List replies;
            XLink xl = (XLink)releasesi.next();
            if (limit != null && limit.reached && !releasesi.hasNext()) continue;
            if (!XLinks.isArchived((XLink)xl)) {
                Collection att = xl.getAttached();
                if (!att.isEmpty()) {
                    XLink pub_xlink = ((XLinkForAttachedXLink)att.iterator().next()).getAttachedXLink();
                    if (!(XLinks.isArchived((XLink)pub_xlink) || publication != null && publication.getXLinkId() != pub_xlink.getId().longValue())) {
                        releases.add(xl);
                    }
                } else if (publication == null || publication.getXLinkId() < 0L) {
                    releases.add(xl);
                }
            }
            if (!"Documentation-Release".equals(xl.getContentRole()) || (replies = DatabaseQuery.getRepliesByArchivedAcceptedAllGroups((Database)db, (XLink)xl, (boolean)false, (boolean)true)) == null || replies.isEmpty()) continue;
            for (XLink reply : replies) {
                if (!"Documentation-Release".equals(reply.getContentRole()) || publication != null) continue;
                releases.add(reply);
            }
        }
        return releases;
    }

    public static List<XLink> getWorkflowsForURI(Database db, URI uri, @Nullable Member draftMember) throws QueryFailedException {
        ArrayList<XLink> workflows = new ArrayList<XLink>();
        List root_workflows = DatabaseQuery.getXLinksByURIRootWorkflowAllGroups((Database)db, (URI)uri);
        for (XLink xl : root_workflows) {
            List replies;
            if ((!XLinks.isArchived((XLink)xl) || !xl.getAuthorOnly().booleanValue() && "archive-Workflow".equals(xl.getContentRole()) || "archive-Documentation-Release".equals(xl.getContentRole())) && xl.getStatus() != null && (!xl.getAuthorOnly().booleanValue() || draftMember != null && draftMember.equals((Object)xl.getMember()))) {
                workflows.add(xl);
            }
            if ((replies = DatabaseQuery.getRepliesByArchivedAcceptedAllGroups((Database)db, (XLink)xl, (boolean)true, (boolean)false)) == null) continue;
            for (XLink reply : replies) {
                if (reply.getStatus() == null || "archive-Workflow".equals(reply.getContentRole()) && reply.getAuthorOnly().booleanValue() || reply.getAuthorOnly().booleanValue() && (draftMember == null || !draftMember.equals((Object)reply.getMember()))) continue;
                workflows.add(reply);
            }
        }
        return workflows;
    }

    public static @Nullable XLink getRootWorkflowForURI(Database db, URI uri) throws QueryFailedException {
        List root_workflows = DatabaseQuery.getXLinksByURIRootWorkflowAllGroups((Database)db, (URI)uri);
        if (root_workflows != null && !root_workflows.isEmpty()) {
            return (XLink)root_workflows.get(root_workflows.size() - 1);
        }
        return null;
    }

    public static XLink getLatestWorkflowForURI(Database db, XLink root) throws QueryFailedException {
        if (root == null) {
            return null;
        }
        XLink latest = null;
        List replies = DatabaseQuery.getRepliesByArchivedAcceptedAllGroups((Database)db, (XLink)root, (boolean)false, (boolean)true);
        if (replies != null && !replies.isEmpty()) {
            latest = (XLink)replies.get(replies.size() - 1);
        } else if (!XLinks.isArchived((XLink)root) && root.getStatus() != null) {
            latest = root;
        }
        return latest;
    }

    public static String getExtension(String filename) {
        int j = filename.lastIndexOf(46);
        if (j == -1) {
            return "";
        }
        return filename.substring(j + 1);
    }

    public static String[] getFilename(URI uri) {
        return URIRule.getFilename(URLCoder.decode((String)uri.getPath()));
    }

    public static String[] getFilename(String path) {
        int j;
        String filename = path;
        String ext = "";
        int i = path.lastIndexOf(47);
        if (i != -1) {
            filename = path.substring(i + 1);
        }
        if ((j = filename.lastIndexOf(46)) != -1) {
            ext = filename.substring(j);
            filename = filename.substring(0, j);
        }
        return new String[]{filename, ext};
    }

    public static String getFilenameAsString(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            return path;
        }
        return path.substring(i + 1);
    }

    public static URI getURIByLocator(Database db, Locator loc) {
        if (loc == null) {
            return null;
        }
        return loc.getURI();
    }

    public static URI getURIByXLink(XLink xlink) {
        String role;
        if (xlink == null) {
            return null;
        }
        XLink thread_root = XLinks.getThreadRoot((XLink)xlink);
        Iterator loci = thread_root.getLocatorsForXLink();
        LocatorForXLink lfx = null;
        while (loci.hasNext() && (role = (lfx = (LocatorForXLink)loci.next()).getRole()) != null && (role.contains("link") || role.contains("attachment"))) {
        }
        if (lfx == null) {
            return thread_root.getUri();
        }
        Locator loc = lfx.getLocator();
        return loc.getURI();
    }

    public static @Nullable URI getURIByURL(Database db, URL url) throws DatabaseException {
        int port = url.getPort() == -1 ? Rules.getDefaultPort((String)url.getProtocol()) : url.getPort();
        String hostname = url.getHost();
        Host host = HostRule.resolveHost(db, hostname);
        if (host == null) {
            return null;
        }
        String path = url.getFile();
        if (path == null || path.isEmpty()) {
            path = SLASH;
        }
        if (URIRule.isExternal(url, host)) {
            return DatabaseQuery.getURIBySchemeHostIDPortPathCase((Database)db, (String)url.getProtocol(), (Long)host.getId(), (Integer)port, (String)path);
        }
        return DatabaseQuery.getURIBySchemeHostIDPortPath((Database)db, (String)url.getProtocol(), (Long)host.getId(), (Integer)port, (String)path);
    }

    public static String getURIString(URI uri) {
        StringBuilder url = new StringBuilder(URIRule.getHostURL(uri));
        if (uri.getPath() != null) {
            url.append(uri.getPath());
        }
        return url.toString();
    }

    public static String getHostURL(URI uri) {
        Host host = uri.getHost();
        StringBuilder url = new StringBuilder();
        url.append(uri.getScheme()).append(':');
        if (!"mailto".equals(uri.getScheme())) {
            url.append("//");
        }
        if (host != null) {
            url.append(host.getName());
        }
        if (uri.getPort() != null && !URLs.isDefaultPort((String)uri.getScheme(), (int)uri.getPort())) {
            url.append(':').append(uri.getPort());
        }
        return url.toString();
    }

    public static String getURIString(String scheme, String host, Integer port, String path) {
        path = RuleUtils.removeJsessionid(path);
        path = URLCoder.encode((String)URLCoder.decode((String)path)).replaceAll("%2F", SLASH);
        return scheme + "://" + host + ":" + port + path;
    }

    public static Collection<GroupURI> matchGroupURIs(Database db, String uriScheme, String uriHost, Integer uriPort, String uriPath) throws DatabaseException {
        int i;
        ArrayList<GroupURI> matches = new ArrayList<GroupURI>();
        GroupURI guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)uriScheme, (String)uriHost, (Integer)uriPort, (String)(uriPath = uriPath.toLowerCase()));
        if (guri != null) {
            matches.add(guri);
        }
        if ((guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)uriScheme, (String)uriHost, (Integer)uriPort, (String)(uriPath + SLASH))) != null) {
            matches.add(guri);
        }
        if ((guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)uriScheme, (String)uriHost, (Integer)uriPort, (String)(uriPath + "/*"))) != null) {
            matches.add(guri);
        }
        if ((i = uriPath.lastIndexOf(47)) != -1) {
            Object subpath = uriPath.substring(0, i + 1);
            guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)uriScheme, (String)uriHost, (Integer)uriPort, (String)subpath);
            if (guri != null) {
                matches.add(guri);
            }
            subpath = (String)subpath + "*";
            while (subpath != null) {
                guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)uriScheme, (String)uriHost, (Integer)uriPort, (String)subpath);
                if (guri != null) {
                    matches.add(guri);
                }
                if ((i = ((String)subpath).lastIndexOf(47, ((String)subpath).length() - 3)) != -1) {
                    subpath = ((String)subpath).substring(0, i + 1) + "*";
                    continue;
                }
                subpath = null;
            }
        }
        return matches;
    }

    public static boolean isExternal(@Nullable URL url, Database db) {
        Host host;
        if (url == null) {
            return false;
        }
        String h = url.getHost();
        try {
            host = HostRule.resolveHost(db, h);
        }
        catch (QueryFailedException ex) {
            host = null;
        }
        return URIRule.isExternal(url, host);
    }

    public static boolean isExternal(@Nullable URL url, @Nullable Host host) {
        if (url == null) {
            return false;
        }
        if (host == null || host.isExternal()) {
            return true;
        }
        return !url.getPath().startsWith(GlobalSettings.getSitePrefix()) || URIs.matchesPSSourcePath((String)url.getPath());
    }

    public static boolean isExternal(@Nullable GroupURI guri) {
        return GroupURI.isExternal((GroupURI)guri);
    }

    public static boolean isArchived(@Nullable URI uri) {
        if (uri == null) {
            return false;
        }
        return uri.getExternal() != false ? uri.isArchived() : URIRule.isInternalArchived(uri);
    }

    public static boolean isArchivedGroup(@Nullable URI uri) {
        if (uri == null || uri.getExternal().booleanValue()) {
            return false;
        }
        return uri.getPath().startsWith(GlobalSettings.getSitePrefix() + "/archive/");
    }

    public static boolean isInternalArchived(URI uri) {
        if (uri == null) {
            return false;
        }
        if (!uri.getPath().contains("/archive/")) {
            return false;
        }
        Group def = URIRule.getDefaultGroupForURI(uri);
        if (def == null) {
            return false;
        }
        return GroupRule.isArchived(def) || uri.getPath().startsWith(GlobalSettings.getSitePrefix() + SLASH + def.getName().replace('-', '/') + "/archive/");
    }

    public static void updateGroupURIs(Database db, URI uri) throws DatabaseException {
        Collection cur_guri = uri.getGroupURIsCol();
        Collection<GroupURI> new_guri = URIRule.matchGroupURIs(db, uri.getScheme(), uri.getHost().getName(), uri.getPort(), uri.getPath());
        for (GroupURI guri : cur_guri) {
            if (new_guri.contains(guri)) continue;
            uri.removeGroupURIs(guri);
        }
        for (GroupURI guri : new_guri) {
            if (cur_guri.contains(guri)) continue;
            uri.addGroupURIs(guri);
        }
    }

    public static List<URI> ensureFolderURIsExist(Database db, Member member, String scheme, String host, Integer port, String path) throws DatabaseException {
        String escapedPath;
        String encodedPath;
        URI existing;
        Collection<GroupURI> guris = null;
        ArrayList<URI> created = new ArrayList<URI>();
        String newPath = path.replaceAll("/[^/]*$", "");
        while (newPath.indexOf(47) != -1 && (existing = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)(encodedPath = RuleUtils.urlEncodeFilepath(escapedPath = RuleUtils.replaceNonFolderCharsKeepSlashes(URLCoder.decode((String)newPath)))))) == null) {
            String usertitle = escapedPath.equals(newPath) ? null : URIRule.getFilenameAsString(escapedPath);
            existing = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleType(db, null, scheme, host, port, encodedPath, null, null, usertitle, "folder", true);
            if (existing != null) {
                created.add(existing);
                URIRule.addURIHistoryXLink(existing, member, existing.getDateCreated(), "creation", null, db);
            }
            boolean foundGURI = false;
            if (guris == null) {
                guris = URIRule.matchGroupURIs(db, scheme, host, port, encodedPath);
            }
            for (GroupURI guri : guris) {
                if (!GroupURIs.truncatePath((String)guri.getPath()).equals(encodedPath.toLowerCase())) continue;
                foundGURI = true;
                break;
            }
            if (foundGURI) break;
            newPath = newPath.replaceAll("/[^/]*$", "");
        }
        return created;
    }

    public static List<Long> updateLastModifedForXRefs(URI uri, Date date, Database db) throws QueryFailedException {
        ArrayList<Long> uriids = new ArrayList<Long>();
        Collection uris = DatabaseQuery.getURIsByURIXRefsAllGroups((Database)db, (URI)uri, (boolean)false);
        for (URI uri2 : uris) {
            uri2.setLastModified(date);
            uriids.add(uri2.getId());
        }
        return uriids;
    }

    public static URI getURIForGeneralDiscussion(Database db, @Nullable Transaction tr, Group grp) throws DatabaseException {
        String uri_user_title = "General";
        URI gen_uri = null;
        GroupURI guri = DatabaseQuery.getGeneralDiscussionGroupURI((Database)db, (Group)grp);
        if (guri != null && (gen_uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)(GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/" + grp.getId()))) == null) {
            gen_uri = URIRule.createURIForSchemeHostPortPathUserTitle(db, tr, guri.getScheme(), guri.getHost().getName(), guri.getPort(), GlobalSettings.get((String)"servletPrefix") + "/com.pageseeder.general/" + grp.getId(), uri_user_title, true);
        }
        return gen_uri;
    }

    public static boolean isValidDocumentID(String docId) {
        return docId == null || docId.matches("^([a-zA-Z0-9]|_|-)+$") && docId.length() <= 100;
    }

    public static boolean isValidDocumentType(String docType) {
        return docType.matches("^([a-zA-Z0-9]|_)+$") && docType.length() <= 50;
    }

    public static boolean isDefaultGroup(URI uri, Group group) {
        return URIRule.isDefaultGroup(uri, group.getName()) && !URIs.isExternal((URI)uri);
    }

    public static boolean isDefaultGroup(URI uri, String groupname) {
        String def_path = GlobalSettings.getSitePrefix() + SLASH + groupname.replace('-', '/');
        return uri.getPath().startsWith(def_path + SLASH) || uri.getPath().equals(def_path);
    }

    public static void addURIHistoryXLink(URI uri, Member author, Database db) throws DatabaseException {
        URIRule.addURIHistoryXLink(uri, author, null, null, null, db);
    }

    public static void addURIHistoryXLink(URI uri, Member author, @Nullable Date createdDate, @Nullable String type, String @Nullable [] labels, Database db) throws DatabaseException {
        URIRule.addURIHistoryXLink(uri, author, createdDate, null, type, labels, null, null, db);
    }

    public static void addURIHistoryXLink(URI uri, Member author, @Nullable Date createdDate, @Nullable String originalPath, @Nullable String type, String @Nullable [] labels, @Nullable String previousPath, @Nullable String version, Database db) throws DatabaseException {
        URIRule.addURIHistoryXLink(uri, author, createdDate, originalPath, type, labels, previousPath, version, null, db);
    }

    public static void addURIHistoryXLink(URI uri, Member author, Date createdDate, @Nullable String originalPath, @Nullable String type, String @Nullable [] labels, @Nullable String previousPath, @Nullable String version, byte[] content, Database db) throws DatabaseException {
        if (uri == null) {
            return;
        }
        XLink rootxl = uri.getXLink();
        XLink oldxl = rootxl;
        if (oldxl != null) {
            List reps = DatabaseQuery.getRepliesByGroupContentRoleDates((Database)db, (XLink)oldxl, null, (String[])new String[]{"uri-properties"}, null, null, null, (boolean)true);
            if (reps.isEmpty()) {
                oldxl.setStatus("Documentation-Old");
            } else {
                for (XLink rep : reps) {
                    rep.setStatus("Documentation-Old");
                    oldxl = rep;
                }
            }
        }
        Map props = ObjectProperties.toMap((String)(oldxl != null ? oldxl.getProperties() : null));
        if (oldxl != null && !props.containsKey("path") && previousPath != null) {
            props.put("path", Collections.singletonList(previousPath));
            oldxl.setProperties(ObjectProperties.toString((Map)props));
        }
        XLink xl = XLink.create((Database)db);
        xl.setDate(rootxl == null && createdDate != null ? createdDate : new Date());
        xl.setAccepted(Boolean.TRUE);
        xl.setModeratorOnly(Boolean.FALSE);
        xl.setContentRole("uri-properties");
        xl.setMember(author);
        if (type != null) {
            xl.setType(type);
        }
        xl.setContentTitle(uri.getUserTitle());
        if (!(labels == null || labels.length == 0 || labels.length == 1 && labels[0].isEmpty())) {
            props.put("event-label", Arrays.asList(labels));
        } else {
            props.remove("event-label");
        }
        if (version != null) {
            props.put("version", Collections.singletonList(version));
        } else {
            props.remove("version");
        }
        if (uri.getExternal().booleanValue()) {
            if (uri.getArchived() != null) {
                props.put("archived", Collections.singletonList(uri.getArchived().toString()));
            } else {
                props.remove("archived");
            }
        }
        if (uri.getDescription() != null) {
            props.put("description", Collections.singletonList(uri.getDescription()));
        } else {
            props.remove("description");
        }
        if (uri.getLabels() != null) {
            props.put("label", Arrays.asList(uri.getLabels().split(",")));
        } else {
            props.remove("label");
        }
        if (uri.getDocID() != null) {
            props.put("docid", Collections.singletonList(uri.getDocID()));
        } else {
            props.remove("docid");
        }
        if (uri.getPath().indexOf(63) != -1 && originalPath != null && !originalPath.equals(uri.getPath())) {
            props.put("origpath", Collections.singletonList(originalPath));
        }
        if (uri.getExternal().booleanValue()) {
            props.put("hosturl", Collections.singletonList(URIRule.getHostURL(uri)));
        }
        props.put("path", Collections.singletonList(uri.getPath()));
        xl.setProperties(ObjectProperties.toString((Map)props));
        XLinkRule.addGroups(db, xl, GroupRule.getEditGroups(db, null, uri));
        if (content != null) {
            Content cont = Content.create((Database)db);
            cont.setType("application/vnd.pageseeder.psml+xml");
            try {
                cont.setData(CharsetDetector.decodeXML((ByteBuffer)ByteBuffer.wrap(content)).toString());
            }
            catch (IOException ex) {
                throw new DatabaseException("Unable to read content for URI path: " + uri.getPath(), (Throwable)ex);
            }
            if (rootxl != null) {
                if (rootxl.getContentsCol().isEmpty()) {
                    rootxl.addContents(cont);
                } else {
                    LOGGER.error("Trying to add content when it already exists for URI ID: {}", (Object)uri.getId());
                }
            } else {
                xl.addContents(cont);
            }
        }
        xl = xl.insert(db);
        if (rootxl != null) {
            rootxl.addReplies(xl);
            xl.addReplyTos(rootxl);
        } else {
            uri.setXLink(xl);
            xl.addReplies(xl);
        }
    }

    public static @Nullable Member getOriginalAuthor(URI uri, Database db) throws QueryFailedException {
        List xls = DatabaseQuery.getXLinksByURIModification((Database)db, (Long)uri.getId(), (boolean)true);
        return xls.isEmpty() ? null : ((XLink)xls.get(0)).getMember();
    }

    public static XLink getURIXLink(URI uri, Long beforeXLinkID, Database db) {
        XLink rootxl = uri.getXLink();
        if (rootxl == null) {
            return null;
        }
        if (beforeXLinkID != null && beforeXLinkID == 0L) {
            if (rootxl.getDate().equals(uri.getDateCreated())) {
                return rootxl;
            }
            return null;
        }
        try {
            return DatabaseQuery.getXLinkByLastReplyBefore((Database)db, (XLink)rootxl, (Long)beforeXLinkID);
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load URI XLink: {}", (Throwable)ex);
            return null;
        }
    }

    public static String getURIPathForOutput(URI uri) {
        if (!uri.getExternal().booleanValue()) {
            return uri.getPath();
        }
        return URIs.getURIPathForOutput((URI)uri);
    }

    public static String getURIDecodedPathForOutput(URI uri) {
        return URLCoder.decode((String)URIRule.getURIPathForOutput(uri));
    }

    public static void setURIProperty(URI uri, Database db, String propname, List<String> propvalues) {
        if (uri == null || propname == null) {
            return;
        }
        XLink xl = URIRule.getURIXLink(uri, null, db);
        if (xl != null) {
            Map existingProps = ObjectProperties.toMap((String)xl.getProperties());
            if (propvalues != null && !propvalues.isEmpty()) {
                existingProps.put(propname, propvalues);
            } else {
                existingProps.remove(propname);
            }
            xl.setProperties(ObjectProperties.toString((Map)existingProps));
        }
    }

    public static List<String> getURIPropertyValues(URI uri, Database db, String propname) {
        Map existingProps;
        ArrayList<String> values = new ArrayList<String>();
        if (uri == null || propname == null) {
            return values;
        }
        XLink xl = URIRule.getURIXLink(uri, null, db);
        if (xl != null && (existingProps = ObjectProperties.toMap((String)xl.getProperties())).containsKey(propname)) {
            values.addAll((Collection)existingProps.get(propname));
        }
        return values;
    }

    public static boolean isPSML(URI uri) {
        return uri != null && "application/vnd.pageseeder.psml+xml".equals(uri.getType());
    }

    public static boolean isPSML(File file) {
        return file != null && file.getName().toLowerCase().endsWith(".psml");
    }

    public static boolean isFolder(URI uri) {
        return uri != null && "folder".equals(uri.getType());
    }

    public static boolean isInvalidFragment(URI uri, @Nullable Group group, String frag, Database db) {
        if (frag == null || uri == null || db == null) {
            return true;
        }
        if ("default".equals(frag)) {
            return false;
        }
        if ("default".equalsIgnoreCase(frag)) {
            return true;
        }
        for (Locator loc : uri.getLocatorsCol((Object)Predicates.predicateLocatorFragment((Database)db, (String)frag))) {
            if (frag.equals(loc.getFragment())) {
                return false;
            }
            if (!frag.equalsIgnoreCase(loc.getFragment())) continue;
            return true;
        }
        if (URIRule.isPSML(uri)) {
            try {
                Group context = GroupRule.getEditGroup(db, group, uri);
                XLink structure = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)context, null);
                if (structure != null) {
                    FragmentIDsLoader loader = new FragmentIDsLoader();
                    XMLUtils.parse((InputStream)new ByteArrayInputStream(((Content)structure.getContents().next()).getData().getBytes(StandardCharsets.UTF_8)), (ContentHandler)loader);
                    for (String fragid : loader.getFragmentIDs()) {
                        if (frag.equals(fragid)) {
                            return false;
                        }
                        if (!frag.equalsIgnoreCase(fragid)) continue;
                        return true;
                    }
                }
            }
            catch (QueryFailedException | ProcessException ex) {
                LOGGER.error("Failed to load structure to retrieve target fragment {}", (Object)frag, (Object)ex);
            }
        }
        return false;
    }

    public static boolean hasFragment(URI uri, Group group, String frag, Database db) {
        block8: {
            if (frag == null || uri == null || group == null || db == null) {
                return false;
            }
            if ("default".equals(frag)) {
                return true;
            }
            for (Locator loc : uri.getLocatorsCol((Object)Predicates.predicateLocatorFragment((Database)db, (String)frag))) {
                if (!frag.equals(loc.getFragment())) continue;
                return true;
            }
            if (!URIRule.isPSML(uri) || uri.getExternal().booleanValue()) {
                return false;
            }
            try {
                Group context = GroupRule.getEditGroup(db, group, uri);
                XLink structure = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)context, null);
                if (structure != null) {
                    FragmentIDsLoader loader = new FragmentIDsLoader();
                    XMLUtils.parse((InputStream)new ByteArrayInputStream(((Content)structure.getContents().next()).getData().getBytes(StandardCharsets.UTF_8)), (ContentHandler)loader);
                    for (String fragid : loader.getFragmentIDs()) {
                        if (!frag.equals(fragid)) continue;
                        return true;
                    }
                    break block8;
                }
                return true;
            }
            catch (QueryFailedException | ProcessException ex) {
                LOGGER.error("Failed to load structure to retrieve target fragment {}", (Object)frag, (Object)ex);
            }
        }
        return false;
    }

    public static @Nullable List<String> loadFragments(URI uri, Group group, boolean includeNew, Database db) {
        if (uri == null || group == null || db == null) {
            return null;
        }
        try {
            XLink structure = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)group, null, (boolean)includeNew);
            if (structure != null) {
                FragmentIDsLoader loader = new FragmentIDsLoader();
                XMLUtils.parse((InputStream)new ByteArrayInputStream(((Content)structure.getContents().next()).getData().getBytes(StandardCharsets.UTF_8)), (ContentHandler)loader);
                return loader.getFragmentIDs();
            }
            return null;
        }
        catch (QueryFailedException | ProcessException ex) {
            LOGGER.error("Failed to load structure to retrieve fragment ids", ex);
            return Collections.emptyList();
        }
    }

    public static boolean isURLPSSource(String url, Database db) throws QueryFailedException, MalformedURLException {
        if (url == null) {
            return false;
        }
        URL instance = new URL(url);
        String hostname = new URL(url).getHost();
        Host host = DatabaseQuery.getHostByName((Database)db, (String)(hostname = HostRule.resolveAlias(db, hostname)));
        if (host.isExternal()) {
            return false;
        }
        String psPath = "^" + GlobalSettings.getSitePrefix() + "/(ui|uri|docid|service)/";
        return instance.getPath().matches(psPath);
    }

    public static @Nullable URISharing getSharingDetails(Long uriid, UserDetails userdetails, Database db) {
        Collection gurifgs;
        URI uri;
        try {
            uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
            gurifgs = DatabaseQuery.getGroupURIForGroupsByURI((Database)db, (URI)uri);
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load URI and/or its groups with ID {}", (Object)uriid, (Object)ex);
            return null;
        }
        Group def_group = null;
        Collection<Group> groups = new ArrayList<Group>();
        HashMap<Long, Boolean> editable = new HashMap<Long, Boolean>();
        for (GroupURIForGroup gurifg : gurifgs) {
            Boolean e;
            Group group = gurifg.getGroup();
            if (URIRule.isDefaultGroup(uri, group) && !GroupRule.isProject(group)) {
                def_group = group;
            }
            if ((e = (Boolean)editable.get(group.getId())) == null) {
                groups.add(gurifg.getGroup());
                editable.put(group.getId(), gurifg.getEditURIs());
                continue;
            }
            if (e.booleanValue()) continue;
            editable.put(group.getId(), gurifg.getEditURIs());
        }
        int total = groups.size();
        boolean pub = GroupRule.containsPublicGroup(groups);
        groups = MemberRule.removeNonAccessibleGroups(groups, userdetails.flags());
        boolean def_edit = true;
        if (def_group != null && !groups.contains(def_group)) {
            groups.add(def_group);
            def_edit = false;
        }
        URISharing.Builder sharing = new URISharing.Builder().hiddenGroups(total - groups.size() - (pub ? 1 : 0)).isPublic(pub);
        Collection<Group> addcomments = MemberRule.removeNonCommentGroups(groups, userdetails.flags());
        for (Group agroup : groups) {
            Boolean e;
            boolean owner;
            boolean bl = owner = URIRule.isDefaultGroup(uri, agroup) && !GroupRule.isProject(agroup);
            boolean iseditable = owner ? def_edit : (e = (Boolean)editable.get(agroup.getId())) != null && e != false;
            sharing.addGroup(agroup, owner, iseditable, addcomments.contains(agroup));
        }
        return sharing.build();
    }

    private static boolean isVirtual(String url, Database db) throws QueryFailedException, MalformedURLException {
        String hostname = new URL(url).getHost();
        Host host = DatabaseQuery.getHostByName((Database)db, (String)(hostname = HostRule.resolveAlias(db, hostname)));
        return host != null ? host.isVirtual() : false;
    }

    public static final class LimitReached {
        public boolean reached = false;
    }
}

