/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class MemberRule {
    private MemberRule() {
    }

    public static boolean isAdministrator(Map<String, String> userDetails) {
        return userDetails.get("admin") != null;
    }

    public static boolean isProjectManager(String projectname, Map<String, String> userDetails) {
        return MemberRule.isContributorForGroupNameFlag(userDetails, projectname, "e");
    }

    public static boolean isAdministrator(Database db, Member mem) throws QueryFailedException {
        return !mem.getGroupsForMemberCol((Object)Predicates.predicateMemberForGroupByGroups((Database)db, Collections.singleton("admin"))).isEmpty();
    }

    public static boolean hasEmail(Member member) {
        return !"No Email".equals(member.getEmail());
    }

    public static boolean onVacation(Member member) {
        return member.hasSubmitPref('v');
    }

    public static boolean isContributorForGroupNameFlag(Map<String, String> userDetails, String group, String flag) {
        if (MemberRule.isAdministrator(userDetails)) {
            return true;
        }
        String flags = userDetails.get(group);
        return flags != null && flags.contains(flag);
    }

    public static boolean isContributorForURIIdFlag(Database db, Map<String, String> userDetails, Long uriId, String flag) throws DatabaseException {
        if (MemberRule.isAdministrator(userDetails)) {
            return true;
        }
        URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriId);
        if (uri == null) {
            throw new DatabaseException("URI not found: " + uriId);
        }
        ArrayList<Group> grpc = null;
        if (!"folder".equals(uri.getType())) {
            grpc = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uriId);
        } else {
            grpc = new ArrayList<Group>();
            Iterator gurii = uri.getGroupURIs();
            while (gurii.hasNext()) {
                GroupURI guri = (GroupURI)gurii.next();
                if (guri.getPath() == null || !guri.getPath().endsWith("/*")) continue;
                Iterator grpi = guri.getGroups();
                while (grpi.hasNext()) {
                    Group grp = (Group)grpi.next();
                    if (grpc.contains(grp)) continue;
                    grpc.add(grp);
                }
            }
        }
        for (Group grp : grpc) {
            String flags = userDetails.get(grp.getName());
            if (flags == null || !flags.contains(flag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContributorForEditableGroupURI(Map<String, String> userDetails, Collection<GroupURIForGroup> gurifgs, String flag, String groupname) {
        if (MemberRule.isAdministrator(userDetails)) {
            return true;
        }
        for (GroupURIForGroup gurifg : gurifgs) {
            String flags;
            if (!gurifg.getEditURIs().booleanValue()) continue;
            Group grp = gurifg.getGroup();
            if (groupname != null && !groupname.equals(grp.getName()) || (flags = userDetails.get(grp.getName())) == null || !flags.contains(flag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReviewerForGroupName(Map<String, String> userDetails, String group) {
        if (MemberRule.isAdministrator(userDetails)) {
            return true;
        }
        String flags = userDetails.get(group);
        return flags != null && flags.indexOf(103) == -1;
    }

    public static boolean isManager(Map<String, String> userDetails) {
        if (userDetails.get("admin") != null) {
            return true;
        }
        for (String flags : userDetails.values()) {
            if (flags.indexOf(101) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isManagerForProject(Map<String, String> userDetails, String projectName) {
        if (userDetails.get("admin") != null) {
            return true;
        }
        for (String group_name : userDetails.keySet()) {
            if (!group_name.equals(projectName) && !group_name.startsWith(projectName + "-") || userDetails.get(group_name).indexOf(101) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isApproverForGroup(UserDetails userdetails, String group) {
        return MemberRule.isContributorForGroupNameFlag(userdetails.flags(), group, "a");
    }

    public static boolean isContributorForGroup(UserDetails userdetails, String group) {
        return MemberRule.isContributorForGroupNameFlag(userdetails.flags(), group, "c");
    }

    public static boolean isManagerForGroup(UserDetails userdetails, String group) {
        return MemberRule.isContributorForGroupNameFlag(userdetails.flags(), group, "e");
    }

    public static boolean isContributorForGroups(UserDetails userdetails, Collection<Group> groups) {
        boolean contributor = false;
        for (Group group : groups) {
            if (!MemberRule.isContributorForGroup(userdetails, group.getName())) continue;
            contributor = true;
            break;
        }
        return contributor;
    }

    public static boolean isManagerForGroups(UserDetails userdetails, Collection<Group> groups) {
        boolean manager = false;
        for (Group group : groups) {
            if (!MemberRule.isManagerForGroup(userdetails, group.getName())) continue;
            manager = true;
            break;
        }
        return manager;
    }

    public static List<String> getGroupnames(@Nullable UserDetails userDetails) {
        if (userDetails == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(userDetails.flags().keySet());
    }

    public static List<String> getManagerGroupnames(@Nullable UserDetails userDetails) {
        ArrayList<String> groupnames = new ArrayList<String>();
        if (userDetails == null) {
            return groupnames;
        }
        Map<String, String> flags = userDetails.flags();
        for (Map.Entry<String, String> details : flags.entrySet()) {
            if (details.getValue().indexOf(101) == -1) continue;
            groupnames.add(details.getKey());
        }
        return groupnames;
    }

    public static Collection<Group> removeNonCommentGroups(Collection<Group> grpc, Map<String, String> userDetails) {
        boolean admin = MemberRule.isAdministrator(userDetails);
        ArrayList<Group> resc = new ArrayList<Group>();
        for (Group grp : grpc) {
            String flags = grp.getFlags() != null ? grp.getFlags() : "";
            String access = userDetails.get(grp.getName());
            if (GroupRule.isPublicGroup(grp.getName()) || flags.indexOf(97) == -1 && !admin && (access == null || access.indexOf(103) != -1 || flags.indexOf(111) != -1 && access.indexOf(99) == -1) || flags.indexOf(100) != -1) continue;
            resc.add(grp);
        }
        return resc;
    }

    public static Collection<Group> removeNonAccessibleGroups(Collection<Group> groups, Map<String, String> userDetails) {
        boolean admin = MemberRule.isAdministrator(userDetails);
        ArrayList<Group> resc = new ArrayList<Group>();
        for (Group group : groups) {
            String access = userDetails.get(group.getName());
            if (GroupRule.isPublicGroup(group.getName()) || !group.hasFlag('p') && !admin && access == null) continue;
            resc.add(group);
        }
        return resc;
    }

    public static Collection<Group> removeNonMemberGroups(Collection<Group> groups, Map<String, String> userDetails) {
        ArrayList<Group> resc = new ArrayList<Group>();
        for (Group group : groups) {
            String access = userDetails.get(group.getName());
            if (GroupRule.isPublicGroup(group.getName()) || GroupRule.isAdminGroup(group.getName()) || access == null) continue;
            resc.add(group);
        }
        return resc;
    }

    public static void addMemberGroupNames(Collection<String> names, Map<String, String> userDetails) {
        for (String name : userDetails.keySet()) {
            if (GroupRule.isPublicGroup(name) || names.contains(name)) continue;
            names.add(name);
        }
    }

    public static boolean isMemberActivated(@Nullable Member member) {
        return member != null && !member.hasSubmitPref('u');
    }

    public static boolean isMemberDisabled(@Nullable Member member) {
        return member != null && member.hasSubmitPref('d');
    }

    public static boolean isNameValid(String name) {
        if (name == null) {
            return true;
        }
        int maxLengthForName = 20;
        return name.length() < 20;
    }

    public static String getFullName(Member member) {
        if (member == null) {
            return null;
        }
        StringBuilder fullname = new StringBuilder();
        String firstname = member.getFirstName();
        String surname = member.getSurname();
        if (firstname != null && !firstname.isEmpty()) {
            fullname.append(firstname);
        }
        if (fullname.length() > 0 && surname != null && !surname.isEmpty()) {
            fullname.append(' ').append(surname);
        }
        return fullname.toString();
    }

    public static @Nullable Member getMember(Database db, String usernameOrId) throws QueryFailedException {
        if (usernameOrId == null || usernameOrId.length() == 0) {
            return null;
        }
        boolean isId = Strings.isDigits((String)usernameOrId);
        return isId ? DatabaseQuery.getMemberById((Database)db, (Long)Long.parseLong(usernameOrId)) : DatabaseQuery.getMemberByUsername((Database)db, (String)usernameOrId);
    }
}

