/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import java.util.Iterator;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocatorRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocatorRule.class);

    private LocatorRule() {
    }

    public static Locator addXLinkToLocator(Database db, XLink xl, URI uri, String frag) throws DatabaseException {
        Locator loc = LocatorRule.getLocatorByURIFragment(db, uri, frag);
        LocatorRule.addXLinkToLocator(db, xl, loc);
        return loc;
    }

    public static Locator addXLinkToLocator(Database db, XLink xl, URI uri, String frag, String behavior, String role, @Nullable String title) throws DatabaseException {
        Locator loc = LocatorRule.getLocatorByURIFragment(db, uri, frag, behavior);
        LocatorRule.addXLinkToLocator(db, xl, loc, role, title, null);
        return loc;
    }

    public static void addXLinkToLocator(Database db, XLink xl, Locator loc) throws DatabaseException {
        LocatorForXLink lxl = LocatorForXLink.create((Database)db);
        lxl.setXLink(xl);
        loc.addXLinksForLocator(lxl);
        xl.addReplies(xl);
    }

    public static void addXLinkToLocator(Database db, XLink xl, Locator loc, @Nullable String role, @Nullable String title, @Nullable String label) throws DatabaseException {
        LocatorForXLink lxl = LocatorForXLink.create((Database)db);
        lxl.setRole(role);
        lxl.setTitle(title);
        lxl.setXLink(xl);
        lxl.setLabel(label);
        loc.addXLinksForLocator(lxl);
        if (role == null || role.startsWith("xref-source")) {
            xl.addReplies(xl);
        }
        xl.addLocatorsForXLink(lxl);
    }

    public static boolean isValidFragmentID(@Nullable String fragment) {
        return fragment != null && fragment.matches("^[a-zA-Z0-9_=,&\\-\\.]+$");
    }

    public static void removeAllXLinkLocators(Database db, XLink xlink) throws DatabaseException {
        Iterator loci = xlink.getLocatorsForXLink();
        while (loci.hasNext()) {
            LocatorForXLink locfxl = (LocatorForXLink)loci.next();
            Locator loc = locfxl.getLocator();
            xlink.removeLocatorsForXLink(locfxl);
            loc.removeXLinksForLocator(locfxl);
            locfxl.delete(db);
        }
        xlink.removeReplies(xlink);
    }

    public static void deleteLocator(Database db, URI uri, Locator loc) throws DatabaseException {
        Iterator lfxi = loc.getXLinksForLocator();
        while (lfxi.hasNext()) {
            LocatorForXLink lfx = (LocatorForXLink)lfxi.next();
            XLink xl = lfx.getXLink();
            if (xl == null) {
                LOGGER.warn("Found a LocatorForXLink with a null XLink on URI {} and fragment {}", (Object)uri.getPath(), (Object)loc.getFragment());
            } else if (lfx.getRole() == null || !XLinks.isComment((XLink)xl)) {
                XLinkRule.deleteXLink(db, xl);
            }
            lfx.delete(db);
            lfxi = loc.getXLinksForLocator();
        }
        uri.removeLocators(loc);
        loc.delete(db);
    }

    public static Locator getLocatorByXLink(Database db, XLink xl) {
        LocatorForXLink lfx = LocatorRule.getLocatorForXLinkByXLink(xl);
        return lfx != null ? lfx.getLocator() : null;
    }

    public static Locator getLocatorByXLink(XLink xl) {
        LocatorForXLink lfx = LocatorRule.getLocatorForXLinkByXLink(xl);
        return lfx != null ? lfx.getLocator() : null;
    }

    public static @Nullable LocatorForXLink getLocatorForXLinkByXLink(XLink xl) {
        String role;
        XLink threadRoot = XLinks.getThreadRoot((XLink)xl);
        Iterator loci = threadRoot.getLocatorsForXLink();
        LocatorForXLink lfx = null;
        while (loci.hasNext() && (role = (lfx = (LocatorForXLink)loci.next()).getRole()) != null && !role.startsWith("xref-source")) {
        }
        return lfx;
    }

    public static Locator getLocatorByURIFragment(Database db, URI uri, String frag) throws DatabaseException {
        return LocatorRule.getLocatorByURIFragment(db, uri, frag, null);
    }

    public static Locator getLocatorByURIFragment(Database db, URI uri, String frag, @Nullable String behavior) throws DatabaseException {
        if (frag == null) {
            throw new DatabaseException("Locator fragment can not be null");
        }
        if ("default".equalsIgnoreCase(frag)) {
            frag = "default";
        }
        Locator loc = null;
        Iterator i = uri.getLocators((Object)Predicates.predicateLocatorFragment((Database)db, (String)frag));
        while (i.hasNext()) {
            Locator aloc = (Locator)i.next();
            if (aloc.getFragment().trim().equals(frag.trim())) {
                loc = aloc;
                continue;
            }
            throw new DatabaseException("Cannot create locator fragment '#" + frag + "' because '#" + aloc.getFragment() + "' already exists");
        }
        if (loc == null) {
            loc = Locator.create((Database)db);
            loc.setFragment(frag);
            if (behavior != null) {
                loc.setBehavior(behavior);
            }
            loc = loc.insert(db);
            uri.addLocators(loc);
        }
        return loc;
    }
}

