/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.document.URIException;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIFetcher;
import com.pageseeder.base.rule.URIFetcherStatus;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;

public final class InternalURIFetcher
implements URIFetcher {
    private final HttpServletRequest req;
    private final String uriString;
    protected URIFetcherStatus status = URIFetcherStatus.UNDEFINED;
    protected String statusMessage = null;
    private File uriFile = null;
    private String uriContent = null;
    private String contentType = null;
    private long lastModified = -1L;
    private InputStream uriIS = null;

    public InternalURIFetcher(URI uri, HttpServletRequest req) throws URIException {
        XLink xl;
        this.uriString = URIRule.getURIString(uri);
        this.req = req;
        if (URIRule.isPSML(uri) && (xl = uri.getXLink()) != null && xl.getContents().hasNext()) {
            this.uriContent = ((Content)xl.getContents().next()).getData();
        }
        if (this.uriContent == null) {
            try {
                URL url = new URL(this.uriString);
                String real_path = URIRule.getRealPath(Settings.getContextPath(), url.getFile());
                this.uriFile = new File(real_path);
                if (!this.uriFile.exists() && !uri.isFolder()) {
                    this.status = URIFetcherStatus.NOT_FOUND;
                    this.statusMessage = "The path " + url.getFile() + " could not be found on this web server";
                    return;
                }
            }
            catch (IOException ex) {
                throw new URIException("Unable to retrieve URI", ex);
            }
        }
        if (uri.isFolder() || this.uriFile != null && this.uriFile.isDirectory()) {
            this.contentType = "folder";
        } else {
            int i = this.uriString.lastIndexOf(47);
            if (i == -1) {
                throw new IllegalStateException("URL is invalid:" + this.uriString);
            }
            String filename = this.uriString.substring(i + 1);
            String ext = "";
            i = filename.lastIndexOf(46);
            if (i != -1) {
                ext = filename.substring(i + 1).toLowerCase();
            }
            this.contentType = Medias.getMediaType(ext);
        }
        if (this.uriFile != null || uri.getDateCreated() != null) {
            this.lastModified = this.uriFile != null ? this.uriFile.lastModified() : uri.getDateCreated().getTime();
        }
        this.status = URIFetcherStatus.SUCCESS;
    }

    @Override
    public void close() throws IOException {
        if (this.uriIS != null) {
            this.uriIS.close();
        }
    }

    @Override
    public boolean getCachedAccess() {
        return this.req != null && GroupURIRule.getCachedAccess(this.req.getSession(false), this.uriString);
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.uriIS == null) {
            this.uriIS = this.uriContent != null ? new ByteArrayInputStream(this.uriContent.getBytes(StandardCharsets.UTF_8)) : ("folder".equals(this.contentType) || this.uriFile.isDirectory() ? new ByteArrayInputStream(new byte[0]) : new FileInputStream(this.uriFile));
        }
        return this.uriIS;
    }

    @Override
    public File getFile() {
        return this.uriFile;
    }

    @Override
    public long getContentLength() {
        return this.uriContent != null ? (long)this.uriContent.getBytes(StandardCharsets.UTF_8).length : this.uriFile.length();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public URIFetcherStatus getStatus() {
        return this.status;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public String getURIString() {
        return this.uriString;
    }
}

