/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Member;
import javax.servlet.http.HttpServletRequest;

public final class ViewMemberCheck
extends PermissionCheck {
    private final HttpServletRequest _req;
    private final Member _member;
    protected final PermissionCheck _check;

    public ViewMemberCheck(Member member) {
        this(member, null, null);
    }

    public ViewMemberCheck(Member member, PermissionCheck check) {
        this(member, null, check);
    }

    public ViewMemberCheck(Member member, HttpServletRequest req, PermissionCheck check) {
        this._req = req;
        this._member = member;
        this._check = check;
        if (this._check != null) {
            this.grp = this._check.grp;
            this.guri = this._check.guri;
            this.uri = this._check.uri;
            this.isFolder = this._check.isFolder;
            this.uriString = this._check.uriString;
            this.xl = this._check.xl;
        }
    }

    @Override
    public boolean hasAccess(Database db, Permissions perm) {
        if (perm.getMemberId() != null && this._member != null && perm.getMemberId().equals(this._member.getId()) || perm.getAdminSystem().booleanValue() || perm.getManageAccount()) {
            boolean access;
            if (this._check == null) {
                return true;
            }
            this._check.access = access = this._check.hasAccess(db, perm);
            this._check.authenticated = perm.isLoggedIn();
            return access;
        }
        return false;
    }
}

