/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.permission.PermissionException;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.Groups;
import java.util.HashSet;

public abstract class PermissionCheck {
    protected Group grp = null;
    protected URI uri = null;
    protected GroupURI guri = null;
    protected String uriString = null;
    protected Boolean isFolder = null;
    protected boolean checkAllowed = true;
    protected boolean authenticated = false;
    protected boolean access = false;
    protected XLink xl = null;

    private static boolean equivalent(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public final void getPermissions(Database db, Permissions perm) throws PermissionException {
        String grp_name = null;
        if (this.grp != null) {
            grp_name = this.grp.getName();
        }
        Long uri_id = null;
        Long guri_id = null;
        if (this.uri != null) {
            uri_id = this.uri.getId();
            this.uriString = URIRule.getURIString(this.uri);
            this.isFolder = "folder".equals(this.uri.getType());
        } else if (this.guri != null) {
            guri_id = this.guri.getId();
            this.uriString = GroupURIRule.getURIString(this.guri);
            this.uriString = GroupURIs.truncatePath((String)this.uriString);
            this.isFolder = Boolean.TRUE;
        }
        Long xlink_id = null;
        HashSet<String> xlink_grp_names = null;
        if (this.xl != null) {
            xlink_id = this.xl.getId();
            xlink_grp_names = new HashSet<String>(Groups.getGroupNames(XLinkRule.getGroups(this.xl)));
        }
        if (!(PermissionCheck.equivalent(grp_name, perm.getGroupName()) && PermissionCheck.equivalent(uri_id, perm.getUriId()) && PermissionCheck.equivalent(guri_id, perm.getGroupUriId()) && PermissionCheck.equivalent(this.uriString, perm.getUriString()) && PermissionCheck.equivalent(this.isFolder, perm.getIsFolder()) && PermissionCheck.equivalent(xlink_id, perm.getXLinkId()) && PermissionCheck.equivalent(xlink_grp_names, perm.getXLinkGroupNames()) && perm.getStatus() == Permissions.Status.SUCCESS && !perm.getAuthenticate())) {
            perm.reset();
            perm.setGroupName(grp_name);
            perm.setUriId(uri_id);
            perm.setGroupUriId(guri_id);
            perm.setUriString(this.uriString);
            perm.setIsFolder(this.isFolder);
            perm.setXLinkId(xlink_id);
            perm.setXLinkGroupNames(xlink_grp_names);
            perm.loadPermissions(db);
        }
        this.authenticated = perm.isLoggedIn();
    }

    public abstract boolean hasAccess(Database var1, Permissions var2);

    public String getMessage() {
        return null;
    }
}

