/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.organization;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;

public final class UIConfig {
    private @Nullable String headerXML = null;
    private @Nullable String accountHomeXML;
    private final @Nullable String headerLogo;
    private final @Nullable String headerIcon;
    private final Theme theme;
    private final Collection<LegalDocument> legal = new ArrayList<LegalDocument>();

    public @Nullable String getAccountHomeXML() {
        return this.accountHomeXML;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public @Nullable String getLogo() {
        return this.headerLogo;
    }

    public Collection<LegalDocument> getLegalDocuments() {
        return this.legal;
    }

    public @Nullable String getIcon() {
        return this.headerIcon;
    }

    public String getHeaderXML() {
        if (this.headerXML == null) {
            if (this.headerIcon == null && this.headerLogo == null && this.legal.isEmpty()) {
                this.headerXML = "";
            } else {
                XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
                if (this.headerIcon != null || this.headerLogo != null) {
                    xml.openElement("images");
                    if (this.headerLogo != null) {
                        xml.attribute("logo-filename", this.headerLogo);
                    }
                    if (this.headerIcon != null) {
                        xml.attribute("icon-filename", this.headerIcon);
                    }
                    xml.closeElement();
                }
                if (!this.legal.isEmpty()) {
                    xml.openElement("legal");
                    for (LegalDocument doc : this.legal) {
                        xml.openElement("document");
                        if (doc.name != null) {
                            xml.attribute("name", doc.name);
                        }
                        if (doc.title != null) {
                            xml.attribute("title", doc.title);
                        }
                        if (doc.agreeOn != null) {
                            xml.attribute("agree-on", doc.agreeOn);
                        }
                        xml.closeElement();
                    }
                    xml.closeElement();
                }
                this.headerXML = xml.toString();
            }
        }
        return this.headerXML;
    }

    private UIConfig(Theme theme, @Nullable String logo, @Nullable String icon, @Nullable Collection<LegalDocument> docs, @Nullable String accountHomeXML) {
        this.theme = theme;
        this.headerLogo = logo;
        this.headerIcon = icon;
        if (docs != null) {
            this.legal.addAll(docs);
        }
        this.accountHomeXML = accountHomeXML;
    }

    public static class LegalDocument {
        private @Nullable String name;
        private @Nullable String title;
        private @Nullable String agreeOn;

        public @Nullable String getAgreeOn() {
            return this.agreeOn;
        }

        public @Nullable String getName() {
            return this.name;
        }

        public @Nullable String getTitle() {
            return this.title;
        }
    }

    public static final class Builder {
        private @Nullable String accountHomeXML = null;
        private @Nullable String headerLogo = null;
        private @Nullable String headerIcon = null;
        private @Nullable Collection<LegalDocument> legal = null;
        private Theme theme = Theme.ANY;

        public void setAccountHome(String xml) {
            this.accountHomeXML = xml;
        }

        public void setTheme(Theme theme) {
            this.theme = theme;
        }

        void setLogoAndIcon(String logo, String icon) {
            this.headerLogo = logo;
            this.headerIcon = icon;
        }

        void addLegalDocument(String name, String title, String agreeOn) {
            if (this.legal == null) {
                this.legal = new ArrayList<LegalDocument>();
            }
            LegalDocument doc = new LegalDocument();
            doc.name = name;
            doc.title = title;
            doc.agreeOn = agreeOn;
            this.legal.add(doc);
        }

        public UIConfig build() {
            return new UIConfig(this.theme, this.headerLogo, this.headerIcon, this.legal, this.accountHomeXML);
        }
    }

    public static enum Theme {
        ANY,
        BLUE,
        PURPLE,
        GREEN,
        STEEL,
        TEAL,
        CONTRAST,
        YELLOW,
        RED;


        public static Theme fromString(String value) {
            for (Theme theme : Theme.values()) {
                if (!value.equalsIgnoreCase(theme.name())) continue;
                return theme;
            }
            return ANY;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

