/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.model;

import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.model.AuthorizationCode;
import com.pageseeder.base.oauth.model.MemoryTokenStorage;
import com.pageseeder.common.oauth.Passwords;
import com.pageseeder.common.util.BinaryFormat;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;

public final class CodeManager {
    private static final CodeManager SINGLETON = new CodeManager();
    protected static final int MAX_CAPACITY = 10000;
    private final MemoryTokenStorage<AuthorizationCode> storage = new MemoryTokenStorage(10000, 5L, TimeUnit.MINUTES);

    private CodeManager() {
    }

    public static CodeManager singleton() {
        return SINGLETON;
    }

    public String issue(String clientId, String redirectURI, long memberId, String scope) throws OAuthException {
        String code = Passwords.randomBytes((int)16, (BinaryFormat)BinaryFormat.HEX);
        this.storage.store(new AuthorizationCode(code, clientId, redirectURI, memberId, scope != null ? scope : ""));
        return code;
    }

    public AuthorizationCode consumeIfMatch(String code, String clientId, String redirectURI) {
        AuthorizationCode r = this.storage.get(code);
        if (r == null) {
            return null;
        }
        boolean match = r.match(clientId, redirectURI);
        boolean expired = r.hasExpired();
        if (match || expired) {
            this.storage.remove(code);
        }
        if (match && !expired) {
            return r;
        }
        return null;
    }

    public AuthorizationCode get(String code) {
        return this.storage.get(code);
    }

    public int size() {
        return this.storage.size();
    }

    public static int getMaxCapacity() {
        return 10000;
    }

    public Collection<AuthorizationCode> getCodes() {
        return Collections.unmodifiableCollection(this.storage.tokens());
    }

    public int purge() {
        return this.storage.purge();
    }

    public int revokeForClient(String clientId) {
        return this.storage.removeForClient(clientId);
    }

    public @Nullable OffsetDateTime getLastPurged() {
        return this.storage.getLastPurged();
    }

    public int clear() {
        return this.storage.removeAll();
    }

    public void destroy() {
        this.storage.destroy();
    }
}

