/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.model;

import com.pageseeder.base.oauth.model.Token;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.pageseeder.xmlwriter.XMLWriter;

public final class AccessToken
implements Token,
Serializable {
    private static final long serialVersionUID = 20160405L;
    public static final DateTimeFormatter ISO8601_DATETIME = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[xxx]");
    private final String _token;
    private final OffsetDateTime _issuedAt;
    private final OffsetDateTime _expires;
    private final String _clientId;
    private final long _memberId;
    private final String _scope;

    protected AccessToken(String token, OffsetDateTime issued, OffsetDateTime expires, String clientId, long memberId, String scope) {
        this._token = token;
        this._issuedAt = issued;
        this._expires = expires;
        this._clientId = clientId;
        this._memberId = memberId;
        this._scope = scope;
    }

    @Override
    public String getClientId() {
        return this._clientId;
    }

    @Override
    public long getMemberId() {
        return this._memberId;
    }

    @Override
    public String token() {
        return this._token;
    }

    @Override
    public OffsetDateTime issuedAt() {
        return this._issuedAt;
    }

    @Override
    public long maxAge(TimeUnit unit) {
        long maxAgeMillis = this._expires.toInstant().toEpochMilli() - this._issuedAt.toInstant().toEpochMilli();
        return unit.convert(maxAgeMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public OffsetDateTime expires() {
        return this._expires;
    }

    @Override
    public boolean hasExpired() {
        return this._expires.isBefore(OffsetDateTime.now());
    }

    @Override
    public boolean hasExpiredAt(OffsetDateTime time) {
        return this._expires.isBefore(time);
    }

    @Override
    public String scope() {
        return this._scope;
    }

    @Deprecated
    public void toXML(XMLWriter xml) {
        this.print(new XMLOutputPrinter(xml));
    }

    @Override
    public void print(OutputPrinter out) {
        this.print(out, false);
    }

    public void print(OutputPrinter out, boolean masked) {
        out.startObject("access-token", OutputPrinter.ObjectOption.XML_EMPTY);
        int length = this._token.length();
        String token = masked && length > 8 ? this._token.substring(0, 4) + "****" + this._token.substring(length - 4, length) : this._token;
        out.field("token", token);
        out.field("client-id", this._clientId);
        out.field("member-id", Long.toString(this._memberId));
        out.field("scope", this._scope);
        out.field("lifetime", Long.toString(this.maxAge(TimeUnit.SECONDS)));
        out.field("issued", this._issuedAt.format(ISO8601_DATETIME));
        out.field("expires", this._expires.format(ISO8601_DATETIME));
        out.field("expired", Boolean.toString(this.hasExpired()));
        out.endObject();
    }
}

