/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.jwt;

import jakarta.json.stream.JsonGenerator;
import java.io.Serializable;
import java.net.URI;

public class JWTClaim
implements Serializable {
    private static final long serialVersionUID = 8916286190266508070L;
    private final String _name;
    private final Datatype _datatype;
    private final Object _value;

    public JWTClaim(Registered reg, String value) {
        if (reg == null) {
            throw new NullPointerException("Registered claim is null");
        }
        JWTClaim.checkValue(value, reg.getDatatype());
        this._name = reg.name();
        this._datatype = reg.getDatatype();
        this._value = JWTClaim.coerceValue(reg.getDatatype(), value);
    }

    public JWTClaim(Registered reg, long value) {
        if (reg == null) {
            throw new NullPointerException("Registered claim is null");
        }
        this._name = reg.name();
        this._datatype = reg.getDatatype();
        this._value = value;
    }

    public JWTClaim(String name, Datatype datatype, String value) {
        JWTClaim.checkName(name);
        JWTClaim.checkValue(value, datatype);
        this._name = name;
        this._datatype = datatype;
        this._value = JWTClaim.coerceValue(datatype, value);
    }

    public JWTClaim(String name, String value) {
        JWTClaim.checkName(name);
        JWTClaim.checkValue(value, Datatype.AnyString);
        this._name = name;
        this._datatype = Datatype.AnyString;
        this._value = value;
    }

    public JWTClaim(String name, long value) {
        JWTClaim.checkName(name);
        this._name = name;
        this._datatype = Datatype.NumericDate;
        this._value = value;
    }

    public JWTClaim(String name, boolean value) {
        JWTClaim.checkName(name);
        this._name = name;
        this._datatype = Datatype.Boolean;
        this._value = value;
    }

    public final String name() {
        return this._name;
    }

    public final Datatype datatype() {
        return this._datatype;
    }

    public final String value() {
        return this._value.toString();
    }

    public final long longValue() {
        if (!(this._value instanceof Long)) {
            throw new IllegalStateException(String.format("Cannot return long value: claim is '%s'", this.datatype().name()));
        }
        return (Long)this._value;
    }

    public final boolean booleanValue() {
        if (!(this._value instanceof Boolean)) {
            throw new IllegalStateException(String.format("Cannot return boolean value: claim is '%s'", this.datatype().name()));
        }
        return (Boolean)this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JWTClaim other = (JWTClaim)obj;
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        return "JWTClaim:" + this._name + "=" + this._value;
    }

    public static JWTClaim newJWTClaim(String name, String value) {
        JWTClaim.checkName(name);
        if (JWTClaim.isRegisteredName(name)) {
            Registered registered = Registered.valueOf(name);
            registered.getDatatype();
            return new JWTClaim(registered, value);
        }
        Datatype datatype = Datatype.AnyString;
        return new JWTClaim(name, datatype, value);
    }

    public static boolean isRegisteredName(String name) {
        for (Registered n : Registered.values()) {
            if (!n.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    void writeJSON(JsonGenerator json) {
        if (this._datatype == Datatype.Boolean) {
            json.write(this._name, this.booleanValue());
        } else if (this._datatype == Datatype.NumericDate) {
            json.write(this._name, this.longValue());
        } else {
            json.write(this._name, this._value.toString());
        }
    }

    private static void checkName(String name) {
        if (name == null) {
            throw new NullPointerException("Claim is invalid: name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Claim is invalid: value is empty");
        }
    }

    private static void checkValue(String value, Datatype datatype) {
        String message = datatype.checkValue(value);
        if (message != null) {
            throw new NullPointerException(message);
        }
    }

    private static Object coerceValue(Datatype datatype, String value) {
        switch (datatype) {
            case StringOrURI: 
            case AnyString: {
                return value;
            }
            case Boolean: {
                return Boolean.valueOf(value);
            }
            case NumericDate: {
                return Long.valueOf(value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum Registered {
        iss(Datatype.StringOrURI),
        sub(Datatype.StringOrURI),
        aud(Datatype.StringOrURI),
        exp(Datatype.NumericDate),
        nbf(Datatype.NumericDate),
        iat(Datatype.NumericDate),
        jti(Datatype.AnyString);

        private final Datatype _datatype;

        private Registered(Datatype datatype) {
            this._datatype = datatype;
        }

        public Datatype getDatatype() {
            return this._datatype;
        }
    }

    public static enum Datatype {
        StringOrURI{

            @Override
            public String checkValue(String value) {
                if (value == null) {
                    return "Invalid claim value: null";
                }
                if (value.isEmpty()) {
                    return "Invalid claim value: empty";
                }
                if (value.contains(":")) {
                    try {
                        URI.create(value);
                    }
                    catch (IllegalArgumentException ex) {
                        return "Invalid claim value: not a valid URI";
                    }
                }
                return null;
            }
        }
        ,
        NumericDate{

            @Override
            public String checkValue(String value) {
                if (value == null) {
                    return "Invalid claim value: null";
                }
                if (value.isEmpty()) {
                    return "Invalid claim value: empty";
                }
                try {
                    long n = Long.parseLong(value);
                    if (n <= 0L) {
                        return "Invalid claim value: negative number";
                    }
                }
                catch (NumberFormatException ex) {
                    return "Invalid claim value: not a number";
                }
                return null;
            }
        }
        ,
        Boolean{

            @Override
            public String checkValue(String value) {
                if (value == null) {
                    return "Invalid claim value: null";
                }
                if (value.isEmpty()) {
                    return "Invalid claim value: empty";
                }
                if ("true".equals(value) || "false".equals(value)) {
                    return null;
                }
                return "Invalid claim value: not a boolean";
            }
        }
        ,
        AnyString{

            @Override
            public String checkValue(String value) {
                if (value == null) {
                    return "Invalid claim value: null";
                }
                if (value.isEmpty()) {
                    return "Invalid claim value: empty";
                }
                return null;
            }
        };


        public abstract String checkValue(String var1);
    }
}

