/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.core;

import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.common.util.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class OAuthException
extends Exception {
    private static final long serialVersionUID = 20160316L;
    private OAuthErrorType _error;
    private String description;
    private String uri;
    private String state;
    private String scope;
    private String redirectUri;
    private int responseStatus;
    private Map<String, String> parameters = new HashMap<String, String>();

    protected OAuthException(OAuthErrorType error) {
        this(error, "");
    }

    protected OAuthException(OAuthErrorType error, String description) {
        super(error + " " + description);
        this._error = error;
        this.description = description;
        this.responseStatus = error.defaultResponseCode();
    }

    public static OAuthException error(OAuthErrorType error) {
        return new OAuthException(error);
    }

    public static OAuthException error(OAuthErrorType error, String description) {
        return new OAuthException(error, description);
    }

    public OAuthException description(String description) {
        this.description = description;
        return this;
    }

    public OAuthException uri(String uri) {
        this.uri = uri;
        return this;
    }

    public OAuthException state(String state) {
        this.state = state;
        return this;
    }

    public OAuthException scope(String scope) {
        this.scope = scope;
        return this;
    }

    public OAuthException responseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
        return this;
    }

    public OAuthException setParameter(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    public OAuthErrorType getError() {
        return this._error;
    }

    public String getDescription() {
        return this.description;
    }

    public String getURI() {
        return this.uri;
    }

    public String getState() {
        return this.state;
    }

    public String getScope() {
        return this.scope;
    }

    public int getResponseStatus() {
        return this.responseStatus == 0 ? 400 : this.responseStatus;
    }

    public String get(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getRedirectURI() {
        return this.redirectUri;
    }

    public void setRedirectURI(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @Override
    public String getMessage() {
        StringBuilder out = new StringBuilder();
        out.append((Object)this._error);
        if (!Strings.isEmpty((String)this.description)) {
            out.append(", ").append(this.description);
        }
        if (!Strings.isEmpty((String)this.uri)) {
            out.append(", ").append(this.uri);
        }
        if (!Strings.isEmpty((String)this.state)) {
            out.append(", ").append(this.state);
        }
        if (!Strings.isEmpty((String)this.scope)) {
            out.append(", ").append(this.scope);
        }
        return out.toString();
    }

    @Override
    public String toString() {
        return "OAuthProblemException{error='" + this._error + "', description='" + this.description + "', uri='" + this.uri + "', state='" + this.state + "', scope='" + this.scope + "', redirectUri='" + this.redirectUri + "', responseStatus=" + this.responseStatus + ", parameters=" + this.parameters + "}";
    }

    public static OAuthException newInvalidRequest(String message) {
        return OAuthException.error(OAuthErrorType.invalid_request).description(message);
    }

    public static OAuthException handleMissingParameters(Collection<OAuthParameter> missing) {
        StringBuilder out = new StringBuilder("Missing parameters:");
        if (missing != null && missing.size() > 0) {
            for (OAuthParameter p : missing) {
                out.append(' ').append(p.name());
            }
        }
        return OAuthException.newInvalidRequest(out.toString());
    }
}

