/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.webauthn;

import com.pageseeder.base.mfa.webauthn.UnavailableCryptoException;
import com.pageseeder.base.mfa.webauthn.WebAuthn;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.PublicKeyCredentialType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PSCredentialRepository
implements CredentialRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSCredentialRepository.class);
    private final Database db;

    public PSCredentialRepository(Database db) {
        this.db = db;
    }

    public Set<PublicKeyCredentialDescriptor> getCredentialIdsForUsername(String username) {
        LOGGER.debug("Invoking: getCredentialIdsForUsername({})", (Object)username);
        try {
            Member member = DatabaseQuery.getMemberByUsername((Database)this.db, (String)username);
            if (member == null) {
                LOGGER.error("Unable to find member {}", (Object)username);
                return Collections.emptySet();
            }
            List authenticators = Authenticators.listVerifiedAuthenticatorsForMember((Database)this.db, (long)member.getId()).stream().filter(a -> a.getType().equals("webauthn")).collect(Collectors.toList());
            LOGGER.debug("Found {} authenticators for ({})", (Object)authenticators.size(), (Object)username);
            HashSet<PublicKeyCredentialDescriptor> descriptors = new HashSet<PublicKeyCredentialDescriptor>();
            for (Authenticator authenticator : authenticators) {
                ByteArray id = WebAuthn.getCredentialId(authenticator);
                LOGGER.debug("Authenticators ({}) credential ID={}", (Object)authenticator.publicId, (Object)id.getBase64Url());
                Set<AuthenticatorTransport> transports = WebAuthn.getTransports(authenticator);
                PublicKeyCredentialDescriptor descriptor = PublicKeyCredentialDescriptor.builder().id(id).type(PublicKeyCredentialType.PUBLIC_KEY).transports(transports).build();
                descriptors.add(descriptor);
            }
            return descriptors;
        }
        catch (Exception ex) {
            LOGGER.error("Error getting credential descriptors for {}", (Object)username, (Object)ex);
            return Collections.emptySet();
        }
    }

    public Optional<ByteArray> getUserHandleForUsername(String username) {
        LOGGER.debug("Invoking: getUserHandleForUsername({})", (Object)username);
        try {
            Member member = DatabaseQuery.getMemberByUsername((Database)this.db, (String)username);
            if (member != null) {
                ByteArray handle = WebAuthn.toHandle(member.getId());
                LOGGER.debug("Member '{}' ({}) has handle '{}'", new Object[]{username, member.getId(), handle.getBase64Url()});
                return Optional.of(handle);
            }
            LOGGER.debug("No found member for username: {}", (Object)username);
        }
        catch (UnavailableCryptoException | QueryFailedException ex) {
            LOGGER.warn("Failed to get user handle for username: {}", (Object)username, (Object)ex);
        }
        return Optional.empty();
    }

    public Optional<String> getUsernameForUserHandle(ByteArray handle) {
        LOGGER.debug("Invoking: getUsernameForUserHandle({})", (Object)handle.getBase64Url());
        try {
            long memberId = WebAuthn.toMemberId(handle);
            Member member = DatabaseQuery.getMemberById((Database)this.db, (Long)memberId);
            if (member != null) {
                LOGGER.debug("Handle '{}' is '{}' ({})", new Object[]{handle.getBase64Url(), member.getUsername(), memberId});
                return Optional.of(member.getUsername());
            }
            LOGGER.debug("No found member for ID: {}", (Object)memberId);
        }
        catch (UnavailableCryptoException | QueryFailedException ex) {
            LOGGER.warn("Failed to get username for user handle", ex);
        }
        return Optional.empty();
    }

    public Optional<RegisteredCredential> lookup(ByteArray credentialId, ByteArray handle) {
        LOGGER.debug("Invoking: lookup({}, {})", (Object)credentialId.getBase64Url(), (Object)handle.getBase64Url());
        try {
            long memberId = WebAuthn.toMemberId(handle);
            Authenticator authenticator = Authenticators.getVerifiedAuthenticatorForMemberCredentialId((Database)this.db, (long)memberId, (byte[])credentialId.getBytes());
            if (authenticator != null) {
                byte[] publicKey = authenticator.getPublicKey();
                assert (publicKey != null) : "Public key of verified Webauthn should be never be null";
                RegisteredCredential registeredCredential = RegisteredCredential.builder().credentialId(credentialId).userHandle(handle).publicKeyCose(new ByteArray(publicKey)).signatureCount(authenticator.getSignCount()).build();
                LOGGER.debug("Found credentials {} for handle '{}'", (Object)credentialId, (Object)handle.getBase64Url());
                return Optional.of(registeredCredential);
            }
            LOGGER.warn("Unable to find registered credentials");
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to get lookup registered credentials", (Throwable)ex);
        }
        return Optional.empty();
    }

    public Set<RegisteredCredential> lookupAll(ByteArray credentialId) {
        LOGGER.debug("Invoking: lookupAll({})", (Object)credentialId.getBase64Url());
        try {
            List authenticators = Authenticators.listVerifiedWebauthnAuthenticatorsByCredentialId((Database)this.db, (byte[])credentialId.getBytes());
            LOGGER.debug("Found {} authenticators matching credentials '{}'", (Object)authenticators.size(), (Object)credentialId);
            HashSet<RegisteredCredential> credentials = new HashSet<RegisteredCredential>();
            for (Authenticator authenticator : authenticators) {
                ByteArray handle = WebAuthn.toHandle(authenticator.getMemberId());
                byte[] publicKey = authenticator.getPublicKey();
                assert (publicKey != null) : "Public key of verified Webauthn should be never be null";
                RegisteredCredential registeredCredential = RegisteredCredential.builder().credentialId(credentialId).userHandle(handle).publicKeyCose(new ByteArray(publicKey)).signatureCount(authenticator.getSignCount()).build();
                credentials.add(registeredCredential);
            }
            return credentials;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to get lookup registered credentials", (Throwable)ex);
            return Collections.emptySet();
        }
    }
}

