/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.core;

import com.pageseeder.base.security.GCM;
import com.pageseeder.db.model.Authenticator;
import org.eclipse.jdt.annotation.Nullable;

public final class ConfidentialData {
    private static final String KEY_ALIAS = "auth-data";

    private ConfidentialData() {
    }

    public static byte @Nullable [] encrypt(String data) {
        return GCM.encryptSilently(KEY_ALIAS, data);
    }

    public static @Nullable String decrypt(byte[] data) {
        return GCM.decryptSilently(KEY_ALIAS, data);
    }

    public static @Nullable String getData(Authenticator authenticator) {
        byte[] data = authenticator.getConfidentialData();
        if (data == null) {
            return null;
        }
        return ConfidentialData.decrypt(data);
    }

    public static void setData(Authenticator authenticator, @Nullable String data) {
        authenticator.setConfidentialData(data != null ? ConfidentialData.encrypt(data) : null);
    }

    public static String maskData(Authenticator authenticator) {
        String data = ConfidentialData.getData(authenticator);
        if (data == null) {
            return "";
        }
        if (!authenticator.isVerified()) {
            return data;
        }
        return data.replaceAll(".(?=.{4})", "*");
    }
}

