/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail.dkim;

import com.pageseeder.base.mail.dkim.DKIMSignerException;
import com.pageseeder.common.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.eclipse.angus.mail.util.QPEncoderStream;

public final class DKIM {
    protected static String[] splitHeader(String header) throws DKIMSignerException {
        int colon = header.indexOf(58);
        if (colon == -1) {
            throw new DKIMSignerException("The header string " + header + " is no valid RFC 822 header-line");
        }
        return new String[]{header.substring(0, colon), header.substring(colon + 1)};
    }

    protected static boolean isValidDomain(String domainname) {
        Pattern pattern = Pattern.compile("(.+)\\.(.+)");
        Matcher matcher = pattern.matcher(domainname);
        return matcher.matches();
    }

    protected static String QuotedPrintable(String s) {
        String string;
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        QPEncoderStream encodeStream = new QPEncoderStream((OutputStream)boas);
        try {
            encodeStream.write(s.getBytes());
            String encoded = boas.toString();
            encoded = encoded.replaceAll(";", "=3B");
            string = encoded = encoded.replaceAll(" ", "=20");
        }
        catch (Throwable throwable) {
            try {
                try {
                    encodeStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        encodeStream.close();
        return string;
    }

    protected static String base64Encode(byte[] b) {
        String encoded = new String(Base64.encode((byte[])b));
        encoded = encoded.replace("\n", "");
        return encoded.replace("\r", "");
    }

    public boolean checkDNSForPublickey(String signingDomain, String selector) throws DKIMSignerException {
        String[] tags;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        String recordname = selector + "._domainkey." + signingDomain;
        String value = null;
        try {
            InitialDirContext dnsContext = new InitialDirContext(env);
            Attributes attribs = dnsContext.getAttributes(recordname, new String[]{"TXT"});
            Attribute txtrecord = attribs.get("txt");
            if (txtrecord == null) {
                throw new DKIMSignerException("There is no TXT record available for " + recordname);
            }
            value = (String)txtrecord.get();
        }
        catch (NamingException ne) {
            throw new DKIMSignerException("Selector lookup failed", ne);
        }
        if (value == null) {
            throw new DKIMSignerException("Value of RR " + recordname + " couldn't be retrieved");
        }
        for (String tag : tags = value.split(";")) {
            if (!(tag = tag.trim()).startsWith("p=")) continue;
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PKCS8EncodedKeySpec pubSpec = new PKCS8EncodedKeySpec(tag.substring(2).getBytes());
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)((Object)keyFactory.generatePublic(pubSpec));
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new DKIMSignerException("RSA algorithm not found by JVM");
            }
            catch (InvalidKeySpecException ikse) {
                throw new DKIMSignerException("The public key " + tag + " in RR " + recordname + " couldn't be decoded.");
            }
            return true;
        }
        throw new DKIMSignerException("No public key available in " + recordname);
    }
}

