/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.EmailSender;
import com.pageseeder.base.mail.EmailTemplate;
import com.pageseeder.base.mail.MessageReceived;
import com.pageseeder.base.mail.NotificationSenderThread;
import com.pageseeder.base.mfa.core.VerificationCode;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.SecurityConfig;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.util.HTMLSanitizer;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.db.util.XLinks;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.html.HTMLElement;
import org.pageseeder.psml.md.MarkdownParser;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class Emails {
    private static final Logger LOGGER = LoggerFactory.getLogger(Emails.class);
    private static final int DEFAULT_MAX_EMAIL_THREAD = 20;
    public static final int MAX_REMINDER_TASKS = 25;
    private static final String DOT_ATOM = "a-z0-9!#\\$%&'*+/=?\\^_`\\{\\|}~-";
    private static final String LOCAL_PART_PATTERN = "[a-z0-9!#\\$%&'*+/=?\\^_`\\{\\|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?\\^_`\\{\\|}~-]+)*";
    private static final String DOMAIN_PATTERN = "(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
    private static final Pattern EMAIL = Pattern.compile("[a-z0-9!#\\$%&'*+/=?\\^_`\\{\\|}~-]+(?:\\.[a-z0-9!#\\$%&'*+/=?\\^_`\\{\\|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?", 2);
    public static final int DEFAULT_MAX_ATTACHMENT_SIZE = 10000000;

    private Emails() {
    }

    public static boolean areDisabled() {
        return "".equals(GlobalSettings.getString((String)"smtpServerAddress", (String)""));
    }

    public static boolean isAddress(String email) {
        if (email == null || email.isEmpty()) {
            return false;
        }
        if (email.indexOf(64) < 0) {
            return false;
        }
        return EMAIL.matcher(email).matches();
    }

    public static boolean getNotifyAsyncParameter(GeneratorRequest req) {
        return req.getParameter((Parameter)StandardParameters.notify_async, GlobalSettings.getBoolean((String)"smtpAsync", (boolean)false));
    }

    public static void sendIncomingMail(MimeMessage incoming, String to, String subjectPrefix, @Nullable String error) throws EmailException {
        String subject;
        if (Emails.areDisabled()) {
            return;
        }
        EmailSender sender = new EmailSender(null);
        sender.setFromPageSeeder();
        sender.addRecipient(to, null, null);
        try {
            subject = incoming.getSubject();
        }
        catch (MessagingException e) {
            subject = "Unknown incoming subject";
        }
        sender.setContent(incoming, (subjectPrefix != null ? subjectPrefix : "") + subject, error);
        sender.send(null, null, null);
    }

    public static void sendErrorReport(Database db, String destination, Group group, String textContent, Boolean async) throws EmailException {
        EmailSender sender = new EmailSender(null, false);
        String host = GlobalSettings.get((String)"webSiteAddress");
        String today = LocalDate.now().toString();
        String subject = String.format("PageSeeder error | %s | %s", today, host);
        if (group == null) {
            sender.setDefaultSubject(subject);
        } else {
            sender.setDefaultSubject(group.getName(), subject);
        }
        sender.setFromPageSeeder();
        sender.addRecipient(destination, null, group);
        sender.setContent(textContent, subject);
        sender.send(db, group, async);
    }

    public static void sendAutoResponder(Database db, XLink comment) throws DatabaseException, EmailException {
        if (Emails.areDisabled()) {
            return;
        }
        Group group = XLinkRule.getMainGroup(comment);
        EmailSender sender = new EmailSender(EmailTemplate.auto_responder);
        UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);
        out.startObject("autoresponder");
        out.field("minutes", GlobalSettings.getInt((String)"autoResponderMinutes", (int)90));
        out.field("limit", GlobalSettings.getInt((String)"autoResponderLimit", (int)25));
        out.field("replylimit", GlobalSettings.getInt((String)"autoResponderReplyLimit", (int)10));
        out.field("warnings", GlobalSettings.getInt((String)"autoResponderWarnings", (int)5));
        out.endObject();
        Emails.writeComment(db, comment, null, out);
        if (group == null) {
            sender.setDefaultSubject("WARNING: Comment limit reached");
        } else {
            sender.setDefaultSubject(group.getName(), "WARNING: Comment limit reached");
        }
        sender.setXMLSource(out.toString());
        sender.setFromPageSeeder();
        boolean canSend = Emails.addAuthorEmail(comment, group, sender);
        if (canSend) {
            sender.send(db, group, null);
        }
        sender.clearAllRecipients();
        canSend = false;
        Group adminGroup = DatabaseQuery.getGroupByName((Database)db, (String)"admin");
        for (MemberForGroup mfg : DatabaseQuery.getMemberForGroupsByGroupId((Database)db, (Long)adminGroup.getId())) {
            Member mem = mfg.getMember();
            if (!MemberRule.hasEmail(mem)) continue;
            sender.addRecipient(mem, group);
            canSend = true;
        }
        if (canSend) {
            sender.send(db, group, null);
        }
    }

    public static void sendOutOfOffice(Database db, Group group, XLink comment, boolean warning) throws EmailException {
        if (Emails.areDisabled()) {
            return;
        }
        EmailTemplate template = warning ? EmailTemplate.out_of_office_warning : EmailTemplate.out_of_office_change;
        String subject = warning ? "WARNING: Out Of Office detected" : "WARNING: Your notification options have been set to 'On Vacation'";
        EmailSender sender = new EmailSender(template);
        UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);
        out.startObject("outofoffice");
        out.field("string", GlobalSettings.getString((String)"outOfOfficeString", (String)"out of the office"));
        out.field("limit", GlobalSettings.getInt((String)"outOfOfficeLimit", (int)2));
        out.endObject();
        Emails.writeComment(db, comment, null, out);
        sender.setXMLSource(out.toString());
        sender.setFromPageSeeder();
        if (group == null) {
            sender.setDefaultSubject(subject);
        } else {
            sender.setDefaultSubject(group.getName(), subject);
        }
        boolean canSend = Emails.addAuthorEmail(comment, group, sender);
        if (canSend) {
            sender.send(db, group, null);
        }
    }

    public static void sendRejectMessage(Database db, XLink comment, Group group) throws EmailException {
        if (Emails.areDisabled()) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.reject_comment);
        UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);
        Emails.writeComment(db, comment, null, out);
        sender.setXMLSource(out.toString());
        sender.setFromPageSeeder();
        if (group == null) {
            sender.setDefaultSubject("RETURNED: " + comment.getContentTitle());
        } else {
            sender.setDefaultSubject(group.getName(), "RETURNED: " + comment.getContentTitle());
        }
        boolean canSend = Emails.addAuthorEmail(comment, group, sender);
        if (canSend) {
            sender.send(db, group, null);
        }
    }

    public static void sendNewMember(Database db, Member member, Group group, Member from, Boolean async) throws EmailException, DatabaseException {
        if (Emails.areDisabled() || !MemberRule.hasEmail(member)) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.new_member);
        HashMap<String, String> attributes = new HashMap<String, String>();
        PersistentToken token = PersistentToken.issuePSToken((Database)db, (Member)member, (PersistentToken.Purpose)PersistentToken.Purpose.activate_member, null, (Duration)OrganizationManager.instance().getSecurityConfig().getTokenExpiration(SecurityConfig.TokenType.ACTIVATE_MEMBER));
        attributes.put("token", token.getActualToken());
        sender.setNotificationAttributes(attributes);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMember(member, true);
            if (from != null) {
                out.writeMember(from, false, "inviter", null);
            }
            sender.setXMLSource(out.toString());
        }
        if (from != null) {
            sender.setFromMember(from);
        } else {
            sender.setFromPageSeeder();
        }
        if (group == null) {
            sender.setDefaultSubject("Welcome to PageSeeder");
        } else {
            sender.setDefaultSubject(group.getName(), "Welcome to PageSeeder");
        }
        sender.addRecipient(member, group);
        sender.send(db, group, async);
    }

    public static void sendNewMembershipMember(Database db, MemberForGroup membership, Member from, Boolean async) throws EmailException, DatabaseException {
        if (Emails.areDisabled() || !MemberRule.hasEmail(membership.getMember())) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.membership_new_member);
        HashMap<String, String> attributes = new HashMap<String, String>();
        PersistentToken token = PersistentToken.issuePSToken((Database)db, (Member)membership.getMember(), (PersistentToken.Purpose)PersistentToken.Purpose.activate_member, null, (Duration)OrganizationManager.instance().getSecurityConfig().getTokenExpiration(SecurityConfig.TokenType.ACTIVATE_MEMBER));
        attributes.put("token", token.getActualToken());
        sender.setNotificationAttributes(attributes);
        MemberDetailsConfig config = Emails.getMemberDetailsConfig(membership.getGroup());
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMembership(new Membership(membership), true, true, true, config, MemberDetailsConfig.Visibility.MEMBER, db);
            if (from != null) {
                out.writeMember(from, false, "inviter", null);
            }
            sender.setXMLSource(out.toString());
        }
        if (from != null) {
            sender.setFromMember(from);
        } else {
            sender.setFromGroup();
        }
        if (membership.getGroup() == null) {
            sender.setDefaultSubject("Welcome to PageSeeder");
        } else {
            sender.setDefaultSubject(membership.getGroup().getName(), "Welcome to PageSeeder");
        }
        sender.addRecipient(membership.getMember(), membership.getGroup());
        sender.send(db, membership.getGroup(), async);
    }

    public static void sendVerificationCodeEmail(Database db, @Nullable Group group, Member member, @Nullable String email, VerificationCode code, Boolean async) throws FoundationException, DatabaseException {
        if (Emails.areDisabled()) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.verification_code);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("code", code.code());
        sender.setNotificationAttributes(attributes);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMember(member, true);
            sender.setXMLSource(out.toString());
        }
        sender.setFromPageSeeder();
        if (group == null) {
            sender.setDefaultSubject("PAGESEEDER: Verification code");
        } else {
            sender.setDefaultSubject(group.getName(), "PAGESEEDER: Verification code");
        }
        if (email != null && !email.isEmpty()) {
            sender.addRecipient(email, MemberRule.getFullName(member), group);
        } else {
            sender.addRecipient(member, group);
        }
        sender.send(db, group, async);
    }

    public static void sendPasswordChangeEmail(Database db, Member member, @Nullable Group group, Boolean async) throws EmailException {
        if (Emails.areDisabled() || !MemberRule.hasEmail(member)) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.change_password);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMember(member, true);
            sender.setXMLSource(out.toString());
        }
        sender.setFromPageSeeder();
        if (group == null) {
            sender.setDefaultSubject("PAGESEEDER: Password updated");
        } else {
            sender.setDefaultSubject(group.getName(), "PAGESEEDER: Password updated");
        }
        sender.addRecipient(member, group);
        sender.send(db, group, async);
    }

    public static void sendEmailChangeEmail(Database db, Member member, String previousEmail, @Nullable Group group, Boolean async) throws EmailException {
        if (Emails.areDisabled() || !MemberRule.hasEmail(member)) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.change_email);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMember(member, true);
            sender.setXMLSource(out.toString());
        }
        sender.setFromPageSeeder();
        if (group == null) {
            sender.setDefaultSubject("PAGESEEDER: Email updated");
        } else {
            sender.setDefaultSubject(group.getName(), "PAGESEEDER: Email updated");
        }
        if (!"No Email".equals(previousEmail)) {
            sender.addRecipient(previousEmail, MemberRule.getFullName(member), group);
        }
        sender.addRecipient(member, group);
        sender.send(db, group, async);
    }

    public static void sendResetPasswordEmail(Database db, @Nullable Group group, Member member, ResetReason reason, @Nullable String useragent, Boolean async) throws FoundationException, DatabaseException {
        if (Emails.areDisabled()) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.reset_password_confirm);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("reason", reason.name().toLowerCase());
        PersistentToken token = PersistentToken.issuePSToken((Database)db, (Member)member, (PersistentToken.Purpose)PersistentToken.Purpose.reset_password, (String)useragent, (Duration)OrganizationManager.instance().getSecurityConfig().getTokenExpiration(SecurityConfig.TokenType.RESET_PASSWORD));
        attributes.put("token", token.getActualToken());
        sender.setNotificationAttributes(attributes);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMember(member, true);
            sender.setXMLSource(out.toString());
        }
        sender.setFromPageSeeder();
        if (group == null) {
            sender.setDefaultSubject("PAGESEEDER: Password reset");
        } else {
            sender.setDefaultSubject(group.getName(), "PAGESEEDER: Password reset");
        }
        sender.addRecipient(member, group);
        sender.send(db, group, async);
    }

    public static void sendChangeEmail(Database db, Group group, Member member, String newEmail, Boolean async) throws EmailException, DatabaseException {
        if (Emails.areDisabled() || !MemberRule.hasEmail(member)) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.change_email_confirm);
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (newEmail != null) {
            attributes.put("newemail", newEmail);
        }
        PersistentToken token = PersistentToken.issuePSToken((Database)db, (Member)member, (PersistentToken.Purpose)PersistentToken.Purpose.change_email, (String)newEmail, (Duration)OrganizationManager.instance().getSecurityConfig().getTokenExpiration(SecurityConfig.TokenType.CHANGE_EMAIL));
        attributes.put("token", token.getActualToken());
        sender.setNotificationAttributes(attributes);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMember(member, true);
            sender.setXMLSource(out.toString());
        }
        sender.setFromPageSeeder();
        if (group == null) {
            sender.setDefaultSubject("PageSeeder email change confirmation");
        } else {
            sender.setDefaultSubject(group.getName(), "PageSeeder email change confirmation");
        }
        sender.addRecipient(newEmail, member.getFirstName() + " " + member.getSurname(), group);
        sender.send(db, group, async);
    }

    public static void sendAcceptComment(Database db, Group group, XLink comment, Boolean async) throws EmailException {
        if (Emails.areDisabled()) {
            return;
        }
        Member mod = comment.getModifiedBy();
        if (mod == null) {
            throw new EmailException("No Moderator for comment " + comment.getId());
        }
        if (!MemberRule.hasEmail(mod)) {
            throw new EmailException("Moderator has no email: " + MemberRule.getFullName(mod));
        }
        EmailSender sender = new EmailSender(EmailTemplate.accept_comment);
        UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);
        Emails.writeComment(db, comment, null, out);
        sender.setXMLSource(out.toString());
        sender.setFromComment(comment, false);
        if (group != null) {
            sender.setDefaultSubject(group.getName(), "[" + group.getName() + "]* " + comment.getContentTitle());
        }
        sender.addRecipient(mod, group);
        sender.send(db, group, async);
    }

    public static void sendMembershipAccept(Database db, MemberForGroup mfg, Boolean async) throws DatabaseException, EmailException {
        if (Emails.areDisabled()) {
            return;
        }
        Group group = mfg.getGroup();
        Member mem = mfg.getMember();
        MemberForGroup modmfg = DatabaseQuery.getModeratorByGroupId((Database)db, (Long)group.getId());
        if (modmfg == null) {
            throw new EmailException("No Moderator for group: " + group.getName());
        }
        if (!MemberRule.hasEmail(modmfg.getMember())) {
            throw new EmailException("Moderator has no email: " + MemberRule.getFullName(modmfg.getMember()));
        }
        EmailSender sender = new EmailSender(EmailTemplate.membership_accept);
        MemberDetailsConfig config = Emails.getMemberDetailsConfig(group);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMember(modmfg.getMember(), false, "moderator", null);
            out.writeMembership(new Membership(mfg), config, MemberDetailsConfig.Visibility.MEMBER, db);
            sender.setXMLSource(out.toString());
        }
        sender.setFromMember(mem);
        sender.setDefaultSubject(group.getName(), "[" + group.getName() + "] " + (GroupRule.isProject(group) ? "Project" : "Group") + " registration request");
        sender.addRecipient(modmfg.getMember(), group);
        sender.send(db, group, async);
    }

    public static void sendMembershipConfirm(Database db, MemberForGroup mfg, Member from, Boolean async) throws EmailException {
        if (Emails.areDisabled()) {
            return;
        }
        Group group = mfg.getGroup();
        Member mem = mfg.getMember();
        if (!MemberRule.hasEmail(mem)) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.membership_confirm);
        MemberDetailsConfig config = Emails.getMemberDetailsConfig(group);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMembership(new Membership(mfg), true, true, true, config, MemberDetailsConfig.Visibility.MEMBER, db);
            if (from != null) {
                out.writeMember(from, false, "inviter", null);
            }
            sender.setXMLSource(out.toString());
        }
        if (from != null) {
            sender.setFromMember(from);
        } else {
            sender.setFromGroup();
        }
        if (group != null) {
            sender.setDefaultSubject(group.getName(), "[" + group.getName() + "] " + (GroupRule.isProject(group) ? "Project" : "Group") + " invitation");
        }
        sender.addRecipient(mfg.getMember(), group);
        sender.send(db, group, async);
    }

    public static void sendMembershipComplete(Database db, MemberForGroup mfg, Member from, Boolean async) throws DatabaseException, EmailException {
        if (Emails.areDisabled()) {
            return;
        }
        Group group = mfg.getGroup();
        Member mem = mfg.getMember();
        if (!MemberRule.hasEmail(mem)) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.membership_complete);
        HashMap<String, String> attributes = new HashMap<String, String>();
        boolean generalDiscussion = DatabaseQuery.getGeneralDiscussionGroupURI((Database)db, (Group)group) != null;
        attributes.put("generalcomments", String.valueOf(generalDiscussion));
        String helpurl = null;
        try {
            helpurl = GroupProperties.get(db, group).getProperty("helpUrl");
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load help URL for {}", (Object)group.getName(), (Object)ex);
        }
        if (helpurl != null) {
            attributes.put("helpurl", helpurl);
        }
        sender.setNotificationAttributes(attributes);
        MemberDetailsConfig config = Emails.getMemberDetailsConfig(group);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeMembership(new Membership(mfg), true, true, true, config, MemberDetailsConfig.Visibility.MEMBER, db);
            if (from != null) {
                out.writeMember(from, false, "inviter", null);
            }
            sender.setXMLSource(out.toString());
        }
        if (from != null) {
            sender.setFromMember(from);
        } else {
            sender.setFromGroup();
        }
        sender.setDefaultSubject(group.getName(), "[" + group.getName() + "] " + (GroupRule.isProject(group) ? "Project" : "Group") + " registration");
        sender.addRecipient(mem, group);
        sender.send(db, group, async);
    }

    public static void sendCommentDigest(Database db, Group group, String frequency, Collection<XLink> comments, Collection<Member> members) throws EmailException {
        if (Emails.areDisabled() || comments == null || comments.isEmpty() || members == null || members.isEmpty()) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.comment_digest);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("frequency", frequency);
        sender.setNotificationAttributes(attributes);
        try (UniversalPrinter out = new UniversalPrinter(new XMLOutputPrinter());){
            out.startCollection("comments");
            for (XLink xLink : comments) {
                Content cont;
                String text;
                String xhtml = null;
                Iterator conti = xLink.getContents();
                if (conti.hasNext() && (text = (cont = (Content)conti.next()).getData()) != null) {
                    xhtml = Emails.textToXHTML(text);
                    xhtml = Emails.getXHTMLBodyContent(xhtml);
                }
                out.writeComment(xLink, db, null, null, true, true, true, true, xhtml);
            }
            out.endCollection();
            sender.setXMLSource(out.toString());
        }
        catch (IOException ex) {
            throw new EmailException("Failed to add member to notification XML source: " + ex.getMessage());
        }
        sender.setFromGroup();
        if (group != null) {
            sender.setDefaultSubject(group.getName(), "[" + group.getName() + "] " + ("daily".equals(frequency) ? "Daily" : "Weekly") + " digest");
        }
        boolean atLeastOne = false;
        for (Member member : members) {
            if (!MemberRule.hasEmail(member) || MemberRule.onVacation(member) || !MemberRule.isMemberActivated(member) || MemberRule.isMemberDisabled(member)) continue;
            sender.addRecipient(member, group);
            atLeastOne = true;
        }
        if (atLeastOne) {
            sender.send(db, group, null);
        }
    }

    public static void sendReminderDigest(Database db, Group group, List<ReminderTask> reminderTasks, Member member) throws EmailException, QueryFailedException {
        if (Emails.areDisabled() || reminderTasks.isEmpty()) {
            return;
        }
        EmailSender sender = new EmailSender(EmailTemplate.reminder_digest);
        HashMap<String, String> attributes = new HashMap<String, String>();
        sender.setNotificationAttributes(attributes);
        try (UniversalPrinter out = new UniversalPrinter(new XMLOutputPrinter());){
            out.startCollection("comments");
            if (reminderTasks.size() == 26) {
                out.field("limitreached", true);
                reminderTasks.remove(25);
            }
            for (ReminderTask rt : reminderTasks) {
                XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)rt.xlinkid);
                Group g = DatabaseQuery.getGroupById((Database)db, (Long)rt.groupid);
                if (xl == null || g == null) continue;
                out.writeComment(xl, db, null, Collections.singleton(g), true, false, false, false);
            }
            out.endCollection();
            sender.setXMLSource(out.toString());
        }
        sender.setFromPageSeeder();
        sender.setDefaultSubject("PageSeeder reminders");
        sender.addRecipient(member, group);
        sender.send(db, group, false);
    }

    public static boolean sendNewURI(Database db, Member author, String title, String content, String role, String[] labels, Collection<URI> attachments, Group group, boolean announce, Boolean async) throws DatabaseException, EmailException {
        if (Emails.areDisabled()) {
            return false;
        }
        EmailSender sender = new EmailSender(EmailTemplate.new_uri);
        sender.setFromMember(author);
        sender.setNotificationAttributes(Collections.singletonMap("announcement", String.valueOf(announce)));
        try (UniversalPrinter out = new UniversalPrinter(new XMLOutputPrinter());){
            out.startObject("message");
            out.field("contentrole", attachments.isEmpty() ? "Comment" : role);
            out.field("created", ISO8601.format((long)new Date().getTime(), (ISO8601)ISO8601.DATETIME));
            out.field("title", title, OutputPrinter.FieldOption.XML_ELEMENT);
            if (labels != null && labels.length > 0) {
                out.field("labels", labels, OutputPrinter.FieldOption.XML_ELEMENT);
            }
            out.writeMember(author, false, "author", null);
            out.startObject("content");
            out.field("type", "text/plain");
            out.field("content", content, OutputPrinter.FieldOption.XML_TEXT);
            out.endObject();
            String xhtml = Emails.textToXHTML(content);
            xhtml = Emails.getXHTMLBodyContent(xhtml);
            out.startObject("content");
            out.field("type", "application/xhtml+xml");
            out.field("content", xhtml, OutputPrinter.FieldOption.XML_COPY);
            out.endObject();
            for (URI u : attachments) {
                out.startObject("attachment");
                out.writeURI(u);
                out.endObject();
            }
            out.endObject();
            sender.setXMLSource(out.toString());
        }
        catch (IOException ex) {
            throw new EmailException("Failed to build email content", ex);
        }
        Collection members = announce ? DatabaseQuery.getMembersByGroupId((Database)db, (Long)group.getId()) : DatabaseQuery.getMembersByGroupIdNotification((Database)db, (Long)group.getId(), (String)"Immediate");
        sender.setDefaultSubject(group.getName(), "[" + group.getName() + "] " + title);
        EmailSender senderWithAttachments = sender.copy();
        boolean sentNow = true;
        for (Member mem : members) {
            if (!MemberRule.hasEmail(mem) || MemberRule.onVacation(mem)) continue;
            if (mem.hasSubmitPref('t')) {
                senderWithAttachments.addRecipient(mem.getEmail(), mem.getFirstName() + " " + mem.getSurname(), group);
                continue;
            }
            sender.addRecipient(mem.getEmail(), mem.getFirstName() + " " + mem.getSurname(), group);
        }
        if (!sender.getRecipientTos().isEmpty()) {
            sentNow = Emails.sendEmail(sender, author.getUsername(), group, db, async);
        }
        if (!senderWithAttachments.getRecipientTos().isEmpty()) {
            for (URI uri : attachments) {
                senderWithAttachments.addAttachment(uri);
            }
            if (!Emails.sendEmail(senderWithAttachments, author.getUsername(), group, db, async)) {
                sentNow = false;
            }
        }
        return !sentNow;
    }

    public static boolean sendNewComment(Database db, XLink comment, Map<String, Map<String, String>> recipients, String xhtmlContent, Notify notify, boolean statusChanged, boolean modified, Boolean async) throws EmailException, DatabaseException {
        if (Emails.areDisabled()) {
            return false;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("modified", String.valueOf(modified));
        attributes.put("taskchanged", String.valueOf(statusChanged && (comment.getStatusChangedDate() != null || comment.getModifiedDate() != null)));
        attributes.put("announcement", Boolean.toString(notify == Notify.ANNOUNCE));
        UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);
        if (recipients != null) {
            out.startCollection("recipients");
            for (Map.Entry<String, Map<String, String>> recipient : recipients.entrySet()) {
                String type = recipient.getKey();
                Map<String, String> tos = recipient.getValue();
                for (Map.Entry<String, String> entry : tos.entrySet()) {
                    String email = entry.getKey();
                    String name = entry.getValue();
                    out.startObject("recipient");
                    out.field("type", type);
                    out.field("email", email);
                    if (!Strings.isEmpty((String)name)) {
                        out.field("name", name);
                    }
                    out.endObject();
                }
            }
            out.endCollection();
        }
        Emails.writeComment(db, comment, xhtmlContent, out);
        EmailSender sender = new EmailSender(EmailTemplate.new_comment);
        sender.setNotificationAttributes(attributes);
        sender.setXMLSource(out.toString());
        sender.setFromComment(comment, modified);
        EmailSender senderWithAttachments = sender.copy();
        boolean sentNow = true;
        ArrayList<String> addedEmails = new ArrayList<String>();
        Collection<Group> groups = XLinkRule.getGroups(comment);
        for (Group group : groups) {
            if (GroupRule.isAdminGroup(group.getName()) || GroupRule.isPublicGroup(group.getName())) continue;
            sender.setDefaultSubject(group.getName(), "[" + group.getName() + "] " + (comment.getStatus() != null ? "(Task) " : "") + comment.getContentTitle());
            Emails.addRecipients(sender, senderWithAttachments, db, comment, group, addedEmails, notify, false, statusChanged);
        }
        Group group = XLinkRule.getMainGroup(comment);
        String author = Emails.getAuthor(comment);
        if (!sender.getRecipientTos().isEmpty()) {
            sentNow = Emails.sendEmail(sender, author, group, db, async);
        }
        if (!senderWithAttachments.getRecipientTos().isEmpty() && !Emails.sendEmail(senderWithAttachments, author, group, db, async)) {
            sentNow = false;
        }
        return !sentNow;
    }

    private static void writeComment(Database db, XLink comment, @Nullable String xhtmlContent, UniversalPrinter out) throws EmailException {
        String textContent = null;
        Iterator contents = comment.getContents();
        if (contents.hasNext()) {
            Content cont = (Content)contents.next();
            String contenttype = cont.getType();
            if ("text/plain".equals(contenttype) && xhtmlContent == null) {
                try {
                    xhtmlContent = Emails.textToXHTML(cont.getData());
                }
                catch (IOException ex) {
                    throw new EmailException("Unable to parse text as markdown: " + ex.getMessage(), ex);
                }
            } else if ("application/xhtml+xml".equals(contenttype)) {
                String string = textContent = cont.getData() != null ? Emails.xhtmlToText(cont.getData()) : "";
            }
        }
        if (xhtmlContent != null) {
            xhtmlContent = Emails.getXHTMLBodyContent(xhtmlContent);
        }
        out.writeComment(comment, db, null, null, true, true, true, true, xhtmlContent, null, textContent);
    }

    public static boolean sendPreservedIncomingMailComment(Database db, MessageReceived mail, XLink comment) throws EmailException, DatabaseException {
        if (Emails.areDisabled()) {
            return false;
        }
        long limit = 200L;
        String p = "p";
        String e = "e";
        if ((e + "val").equals(GlobalSettings.get((String)(p + "roductKey"))) && (comment.getId() < 0L || comment.getId() > 100L)) {
            throw new EmailException("Failed evaluation max nb of comments: 200");
        }
        EmailSender sender = new EmailSender(EmailTemplate.new_comment);
        if (mail.getMultipart() != null) {
            sender.setContent((Multipart)mail.getMultipart(), mail.getPreserveSubject());
        } else {
            sender.setContent(mail.getTextMailPart(), mail.getPreserveSubject());
        }
        sender.setFromComment(comment, false);
        EmailSender senderWithAttachments = sender.copy();
        boolean sentNow = true;
        ArrayList<String> addedEmails = new ArrayList<String>();
        Collection<Group> groups = XLinkRule.getGroups(comment);
        for (Group group : groups) {
            if (GroupRule.isAdminGroup(group.getName()) || GroupRule.isPublicGroup(group.getName())) continue;
            sender.setDefaultSubject(group.getName(), "[" + group.getName() + "] " + (comment.getStatus() != null ? "(Task) " : "") + comment.getContentTitle());
            Emails.addRecipients(sender, senderWithAttachments, db, comment, group, addedEmails, Emails.getNotify(mail, comment), true, false);
        }
        Group threadGroup = XLinkRule.getMainGroup(comment);
        String author = Emails.getAuthor(comment);
        if (!sender.getRecipientTos().isEmpty()) {
            sentNow = Emails.sendEmail(sender, author, threadGroup, db, null);
        }
        if (!senderWithAttachments.getRecipientTos().isEmpty()) {
            sentNow = sentNow && Emails.sendEmail(senderWithAttachments, author, threadGroup, db, null);
        }
        return !sentNow;
    }

    private static Notify getNotify(MessageReceived mail, XLink comment) {
        if (mail.isAnnounce()) {
            return Notify.ANNOUNCE;
        }
        return comment.getStatus() != null ? Notify.MINIMAL : Notify.NORMAL;
    }

    public static boolean sendNewVersion(Database db, XLink version, URI uri, Notify notify, Boolean async) throws EmailException, DatabaseException {
        if (Emails.areDisabled()) {
            return false;
        }
        long limit = 200L;
        String p = "p";
        String e = "e";
        if ((e + "val").equals(GlobalSettings.get((String)(p + "roductKey"))) && (version.getId() < 0L || version.getId() > 100L)) {
            throw new EmailException("Failed evaluation max nb of comments: 200");
        }
        Map<String, String> attributes = Collections.singletonMap("announcement", Boolean.toString(notify == Notify.ANNOUNCE));
        EmailSender sender = new EmailSender(EmailTemplate.new_version);
        sender.setNotificationAttributes(attributes);
        try (UniversalPrinter out = UniversalPrinter.newWriter(OutputType.XML);){
            out.writeVersion(version);
            out.writeURI(uri);
            sender.setXMLSource(out.toString());
        }
        sender.setFromComment(version, false);
        EmailSender senderWithAttachments = sender.copy();
        boolean sentNow = true;
        ArrayList<String> addedEmails = new ArrayList<String>();
        Collection<Group> groups = XLinkRule.getGroups(version);
        for (Group group : groups) {
            if (GroupRule.isAdminGroup(group.getName()) || GroupRule.isPublicGroup(group.getName())) continue;
            sender.setDefaultSubject(group.getName(), "[" + group.getName() + "] " + uri.getDisplayTitle() + " version " + version.getContentTitle());
            Emails.addRecipients(sender, senderWithAttachments, db, version, group, addedEmails, notify, false, false);
        }
        Group threadGroup = XLinkRule.getMainGroup(version);
        String author = Emails.getAuthor(version);
        if (!sender.getRecipientTos().isEmpty()) {
            sentNow = Emails.sendEmail(sender, author, threadGroup, db, async);
        }
        if (!senderWithAttachments.getRecipientTos().isEmpty()) {
            sentNow = sentNow && Emails.sendEmail(senderWithAttachments, author, threadGroup, db, async);
        }
        return !sentNow;
    }

    private static void addRecipients(EmailSender sender, EmailSender senderWithAttachments, Database db, XLink xlink, Group group, Collection<String> emailsAdded, Notify notify, boolean preserve, boolean statusChanged) throws QueryFailedException {
        Object statuses;
        LOGGER.debug("sendXLink: group={}, notify={}, preserve={}, statusChanged={}", new Object[]{group.getName(), notify, preserve, statusChanged});
        ArrayList<Member> memsWithAttachs = new ArrayList<Member>();
        if (notify == Notify.NORMAL || notify == Notify.ANNOUNCE) {
            Collection members = notify == Notify.ANNOUNCE ? DatabaseQuery.getMembersByGroupId((Database)db, (Long)group.getId()) : DatabaseQuery.getMembersByGroupIdNotification((Database)db, (Long)group.getId(), (String)"Immediate");
            for (Member mem : members) {
                if (!MemberRule.hasEmail(mem) || emailsAdded.contains(mem.getEmail()) || MemberRule.onVacation(mem) || !MemberRule.isMemberActivated(mem) || MemberRule.isMemberDisabled(mem)) continue;
                emailsAdded.add(mem.getEmail());
                if (mem.hasSubmitPref('t') && !preserve) {
                    memsWithAttachs.add(mem);
                    continue;
                }
                sender.addRecipient(mem, group);
            }
        }
        try {
            Properties grpProps = GroupProperties.get(db, group);
            statuses = grpProps.getProperty("statusBroadcastApprovers") + ",";
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load group properties for {}", (Object)group.getName(), (Object)ex);
            statuses = "";
        }
        String status = xlink.getStatus();
        if (!XLinks.isVersion((XLink)xlink) && notify != Notify.SILENT) {
            Emails.addMemberToRecipients(db, xlink.getAssignedTo(), sender, group, emailsAdded, memsWithAttachs);
            if (!"Workflow".equals(xlink.getContentRole())) {
                XLink threadRoot = XLinks.getThreadRoot((XLink)xlink);
                Collection threadXLinks = threadRoot.getRepliesCol();
                threadXLinks.add(threadRoot);
                for (XLink threadXLink : threadXLinks) {
                    Member mem = threadXLink.getMember();
                    if (mem == null) continue;
                    Emails.addMemberToRecipients(db, mem, sender, group, emailsAdded, memsWithAttachs);
                }
            }
        }
        if (statusChanged && status != null && notify != Notify.SILENT && ((String)statuses).contains(status + ",")) {
            Collection mems = DatabaseQuery.getMembersByGroupIdApprover((Database)db, (Long)group.getId());
            for (Member member : mems) {
                Emails.addMemberToRecipients(db, member, sender, group, emailsAdded, memsWithAttachs);
            }
        }
        List<URI> attachments = Emails.findAttachments(db, xlink);
        if (!memsWithAttachs.isEmpty()) {
            for (Member member : memsWithAttachs) {
                senderWithAttachments.addRecipient(member, group);
            }
            if (!attachments.isEmpty()) {
                for (URI u : attachments) {
                    senderWithAttachments.addAttachment(u);
                }
            }
        }
    }

    private static String getXHTMLBodyContent(String xhtml) {
        Matcher bodyStart = Pattern.compile("<body(>|\\W)").matcher(xhtml);
        if (bodyStart.find()) {
            int bodyEnd = xhtml.indexOf("</body>", bodyStart.start() + 1);
            xhtml = bodyEnd == -1 ? xhtml.substring(xhtml.indexOf(">", bodyStart.start()) + 1) : xhtml.substring(xhtml.indexOf(">", bodyStart.start()) + 1, bodyEnd);
        }
        return xhtml;
    }

    public static boolean sendEmail(EmailSender sender, String author, Group threadGroup, Database db, Boolean async) throws EmailException {
        int emailMaxThreadMessages = GlobalSettings.getInt((String)"emailMaxThreadMessages", (int)20);
        if (sender.getRecipientTos().size() > emailMaxThreadMessages) {
            NotificationSenderThread thread = NotificationSenderThread.newInstance(author, "Notification " + sender.getTemplate(), threadGroup);
            thread.setSender(sender);
            ProcessManager.getInstance().start(thread);
            return false;
        }
        sender.send(db, threadGroup, async);
        return true;
    }

    private static void addMemberToRecipients(Database db, Member member, EmailSender sender, Group group, Collection<String> addedEmails, Collection<Member> includeAttachment) throws QueryFailedException {
        if (member != null && MemberRule.hasEmail(member) && !addedEmails.contains(member.getEmail()) && !MemberRule.onVacation(member) && MemberRule.isMemberActivated(member) && !MemberRule.isMemberDisabled(member)) {
            Membership membership = MemberForGroupRule.getMembership(group, member, true, false, db);
            if (membership == null || membership.getNotification() == Notification.NONE) {
                return;
            }
            addedEmails.add(member.getEmail());
            if (member.hasSubmitPref('t')) {
                includeAttachment.add(member);
            } else {
                sender.addRecipient(member, group);
            }
        }
    }

    private static List<URI> findAttachments(Database db, XLink comment) {
        long maxSize = GlobalSettings.getInt((String)"maxAttachmentSize", (int)10000000);
        ArrayList<URI> attachments = new ArrayList<URI>();
        Iterator locs = comment.getLocatorsForXLink((Object)Predicates.predicateXLinkForLocatorRoleContains((Database)db, (String)"file-"));
        while (locs.hasNext()) {
            File actualFile;
            URI tempUri;
            LocatorForXLink lfx = (LocatorForXLink)locs.next();
            if (!lfx.getRole().startsWith("file-") || (tempUri = URIRule.getURIByLocator(db, lfx.getLocator())).getPath().endsWith("_message.htm") || "folder".equals(tempUri.getType()) || tempUri.getExternal().booleanValue() || URIRule.isPSML(tempUri) || (actualFile = new File(URIRule.getRealPath(tempUri.getPath()))).length() >= maxSize) continue;
            attachments.add(tempUri);
        }
        return attachments;
    }

    private static boolean addAuthorEmail(XLink comment, Group group, EmailSender sender) {
        boolean canSend = false;
        Member auth = comment.getMember();
        if (auth == null) {
            String authorEmail = comment.getAuthorEmail();
            if (!"No Email".equals(authorEmail)) {
                sender.addRecipient(authorEmail, comment.getAuthorName(), group);
                canSend = true;
            }
        } else if (MemberRule.hasEmail(auth)) {
            sender.addRecipient(auth, group);
            canSend = true;
        }
        return canSend;
    }

    private static MemberDetailsConfig getMemberDetailsConfig(Group group) {
        if (group != null && group.getDetailsForm() != null) {
            try {
                return MemberGroupDetailsRule.getMemberDetailsConfig(group);
            }
            catch (FoundationException ex) {
                LOGGER.error("Invalid group config for {}", (Object)group.getName(), (Object)ex);
            }
        }
        return null;
    }

    static String textToXHTML(String text) throws IOException {
        MarkdownParser parser = new MarkdownParser();
        if (text == null) {
            text = "";
        }
        HTMLElement html = parser.parseToHTML((Reader)new StringReader(text));
        XMLStringWriter xhtml = new XMLStringWriter(XML.NamespaceAware.No);
        html.toXML((XMLWriter)xhtml);
        return xhtml.toString();
    }

    static String htmlToXHTML(String html) {
        return HTMLSanitizer.sanitizeForEmails(html);
    }

    static String xhtmlToText(String xhtml) {
        xhtml = "<body>" + (String)xhtml + "</body>";
        XHTMLToTextHandler handler = new XHTMLToTextHandler();
        try {
            XMLHelpers.parse(new ByteArrayInputStream(((String)xhtml).getBytes(StandardCharsets.UTF_8)), handler);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to create text content from HTML email", (Throwable)ex);
            return null;
        }
        return handler.text.toString();
    }

    private static String getAuthor(XLink xLink) {
        Member member = xLink.getMember();
        return member != null ? member.getUsername() : xLink.getAuthorName();
    }

    public static class ReminderTask {
        private final long xlinkid;
        private final long groupid;

        public ReminderTask(long xlinkid, long groupid) {
            this.xlinkid = xlinkid;
            this.groupid = groupid;
        }
    }

    private static final class XHTMLToTextHandler
    extends DefaultHandler {
        private StringWriter text = new StringWriter();
        private boolean ignore = false;

        private XHTMLToTextHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("body".equals(localName)) {
                this.text = new StringWriter();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("body".equals(localName)) {
                this.ignore = true;
            }
            if (this.ignore) {
                return;
            }
            String element = localName.toLowerCase();
            if ("p".equals(element) || "h1".equals(element) || "h2".equals(element) || "h3".equals(element) || "h4".equals(element) || "h5".equals(element) || "h6".equals(element) || "li".equals(element) || "div".equals(element) || "br".equals(element) || "blockquote".equals(element) || "dt".equals(element) || "pre".equals(element) || "table".equals(element)) {
                this.text.write(10);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.ignore) {
                return;
            }
            boolean onlySpaces = true;
            for (int i = start; onlySpaces && i < start + length; ++i) {
                if (Character.isWhitespace(ch[i])) continue;
                onlySpaces = false;
            }
            if (!onlySpaces) {
                this.text.write(ch, start, length);
            }
        }
    }

    public static enum ResetReason {
        MEMBER,
        ADMIN,
        FORCED;

    }
}

