/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.XLoggable;
import com.pageseeder.common.util.MD5;
import com.pageseeder.common.util.Strings;
import com.pageseeder.common.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;

public final class MailEvent
implements XLoggable {
    private String from;
    private String to;
    private @Nullable String subject;
    private String message;
    private final boolean incoming;
    private final StringBuilder throwable = new StringBuilder();

    private MailEvent(boolean inc) {
        this.incoming = inc;
    }

    public static MailEvent newIncoming(String from, Collection<String> to, String subject) {
        MailEvent event = new MailEvent(true);
        event.from = from;
        event.to = String.join((CharSequence)",", to);
        event.subject = subject;
        return event;
    }

    public static MailEvent newOutgoing(String from, String to, String subject) {
        MailEvent event = new MailEvent(false);
        event.from = from;
        event.to = to;
        event.subject = subject;
        return event;
    }

    public static MailEvent newIncoming(String from, Collection<String> to, @Nullable String subject, String message, @Nullable Throwable t) {
        MailEvent event = new MailEvent(true);
        event.from = from;
        event.to = String.join((CharSequence)",", to);
        event.subject = subject;
        event.message = message;
        if (t != null) {
            StringWriter w = new StringWriter();
            t.printStackTrace(new PrintWriter(w));
            event.throwable.append(w);
        }
        return event;
    }

    public static MailEvent newOutgoing(String from, String to, String subject, String message, @Nullable Throwable t) {
        MailEvent event = new MailEvent(false);
        event.from = from;
        event.to = to;
        event.subject = subject;
        event.message = message;
        if (t != null) {
            StringWriter w = new StringWriter();
            t.printStackTrace(new PrintWriter(w));
            event.throwable.append(w);
        }
        return event;
    }

    @Override
    public void toXMLLog(Appendable xml) throws IOException {
        xml.append("<mail ");
        xml.append(" from=\"").append(XMLUtils.escapeAttValue((String)this.from)).append('\"');
        xml.append(" to=\"").append(XMLUtils.escapeAttValue((String)this.to)).append('\"');
        xml.append(" incoming=\"").append(String.valueOf(this.incoming)).append('\"');
        if (!Strings.isEmpty((String)this.subject)) {
            xml.append(" subject=\"").append(XMLUtils.escapeAttValue((String)this.subject)).append('\"');
        }
        if (!Strings.isEmpty((String)this.message)) {
            xml.append(" message=\"").append(this.message).append('\"');
        }
        if (this.throwable.length() > 0) {
            xml.append(">\r\n  <throwable>").append(XMLUtils.escapeText((String)this.throwable.toString())).append("</throwable>\r\n</mail>\r\n");
        } else {
            xml.append("/>\r\n");
        }
    }

    @Override
    public String getTicket() {
        return MD5.hash((String)(this.incoming + "-" + this.subject + "-" + this.from + "-" + this.to + "-" + this.message));
    }

    @Override
    public @Nullable Long getGroupID() {
        return null;
    }

    @Override
    public @Nullable String getGroup() {
        return null;
    }

    @Override
    public @Nullable String getUser() {
        return null;
    }

    @Override
    public @Nullable String getTitle() {
        return this.subject;
    }

    @Override
    public XLoggable.TYPE getType() {
        return XLoggable.TYPE.END;
    }
}

