/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.DailyLogFileFilter;
import com.pageseeder.base.logback.XLogException;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.base.logback.XLogs;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DailySummary
implements XMLWritable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DailySummary.class);
    private static final Comparator<File> FILE_AGE = (a, b) -> {
        long diff = a.lastModified() - b.lastModified();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    };
    private static final Comparator<TicketSummary> TICKETS_AGE = (a, b) -> {
        long diff = a.started - b.started;
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    };
    private final File directory;
    private Date date;
    private @Nullable String from = null;
    private @Nullable String to = null;
    private List<String> permissions = new ArrayList<String>();
    private List<String> methods = new ArrayList<String>();
    private int hour = -1;
    private @Nullable String group = null;
    private @Nullable Long groupId = null;
    private boolean accessLogs = false;
    private @Nullable Map<Long, List<TicketSummary>> tickets = null;
    private GroupBy groupBy = GroupBy.NONE;
    private static final int MAX_TICKETS = 20;

    public DailySummary(XLoggerAdaptor xlogger) {
        this.directory = xlogger.getDirectory();
        this.date = new Date();
    }

    public DailySummary(File directory) {
        this.directory = directory;
        this.date = new Date();
    }

    public void setRange(String from, String to) {
        this.from = from;
        this.to = to;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setAccessLogs() {
        this.accessLogs = true;
    }

    public void setGroupBy(GroupBy by) {
        this.groupBy = by;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDate(String date) throws ParseException {
        this.date = ISO8601.parseAuto((String)date);
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setGroup(@Nullable Long group) {
        this.groupId = group;
    }

    public void forServer() {
        this.groupId = 0L;
    }

    public boolean isEmpty() {
        return this.tickets != null && this.tickets.isEmpty();
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("summary", true);
        xml.attribute("date", ISO8601.CALENDAR_DATE.format(this.date.getTime()));
        for (Map.Entry<Long, List<TicketSummary>> e : this.tickets.entrySet()) {
            xml.openElement(this.accessLogs && this.groupBy != GroupBy.GROUP ? "access" : "group", true);
            if (!this.accessLogs || this.groupBy == GroupBy.GROUP) {
                TicketSummary first = e.getValue().get(0);
                if (first.getGroupId() != null) {
                    xml.attribute("id", first.getGroupId().toString());
                }
                if (first.getGroupName() != null) {
                    xml.attribute("name", first.getGroupName());
                }
            }
            for (TicketSummary ticket : e.getValue()) {
                ticket.toXML(xml);
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    public void build() throws XLogException {
        File saved;
        boolean mustGroup;
        XLoggerAdaptor.ensureRollover();
        boolean bl = mustGroup = this.accessLogs && this.from == null && this.to == null && this.groupBy != GroupBy.GROUP;
        if ((mustGroup || this.groupBy == GroupBy.HOUR) && this.date != null && (saved = this.getSummaryFile()).exists()) {
            this.tickets = DailySummary.parseSummary(saved, this.groupId, this.group, this.from, this.to);
            return;
        }
        this.tickets = DailySummary.build(this.directory, this.date, this.groupId, this.group, this.hour, this.from, this.to, this.accessLogs, this.permissions, this.methods, this.groupBy);
        if (this.groupBy == GroupBy.HOUR || mustGroup) {
            HashMap<Long, List<TicketSummary>> grouped = new HashMap<Long, List<TicketSummary>>();
            for (Map.Entry<Long, List<TicketSummary>> entry : this.tickets.entrySet()) {
                List<TicketSummary> groupTickets = entry.getValue();
                if (groupTickets.size() > 20 || mustGroup) {
                    HashMap<Integer, List> hourTickets = new HashMap<Integer, List>();
                    for (TicketSummary summary : groupTickets) {
                        int startHour = DailySummary.hourFromTimestamp(summary.started);
                        hourTickets.computeIfAbsent(startHour, k -> new ArrayList()).add(summary);
                        if (!this.accessLogs) continue;
                        int endHour = DailySummary.hourFromTimestamp(summary.ended);
                        for (int i = startHour + 1; i <= endHour; ++i) {
                            hourTickets.computeIfAbsent(i, k -> new ArrayList()).add(summary);
                        }
                    }
                    ArrayList<TicketSummary> newGroupTickets = new ArrayList<TicketSummary>();
                    Iterator iterator = hourTickets.keySet().iterator();
                    while (iterator.hasNext()) {
                        int hour = (Integer)iterator.next();
                        List sorted = (List)hourTickets.get(hour);
                        sorted.sort(TICKETS_AGE);
                        TicketSummary first = (TicketSummary)sorted.get(0);
                        if (sorted.size() == 1) {
                            if (this.accessLogs) {
                                String title = hour + ":00 - " + (hour + 1) + ":00 : 1 ticket";
                                TicketSummary hourTicket = new TicketSummary(first.id, first.started, title, first.groupId, first.groupName, first.username, 1);
                                hourTicket.infos = first.infos;
                                hourTicket.errors = first.errors;
                                hourTicket.warnings = first.warnings;
                                hourTicket.endedToday = first.endedToday;
                                hourTicket.ended = first.ended;
                                newGroupTickets.add(hourTicket);
                                continue;
                            }
                            newGroupTickets.add(first);
                            continue;
                        }
                        String id = first.id + "." + ((TicketSummary)sorted.get((int)(sorted.size() - 1))).id;
                        String title = hour + ":00 - " + (hour + 1) + ":00 : " + sorted.size() + " tickets";
                        TicketSummary hourTicket = new TicketSummary(id, first.started, title, first.groupId, first.groupName, null, sorted.size());
                        hourTicket.startedToday = first.startedToday;
                        for (TicketSummary t : sorted) {
                            hourTicket.infos += t.infos;
                            hourTicket.errors += t.errors;
                            hourTicket.warnings += t.warnings;
                            hourTicket.endedToday = t.endedToday;
                            hourTicket.ended = t.ended;
                        }
                        newGroupTickets.add(hourTicket);
                    }
                    newGroupTickets.sort(TICKETS_AGE);
                    grouped.put(entry.getKey(), newGroupTickets);
                    continue;
                }
                grouped.put(entry.getKey(), groupTickets);
            }
            this.tickets = grouped;
        }
    }

    public File getSummaryFile() {
        String iso = ISO8601.CALENDAR_DATE.format(this.date.getTime());
        return DailySummary.getSummaryFile(this.directory, iso);
    }

    public void save() throws IOException {
        this.save(false);
    }

    public void save(boolean overwrite) throws IOException {
        File summary = this.getSummaryFile();
        if (!summary.exists() || overwrite) {
            try (FileOutputStream os = new FileOutputStream(summary);){
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
                XMLWriterImpl xml = new XMLWriterImpl((Writer)writer, true);
                this.toXML((XMLWriter)xml);
                xml.flush();
            }
        }
    }

    public static File getSummaryFile(File directory, String date) {
        return new File(directory, "summary-" + date + ".xml");
    }

    private static int hourFromTimestamp(long timestamp) {
        return LocalDateTime.ofInstant(new Date(timestamp).toInstant(), ZoneId.systemDefault()).getHour();
    }

    private static Map<Long, List<TicketSummary>> parseSummary(File summaryFile, @Nullable Long id, String group, String from, String to) throws XLogException {
        SummaryParser collector = id != null ? new SummaryParser(id, from, to) : new SummaryParser(group, from, to);
        try {
            SAXParserFactory factory = XMLHelpers.safeSAXParserFactory();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            XLogs.parse(summaryFile, factory.newSAXParser(), collector);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            LOGGER.error("Unable to generate log summary for {}", (Object)summaryFile.getName(), (Object)ex);
            throw new XLogException(ex);
        }
        return collector.getData();
    }

    private static Map<Long, List<TicketSummary>> build(File directory, Date date, @Nullable Long id, String group, int hour, String from, String to, boolean accessLogs, List<String> permissions, List<String> methods, GroupBy groupBy) throws XLogException {
        DailyLogFileFilter filter = new DailyLogFileFilter(date, ".xlog");
        File[] xlogs = directory.listFiles(filter);
        if (xlogs == null) {
            throw new IllegalStateException("Unable to list file in log directory!");
        }
        Arrays.sort(xlogs, FILE_AGE);
        SummaryCollector collector = id != null ? new SummaryCollector(id, from, to, hour, accessLogs, permissions, methods, groupBy) : new SummaryCollector(group, from, to, hour, accessLogs, permissions, methods, groupBy);
        try {
            SAXParserFactory factory = XMLHelpers.safeSAXParserFactory();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            for (File xlog : xlogs) {
                try {
                    XLogs.parse(xlog, parser, collector);
                }
                catch (IOException | SAXException ex) {
                    LOGGER.error("Error generating log summary for {}", (Object)xlog.getName(), (Object)ex);
                    return DailySummary.logError(xlog, collector);
                }
            }
        }
        catch (ParserConfigurationException | SAXException ex) {
            LOGGER.error("Unable to generate log summary", (Throwable)ex);
            throw new XLogException(ex);
        }
        return collector.getData();
    }

    private static Map<Long, List<TicketSummary>> logError(File xlog, SummaryCollector collector) {
        Map<Long, List<TicketSummary>> errorData = collector.getData();
        TicketSummary summary = new TicketSummary("0", xlog.lastModified(), "Error reading logs", null, null, null, 1);
        ++summary.errors;
        List list = errorData.computeIfAbsent(-1L, k -> new ArrayList());
        list.add(summary);
        return errorData;
    }

    private static class SummaryParser
    extends DefaultHandler {
        private final boolean isGroupID;
        private boolean inRange;
        private @Nullable Long currentGroupID = null;
        private @Nullable String currentGroupName = null;
        private final @Nullable String group;
        private final @Nullable String from;
        private final @Nullable String to;
        private final Map<Long, List<TicketSummary>> data = new HashMap<Long, List<TicketSummary>>();

        public SummaryParser(@Nullable String group, @Nullable String from, @Nullable String to) {
            this.group = group;
            this.isGroupID = false;
            this.from = from;
            this.to = to;
            this.inRange = this.from == null && this.to == null;
        }

        public SummaryParser(@Nullable Long group, @Nullable String from, @Nullable String to) {
            this.group = group != null ? group.toString() : null;
            this.isGroupID = true;
            this.from = from;
            this.to = to;
            this.inRange = this.from == null && this.to == null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.inRange && !this.data.isEmpty()) {
                return;
            }
            if ("group".equals(localName) || "group".equals(qName)) {
                this.currentGroupName = attributes.getValue("name");
                String id = attributes.getValue("id");
                this.currentGroupID = id != null && id.matches("^-?\\d+$") ? Long.parseLong(id) : -1L;
            } else if ("access".equals(localName) || "access".equals(qName)) {
                this.currentGroupID = 0L;
            } else if ("ticket".equals(localName) || "ticket".equals(qName)) {
                if (this.group != null) {
                    if (this.isGroupID && this.currentGroupID != null && !this.group.equals(this.currentGroupID.toString())) {
                        return;
                    }
                    if (!this.isGroupID && !this.group.equals(this.currentGroupName)) {
                        return;
                    }
                } else if (this.currentGroupID == null) {
                    return;
                }
                String id = attributes.getValue("id");
                String title = attributes.getValue("title");
                String username = attributes.getValue("author");
                String infos = attributes.getValue("infos");
                String warnings = attributes.getValue("warnings");
                String errors = attributes.getValue("errors");
                String started = attributes.getValue("started");
                String ended = attributes.getValue("ended");
                String gid = attributes.getValue("gid");
                String gname = attributes.getValue("gname");
                String size = attributes.getValue("size");
                if (id == null || started == null) {
                    return;
                }
                long startedTime = 0L;
                try {
                    startedTime = ISO8601.parseAuto((String)started).getTime();
                }
                catch (ParseException ex) {
                    LOGGER.warn("Invalid started date {} for ticket {}", new Object[]{started, id, ex});
                }
                if (!this.inRange && id.equals(this.from)) {
                    this.inRange = true;
                }
                if (this.inRange) {
                    List list = this.data.computeIfAbsent(this.currentGroupID, k -> new ArrayList());
                    TicketSummary summary = new TicketSummary(id, startedTime, title, gid == null ? this.currentGroupID : (long)Integer.parseInt(gid, 10), gname == null ? this.currentGroupName : gname, username, size == null ? -1 : Integer.parseInt(size));
                    if (infos != null) {
                        summary.infos = Integer.parseInt(infos);
                    }
                    if (warnings != null) {
                        summary.warnings = Integer.parseInt(warnings);
                    }
                    if (errors != null) {
                        summary.errors = Integer.parseInt(errors);
                    }
                    if (ended != null) {
                        try {
                            summary.ended = ISO8601.parseAuto((String)ended).getTime();
                        }
                        catch (ParseException ex) {
                            LOGGER.warn("Invalid ended date {} for ticket {}", new Object[]{ended, id, ex});
                        }
                    }
                    summary.startedToday = !"false".equals(attributes.getValue("start"));
                    summary.endedToday = !"false".equals(attributes.getValue("complete"));
                    list.add(summary);
                    Collections.sort(list);
                    if (id.equals(this.to)) {
                        this.inRange = false;
                    }
                }
            }
        }

        public Map<Long, List<TicketSummary>> getData() {
            return this.data;
        }
    }

    private static class SummaryCollector
    extends DefaultHandler {
        private final boolean isGroupID;
        private boolean inFail = false;
        private boolean lastInRange = false;
        private boolean inRange;
        private final @Nullable String group;
        private final @Nullable String from;
        private final @Nullable String to;
        private final List<String> methods;
        private final List<String> permissions;
        private final int hour;
        private final boolean accessLogs;
        private final GroupBy groupBy;
        private final Map<Long, List<TicketSummary>> data = new HashMap<Long, List<TicketSummary>>();
        private final Map<String, TicketSummary> tickets = new HashMap<String, TicketSummary>();
        private final Collection<String> openTickets = new ArrayList<String>();
        private @Nullable Map<String, String> eventAttributes = null;

        public SummaryCollector(@Nullable String group, @Nullable String from, @Nullable String to, int hour, boolean accessLogs, List<String> permissions, List<String> methods, GroupBy by) {
            this.group = group;
            this.isGroupID = false;
            this.from = from;
            this.to = to;
            this.hour = hour;
            this.accessLogs = accessLogs;
            this.permissions = permissions;
            this.methods = methods;
            this.groupBy = by;
            this.inRange = this.from == null && this.to == null;
        }

        public SummaryCollector(@Nullable Long group, @Nullable String from, @Nullable String to, int hour, boolean accessLogs, List<String> permissions, List<String> methods, GroupBy by) {
            this.group = group != null ? group.toString() : null;
            this.isGroupID = true;
            this.from = from;
            this.to = to;
            this.hour = hour;
            this.accessLogs = accessLogs;
            this.permissions = permissions;
            this.methods = methods;
            this.groupBy = by;
            this.inRange = this.from == null && this.to == null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!this.inRange && this.openTickets.isEmpty() && !this.tickets.isEmpty()) {
                return;
            }
            if ("event".equals(localName) || "event".equals(qName)) {
                this.eventAttributes = new HashMap<String, String>();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.eventAttributes.put(attributes.getQName(i), attributes.getValue(i));
                }
            } else if ("job".equals(localName) || "job".equals(qName)) {
                if ("FAIL".equals(attributes.getValue("type"))) {
                    this.inFail = true;
                }
            } else if ("access".equals(localName) || "access".equals(qName)) {
                String permission = attributes.getValue("permission");
                String method = attributes.getValue("method");
                if (!this.permissions.isEmpty() && permission != null && !this.permissions.contains(permission.toLowerCase()) || !this.methods.isEmpty() && method != null && !this.methods.contains(method.toLowerCase())) {
                    this.eventAttributes = null;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.inRange && this.openTickets.isEmpty() && !this.tickets.isEmpty()) {
                return;
            }
            if (("event".equals(localName) || "event".equals(qName)) && this.eventAttributes != null) {
                String level = this.eventAttributes.get("level");
                String groupName = this.eventAttributes.get("group");
                String groupId = this.eventAttributes.get("groupid");
                Object ticket = this.eventAttributes.get("ticket");
                String timestamp = this.eventAttributes.get("timestamp");
                String username = this.eventAttributes.get("username");
                String type = this.eventAttributes.get("type");
                if (ticket == null || timestamp == null) {
                    return;
                }
                long datetime = Long.parseLong(timestamp);
                int hour = -1;
                if (this.groupBy == GroupBy.GROUP) {
                    ticket = (String)ticket + "-" + (groupId != null ? groupId : "0");
                } else if (this.accessLogs) {
                    hour = DailySummary.hourFromTimestamp(datetime);
                    ticket = (String)ticket + "-" + hour;
                }
                String group = this.isGroupID ? groupId : groupName;
                Long groupID = groupId == null || !groupId.matches("^\\d+$") ? -1L : Long.parseLong(groupId);
                if (group == null) {
                    group = "0";
                }
                if (!this.inRange && ((String)ticket).equals(this.from)) {
                    this.inRange = true;
                }
                if (this.hour > -1) {
                    boolean bl = this.inRange = hour == this.hour;
                }
                if ((this.inRange || this.openTickets.contains(ticket)) && (this.accessLogs && this.groupBy != GroupBy.GROUP || this.group == null || group.equals(this.group))) {
                    TicketSummary summary = this.tickets.get(ticket);
                    if (summary == null) {
                        Object title = this.eventAttributes.get("title");
                        if (title == null) {
                            title = "[Untitled #" + (String)ticket + "]";
                        }
                        summary = new TicketSummary((String)ticket, datetime, (String)title, groupID, groupName, username, 0);
                        this.tickets.put((String)ticket, summary);
                        List list = this.data.computeIfAbsent(this.accessLogs && this.groupBy != GroupBy.GROUP ? 0L : groupID, k -> new ArrayList());
                        list.add(summary);
                        Collections.sort(list);
                        this.openTickets.add((String)ticket);
                    }
                    if (Strings.isEmpty((String)summary.username) && !Strings.isEmpty((String)username)) {
                        summary.username = username;
                    }
                    ++summary.size;
                    if ("INFO".equals(level)) {
                        ++summary.infos;
                    } else if ("WARN".equals(level)) {
                        ++summary.warnings;
                    } else if ("ERROR".equals(level) && !this.inFail) {
                        ++summary.errors;
                        this.inFail = true;
                    }
                    summary.ended = datetime;
                    if ("start".equals(type)) {
                        summary.startedToday = true;
                    }
                    if ("complete".equals(type) || this.accessLogs) {
                        this.openTickets.remove(ticket);
                        summary.endedToday = true;
                        if (((String)ticket).equals(this.to) && (!this.accessLogs || this.hour == -1)) {
                            this.lastInRange = true;
                        }
                    }
                }
                this.eventAttributes = null;
                this.inFail = false;
                if (this.lastInRange) {
                    this.inRange = false;
                }
            }
        }

        public Map<Long, List<TicketSummary>> getData() {
            return this.data;
        }

        public Map<String, TicketSummary> getTickets() {
            return this.tickets;
        }
    }

    private static class TicketSummary
    implements XMLWritable,
    Comparable<TicketSummary> {
        private final String id;
        private final long started;
        private final @Nullable Long groupId;
        private final @Nullable String groupName;
        private final String title;
        private @Nullable String username;
        private long ended;
        private int errors = 0;
        private int warnings = 0;
        private int infos = 0;
        private int size;
        private boolean startedToday = false;
        private boolean endedToday = false;

        public TicketSummary(String id, long started, String title, @Nullable Long groupId, @Nullable String groupName, @Nullable String username, int size) {
            this.id = id;
            this.title = title;
            this.started = started;
            this.ended = started;
            this.groupId = groupId;
            this.groupName = groupName;
            this.username = username;
            this.size = size;
        }

        public void toXML(XMLWriter xml) throws IOException {
            xml.openElement("ticket");
            xml.attribute("id", this.id);
            xml.attribute("title", this.title);
            xml.attribute("infos", Integer.toString(this.infos));
            xml.attribute("warnings", Integer.toString(this.warnings));
            xml.attribute("errors", Integer.toString(this.errors));
            xml.attribute("started", ISO8601.format((long)this.started, (ISO8601)ISO8601.DATETIME));
            xml.attribute("ended", ISO8601.format((long)this.ended, (ISO8601)ISO8601.DATETIME));
            xml.attribute("duration", Long.toString(this.ended - this.started));
            xml.attribute("size", this.size);
            xml.attribute("hour", DailySummary.hourFromTimestamp(this.started));
            if (this.username != null) {
                xml.attribute("author", this.username);
            }
            if (this.groupId != null) {
                xml.attribute("gid", this.groupId.toString());
            }
            if (this.groupName != null) {
                xml.attribute("gname", this.groupName);
            }
            if (!this.startedToday) {
                xml.attribute("start", "false");
            }
            if (!this.endedToday) {
                xml.attribute("complete", "false");
            }
            xml.closeElement();
        }

        @Override
        public int compareTo(TicketSummary o) {
            long c = this.started - o.started;
            return c > 0L ? 1 : (c < 0L ? -1 : 0);
        }

        public @Nullable Long getGroupId() {
            return this.groupId;
        }

        public @Nullable String getGroupName() {
            return this.groupName;
        }
    }

    public static enum GroupBy {
        NONE,
        HOUR,
        GROUP;

    }
}

