/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.jwt;

import com.pageseeder.base.jwt.JSONWebKey;
import com.pageseeder.base.jwt.JWKS;
import com.pageseeder.base.jwt.JWTException;
import com.pageseeder.base.jwt.OpenIdConfiguration;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import java.security.Key;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class SigningKeyResolver
extends SigningKeyResolverAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SigningKeyResolver.class);
    private static final Map<String, JWKS> CACHE = new Hashtable<String, JWKS>();

    SigningKeyResolver() {
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        String keyId = header.getKeyId();
        String authorityUrl = SigningKeyResolver.toAuthorityUrl(claims);
        try {
            JSONWebKey jwk;
            JWKS jwks = CACHE.get(authorityUrl);
            if (jwks == null || jwks.hasExpired()) {
                OpenIdConfiguration config;
                if (authorityUrl.startsWith("https://login.microsoftonline.com")) {
                    String appid = (String)claims.get("aid", String.class);
                    config = OpenIdConfiguration.loadMicrosoft(authorityUrl, appid);
                } else {
                    config = OpenIdConfiguration.load(authorityUrl);
                }
                String uri = config.getJwksUri();
                jwks = JWKS.load(uri);
                CACHE.put(authorityUrl, jwks);
            }
            if ((jwk = jwks.getKey(keyId)) == null) {
                throw new JWTException("Unable to find " + keyId);
            }
            return jwk.toPublicKey();
        }
        catch (JWTException ex) {
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static String toAuthorityUrl(Claims claims) {
        String issuer = claims.getIssuer();
        return issuer.startsWith("https://") ? issuer : "https://" + issuer;
    }
}

