/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.jwt;

import com.pageseeder.base.jwt.JSONWebKey;
import com.pageseeder.base.jwt.JWTException;
import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public final class JWKS {
    private final Map<String, JSONWebKey> _keys = new HashMap<String, JSONWebKey>();
    final long _expires;

    JWKS(List<JSONWebKey> keys, long expires) {
        this._expires = expires;
        for (JSONWebKey key : keys) {
            this._keys.put(key.getKeyId(), key);
        }
    }

    public JSONWebKey getKey(String keyId) {
        return this._keys.get(keyId);
    }

    public Set<String> keyIds() {
        return this._keys.keySet();
    }

    public Collection<JSONWebKey> keys() {
        return this._keys.values();
    }

    public boolean hasExpired() {
        return this._expires < System.currentTimeMillis();
    }

    public static JWKS load(String url) throws JWTException {
        try {
            URI uri = new URI(url).normalize();
            LoggerFactory.getLogger(JWKS.class).info("Loading JWKS from {}", (Object)url);
            HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
            if (connection.getResponseCode() == 200) {
                long expires = JWKS.getExpires(connection);
                List<JSONWebKey> keys = JWKS.parse(connection.getInputStream());
                return new JWKS(keys, expires);
            }
            throw new JWTException("Unable to parse JWKS from " + url + " HTTP " + connection.getResponseCode());
        }
        catch (ParseException ex) {
            throw new JWTException("Unable to parse JWKS from " + url, ex);
        }
        catch (IOException | URISyntaxException ex) {
            throw new JWTException("Unable to load JWKS from " + url, ex);
        }
    }

    static List<JSONWebKey> parse(InputStream in) throws ParseException {
        ArrayList<JSONWebKey> keys = null;
        String name = null;
        ArrayList<String> array = null;
        JSONWebKey key = null;
        try (JsonParser parser = Json.createParser((InputStream)in);){
            block13: while (parser.hasNext()) {
                JsonParser.Event event = parser.next();
                switch (event) {
                    case KEY_NAME: {
                        name = parser.getString();
                        continue block13;
                    }
                    case VALUE_STRING: {
                        if (key == null) continue block13;
                        JWKS.updateKey(key, name, parser.getString());
                        if (array == null) continue block13;
                        array.add(parser.getString());
                        continue block13;
                    }
                    case START_ARRAY: {
                        if ("keys".equals(name)) {
                            keys = new ArrayList<JSONWebKey>();
                            continue block13;
                        }
                        array = new ArrayList<String>();
                        continue block13;
                    }
                    case START_OBJECT: {
                        if (key != null) continue block13;
                        key = new JSONWebKey();
                        continue block13;
                    }
                    case END_OBJECT: {
                        if (key == null) continue block13;
                        keys.add(key);
                        key = null;
                        continue block13;
                    }
                    case END_ARRAY: {
                        if (key != null && "x5c".equals(name)) {
                            key.setX509CertificateChain(array);
                        }
                        array = null;
                        continue block13;
                    }
                }
            }
        }
        return keys;
    }

    private static void updateKey(JSONWebKey key, String name, String value) {
        if ("kty".equals(name)) {
            key.setKeyType(value);
        } else if ("use".equals(name)) {
            key.setUse(value);
        } else if ("kid".equals(name)) {
            key.setKeyId(value);
        } else if ("x5u".equals(name)) {
            key.setX509Uri(value);
        } else if ("x5t".equals(name)) {
            key.setX509Thumbnail(value);
        } else if ("n".equals(name)) {
            key.setN(value);
        } else if ("e".equals(name)) {
            key.setE(value);
        } else if ("x".equals(name)) {
            key.setX(value);
        } else if ("y".equals(name)) {
            key.setY(value);
        } else if ("crv".equals(name)) {
            key.setCurve(value);
        }
    }

    private static long getExpires(HttpURLConnection connection) {
        Matcher m;
        String cacheControl = connection.getHeaderField("Cache-Control");
        if (cacheControl != null && (m = Pattern.compile("max-age=(\\d+)").matcher(cacheControl)).find()) {
            long maxAgeSeconds = Long.parseLong(m.group(1));
            return System.currentTimeMillis() + maxAgeSeconds * 1000L;
        }
        return connection.getHeaderFieldDate("Expires", 0L);
    }
}

