/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.jwt;

import com.pageseeder.base.jwt.JWTException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.List;

public final class JSONWebKey
implements Serializable {
    private static final String ALGORITHM_RSA = "RSA";
    private static final String ALGORITHM_ELLIPTIC_CURVE = "EC";
    private String algorithm;
    private String keyType;
    private String use;
    private String n;
    private String e;
    private String keyId;
    private List<String> x509CertificateChain;
    private String x509Thumbnail;
    private String x509Uri;
    private String curve;
    private String x;
    private String y;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public List<String> getX509CertificateChain() {
        return this.x509CertificateChain;
    }

    public void setX509CertificateChain(List<String> x509CertificateChain) {
        this.x509CertificateChain = x509CertificateChain;
    }

    public String getN() {
        return this.n;
    }

    public void setN(String n) {
        this.n = n;
    }

    public String getE() {
        return this.e;
    }

    public void setE(String e) {
        this.e = e;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getX509Thumbnail() {
        return this.x509Thumbnail;
    }

    public void setX509Thumbnail(String x509Thumbnail) {
        this.x509Thumbnail = x509Thumbnail;
    }

    public String getX509Uri() {
        return this.x509Uri;
    }

    public void setX509Uri(String x509Uri) {
        this.x509Uri = x509Uri;
    }

    public String getCurve() {
        return this.curve;
    }

    public void setCurve(String curve) {
        this.curve = curve;
    }

    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public PublicKey toPublicKey() throws JWTException {
        switch (this.getKeyType()) {
            case "RSA": {
                return JSONWebKey.getRSAPublicKey(this);
            }
            case "EC": {
                return JSONWebKey.getEllipticCurvePublicKey(this);
            }
        }
        throw new JWTException("The key type of " + this.getAlgorithm() + " is not supported");
    }

    private static PublicKey getRSAPublicKey(JSONWebKey jwk) throws JWTException {
        try {
            KeyFactory kf = KeyFactory.getInstance(ALGORITHM_RSA);
            BigInteger modulus = new BigInteger(1, Base64.getUrlDecoder().decode(jwk.getN()));
            BigInteger exponent = new BigInteger(1, Base64.getUrlDecoder().decode(jwk.getE()));
            return kf.generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (InvalidKeySpecException ex) {
            throw new JWTException("Invalid public key", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new JWTException("Invalid algorithm to generate key", ex);
        }
    }

    private static PublicKey getEllipticCurvePublicKey(JSONWebKey jwk) throws JWTException {
        try {
            String curve;
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_ELLIPTIC_CURVE);
            ECPoint ecPoint = new ECPoint(new BigInteger(Base64.getUrlDecoder().decode(jwk.getX())), new BigInteger(Base64.getUrlDecoder().decode(jwk.getY())));
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(ALGORITHM_ELLIPTIC_CURVE);
            switch (curve = jwk.getCurve()) {
                case "P-256": {
                    algorithmParameters.init(new ECGenParameterSpec("secp256r1"));
                    break;
                }
                case "P-384": {
                    algorithmParameters.init(new ECGenParameterSpec("secp384r1"));
                    break;
                }
                case "P-521": {
                    algorithmParameters.init(new ECGenParameterSpec("secp521r1"));
                    break;
                }
                default: {
                    throw new JWTException("Invalid or unsupported curve type " + curve);
                }
            }
            ECParameterSpec ecParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
            return keyFactory.generatePublic(ecPublicKeySpec);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new JWTException("Invalid algorithm to generate key", ex);
        }
        catch (InvalidKeySpecException | InvalidParameterSpecException ex) {
            throw new JWTException("Invalid public key", ex);
        }
    }

    public String toString() {
        return "JSONWebKey{alg='" + this.algorithm + "', kid='" + this.keyId + "', kty='" + this.keyType + "', use='" + this.use + "', n='" + this.n + "', e='" + this.e + "', x='" + this.x + "', y='" + this.y + "', crv='" + this.curve + "', x5c='" + this.x509CertificateChain + "', x5t='" + this.x509Thumbnail + "', x5u='" + this.x509Uri + "'}";
    }
}

