/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.inspect;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.inspect.FileInspection;
import com.pageseeder.base.inspect.FileInspector;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.util.XMLHelpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PSMLFileInspector
extends DefaultHandler
implements FileInspector {
    private final Map<String, String> psmlAttributes = new HashMap<String, String>();
    private final List<PSMLProperty> metadataProperties = new ArrayList<PSMLProperty>();
    private boolean inDocumentinfo = false;
    private boolean inURI = false;
    private boolean inMetadata = false;
    private PSMLProperty currentProperty = null;
    private StringBuilder text = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> inspect(File file) throws IOException {
        PSMLFileInspector inspector = new PSMLFileInspector();
        try (FileInputStream in = FileUtils.openInputStream((File)file);){
            XMLHelpers.parse(in, inspector);
        }
        return inspector.psmlAttributes;
    }

    public static Map<String, String> inspect(InputStream in) throws IOException {
        PSMLFileInspector inspector = new PSMLFileInspector();
        try {
            XMLHelpers.parse(in, inspector);
        }
        catch (FoundationException ex) {
            FileInspection.LOGGER.error("Failed to load metadata from PSML stream", (Throwable)ex);
        }
        finally {
            in.close();
        }
        return inspector.psmlAttributes;
    }

    public List<PSMLProperty> getMetadataProperties() {
        return this.metadataProperties;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.text != null) {
            this.text.append(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("document".equals(localName)) {
            this.setAttribute("level", attributes.getValue("level"));
            String doctype = attributes.getValue("type");
            if (doctype == null || "default".equalsIgnoreCase(doctype)) {
                doctype = "";
            } else {
                this.setAttribute("document-type", doctype);
            }
            this.setAttribute("behavior", "psml-" + doctype + "-");
        } else if ("documentinfo".equals(localName)) {
            this.inDocumentinfo = true;
        } else if ("metadata".equals(localName)) {
            this.setAttribute("has-metadata", "true");
            this.inMetadata = true;
        } else if (this.inMetadata && "property".equals(localName)) {
            String name = attributes.getValue("name");
            if (name != null) {
                this.currentProperty = new PSMLProperty();
                this.currentProperty.name = name;
                this.currentProperty.title = attributes.getValue("title");
                String value = attributes.getValue("value");
                if (value != null) {
                    this.currentProperty.values.add(value);
                }
            }
        } else if (this.currentProperty != null) {
            if ("value".equals(localName)) {
                this.text = new StringBuilder();
            } else if ("xref".equals(localName)) {
                this.currentProperty.type = PROPERTY_TYPE.XREF;
                this.currentProperty.values.add(attributes.getValue("uriid"));
            } else if ("link".equals(localName)) {
                this.currentProperty.type = PROPERTY_TYPE.LINK;
                this.currentProperty.values.add(attributes.getValue("uriid"));
            }
        } else if (this.inDocumentinfo && "publication".equals(localName)) {
            this.setAttribute("publication-id", attributes.getValue("id"));
            this.setAttribute("publication-type", attributes.getValue("type"));
        } else if (this.inDocumentinfo && "uri".equals(localName)) {
            this.setAttribute("title", attributes.getValue("title"));
            this.setAttribute("type", attributes.getValue("mediatype"));
            this.setAttribute("docid", attributes.getValue("docid"));
            String doctype = attributes.getValue("documenttype");
            if (!this.psmlAttributes.containsKey("document-type") && doctype != null) {
                this.setAttribute("document-type", doctype);
            }
            if (!this.psmlAttributes.containsKey("behavior") || "psml--".equals(this.psmlAttributes.get("behavior"))) {
                this.setAttribute("behavior", "psml-" + (doctype == null || "default".equalsIgnoreCase(doctype) ? "" : doctype) + "-");
            }
            String path = attributes.getValue("decodedpath");
            this.inURI = true;
            if (path != null) {
                if ("true".equals(attributes.getValue("external"))) {
                    String scheme = attributes.getValue("scheme");
                    String host = attributes.getValue("host");
                    String port = attributes.getValue("port");
                    if (port == null) {
                        if ("http".equals(scheme)) {
                            port = "80";
                        }
                        if ("https".equals(scheme)) {
                            port = "443";
                        }
                    }
                    if (scheme == null || host == null || port == null) {
                        return;
                    }
                    try {
                        Integer.parseInt(port, 10);
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                    this.setAttribute("url", scheme + "://" + host + ":" + port + path);
                    this.setAttribute("folder", attributes.getValue("folder"));
                    this.setAttribute("size", attributes.getValue("size"));
                    String urltype = attributes.getValue("urltype");
                    this.setAttribute("behavior", "url-" + (urltype == null ? "default" : urltype) + "-");
                } else {
                    String[] filename = URIRule.getFilename(path);
                    this.setAttribute("filename", filename[0]);
                    if (!filename[1].isEmpty()) {
                        this.setAttribute("extension", filename[1]);
                    }
                }
            }
        } else if (this.inURI) {
            this.text = new StringBuilder();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("documentinfo".equals(localName)) {
            this.inDocumentinfo = true;
        } else if ("metadata".equals(localName)) {
            this.inMetadata = false;
        } else if (this.inDocumentinfo && "uri".equals(localName)) {
            this.inURI = false;
        } else if (this.inURI && "labels".equals(localName)) {
            String labels = this.text.toString().trim().replaceAll("^,|,$", "");
            this.setAttribute("labels", labels);
            this.text = null;
        } else if (this.inURI && "description".equals(localName)) {
            this.setAttribute("description", this.text.toString());
            this.text = null;
        } else if (this.currentProperty != null && "property".equals(localName)) {
            this.metadataProperties.add(this.currentProperty);
            this.currentProperty = null;
        } else if (this.currentProperty != null) {
            if ("value".equals(localName) && this.text.length() > 0) {
                this.currentProperty.values.add(this.text.toString());
            }
            this.text = null;
        }
    }

    private void setAttribute(String key, String value) {
        if (value != null && !value.isEmpty()) {
            this.psmlAttributes.put(key, value);
        }
    }

    public static class PSMLProperty
    implements UniversallyPrintable {
        private String name;
        private String title;
        private List<String> values = new ArrayList<String>();
        private PROPERTY_TYPE type = PROPERTY_TYPE.TEXT;

        @Override
        public void print(OutputPrinter out) {
            String element;
            out.startObject("property");
            out.field("name", this.name);
            out.field("title", this.title);
            String string = this.type == PROPERTY_TYPE.LINK ? "link" : (element = this.type == PROPERTY_TYPE.XREF ? "xref" : "value");
            if (this.values.size() == 1) {
                out.field(element, this.values.get(0));
            } else {
                out.field(element + "s", this.values.toArray(new String[0]), OutputPrinter.FieldOption.JSON_ONLY);
                if (out.getType() == OutputType.XML) {
                    for (String value : this.values) {
                        out.field(element, value, OutputPrinter.FieldOption.XML_ELEMENT);
                    }
                }
            }
            out.endObject();
        }
    }

    private static enum PROPERTY_TYPE {
        XREF,
        LINK,
        TEXT;

    }
}

