/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.inspect;

import com.pageseeder.base.inspect.FileInspector;
import com.pageseeder.base.inspect.ImageInspector;
import com.pageseeder.base.inspect.OfficeDocumentInspector;
import com.pageseeder.base.inspect.PDFInspector;
import com.pageseeder.base.inspect.PSMLFileInspector;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileInspection {
    static final Logger LOGGER = LoggerFactory.getLogger(FileInspection.class);
    private static Map<String, FileInspector> inspectors = new HashMap<String, FileInspector>();

    private FileInspection() {
    }

    public static Map<String, String> inspectPSML(File file, File metadata) {
        if (!file.exists()) {
            return new HashMap<String, String>();
        }
        if (file.getName().toLowerCase().endsWith(".psml")) {
            try {
                return new HashMap<String, String>(inspectors.get("psml").inspect(file));
            }
            catch (IOException ex) {
                LOGGER.error("Failed to inspect file {}: {}", new Object[]{file.getName(), ex.getLocalizedMessage(), ex});
            }
        }
        if (metadata != null && metadata.isFile() && metadata.exists() && metadata.getName().endsWith(".psml")) {
            try {
                HashMap<String, String> attributes = new HashMap<String, String>(inspectors.get("psml").inspect(metadata));
                attributes.remove("behavior");
                attributes.remove("extension");
                attributes.remove("filename");
                return attributes;
            }
            catch (IOException ex) {
                LOGGER.error("Failed to inspect file {}: {}", new Object[]{metadata.getName(), ex.getLocalizedMessage(), ex});
            }
        }
        return new HashMap<String, String>();
    }

    public static Map<String, String> inspect(File file) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String extension = file.getName().substring(file.getName().lastIndexOf(46) + 1);
        FileInspector inspector = inspectors.get(extension);
        if (inspector != null) {
            try {
                Map<String, String> inspected = inspector.inspect(file);
                if (inspected == null) {
                    LOGGER.error("Failed to inspect file {}", (Object)file.getName());
                } else {
                    attributes.putAll(inspected);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to inspect file {}: {}", new Object[]{file.getName(), ex.getLocalizedMessage(), ex});
            }
        }
        return attributes;
    }

    static {
        inspectors.put("psml", new PSMLFileInspector());
        inspectors.put("docx", new OfficeDocumentInspector());
        inspectors.put("xlsx", new OfficeDocumentInspector());
        inspectors.put("pptx", new OfficeDocumentInspector());
        inspectors.put("jpg", new ImageInspector());
        inspectors.put("jpeg", new ImageInspector());
        inspectors.put("webp", new ImageInspector());
        inspectors.put("gif", new ImageInspector());
        inspectors.put("png", new ImageInspector());
        inspectors.put("pdf", new PDFInspector());
    }
}

