/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.generator;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.db.DatabaseException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class StatisticsCollector
implements XMLWritable,
UniversallyPrintable {
    private static final StatisticsCollector SINGLETON = new StatisticsCollector();
    private final ConcurrentHashMap<Class<?>, BasicStats> stats = new ConcurrentHashMap();

    private StatisticsCollector() {
    }

    public void record(Generator generator, GeneratorStatus status, long process) {
        BasicStats basic = this.stats.get(generator.getClass());
        if (basic == null) {
            basic = new BasicStats(generator.getClass().getName(), status, process);
            this.stats.put(generator.getClass(), basic);
        } else {
            basic.update(status, process);
        }
    }

    public void clear() {
        this.stats.clear();
    }

    @Deprecated
    public void toXML(XMLWriter xml) throws IOException {
        this.print(new XMLOutputPrinter(xml));
    }

    @Override
    public void print(OutputPrinter out) {
        out.startObject("statistics");
        out.startCollection("statistics", OutputPrinter.CollectionOption.JSON_ONLY);
        for (BasicStats s : this.stats.values()) {
            s.print(out);
        }
        out.endCollection();
        out.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(Generator generator, GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        GeneratorStatus status = GeneratorStatus.SERVER_ERROR;
        long start = System.nanoTime();
        try {
            generator.process(req, res);
            status = res.getStatus();
        }
        finally {
            long end = System.nanoTime();
            SINGLETON.record(generator, status, end - start);
        }
    }

    public static StatisticsCollector getInstance() {
        return SINGLETON;
    }

    public static final class BasicStats
    implements XMLWritable,
    UniversallyPrintable {
        private final String generator;
        private Map<GeneratorStatus, AtomicLong> _status;
        private final AtomicLong count;
        private final AtomicLong totalProcessTime;
        private final AtomicLong minProcessTime;
        private final AtomicLong maxProcessTime;
        private final LinkedBlockingDeque<Long> lastProcess = new LinkedBlockingDeque(10);

        private BasicStats(String name, GeneratorStatus status, long process) {
            this.generator = name;
            this._status = Collections.synchronizedMap(new EnumMap(GeneratorStatus.class));
            this._status.put(status, new AtomicLong(1L));
            this.count = new AtomicLong(1L);
            long p = process / 1000L;
            this.minProcessTime = new AtomicLong(p);
            this.maxProcessTime = new AtomicLong(p);
            this.totalProcessTime = new AtomicLong(p);
        }

        public synchronized void update(GeneratorStatus status, long process) {
            AtomicLong i = this._status.get((Object)status);
            if (i == null) {
                this._status.put(status, new AtomicLong(1L));
            } else {
                i.incrementAndGet();
            }
            this.count.incrementAndGet();
            long p = process / 1000L;
            if (p > this.maxProcessTime.get()) {
                this.maxProcessTime.set(p);
            }
            if (p < this.minProcessTime.get()) {
                this.minProcessTime.set(p);
            }
            this.totalProcessTime.addAndGet(p);
            if (this.lastProcess.remainingCapacity() == 0) {
                this.lastProcess.pollFirst();
            }
            this.lastProcess.offerLast(p);
        }

        @Deprecated
        public synchronized void toXML(XMLWriter xml) throws IOException {
            this.print(new XMLOutputPrinter(xml));
        }

        @Override
        public void print(OutputPrinter out) {
            out.startObject("statistic");
            out.field("generator", this.generator);
            out.field("count", this.count.longValue());
            out.field("min-process", this.minProcessTime.longValue());
            out.field("max-process", this.maxProcessTime.longValue());
            out.field("total-process", this.totalProcessTime.longValue());
            long avgProcess = this.totalProcessTime.longValue() / this.count.longValue();
            out.field("avg-process", avgProcess);
            long avgLastProcess = BasicStats.average(this.lastProcess);
            out.field("avg-last-process", avgLastProcess);
            out.field("recent", BasicStats.asString(this.lastProcess));
            out.startObject("status");
            for (Map.Entry<GeneratorStatus, AtomicLong> status : this._status.entrySet()) {
                out.field(status.getKey().name().toLowerCase(), Long.toString(status.getValue().get()));
            }
            out.endObject();
            out.endObject();
        }

        private static long average(Collection<Long> times) {
            if (times.isEmpty()) {
                return 0L;
            }
            long avgLastEtag = 0L;
            for (Long t : times) {
                avgLastEtag += t.longValue();
            }
            return avgLastEtag / (long)times.size();
        }

        private static String asString(Collection<Long> times) {
            StringBuilder s = new StringBuilder();
            for (Long t : times) {
                s.append(t).append(',');
            }
            if (s.length() > 0) {
                s.setLength(s.length() - 1);
            }
            return s.toString();
        }
    }
}

