/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.generator;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.Requires;
import java.util.ArrayList;
import java.util.List;

public final class RequireErrorID
implements ErrorID {
    private static final int BASE = 512;
    private static final int MAX = 767;
    private static final int PARAMETER_MISSING = 1;
    private static final int GROUP_MISSING = 2;
    private static final int MEMBER_MISSING = 4;
    private static final int URI_MISSING = 8;
    private static final int DATABASE_MISSING = 128;
    private final int _id;
    private final String _message;

    public RequireErrorID(int id, String message) {
        if (id < 512) {
            throw new IndexOutOfBoundsException("Require Error ID must be >= 0x0200");
        }
        if (id > 767) {
            throw new IndexOutOfBoundsException("Require Error ID cannot be greater than 0x02ff");
        }
        this._id = id;
        this._message = message;
    }

    @Override
    public int id() {
        return this._id;
    }

    @Override
    public String message() {
        return this._message;
    }

    public static RequireErrorID check(Generator generator, GeneratorRequest req) {
        Class<?> c = generator.getClass();
        Requires requires = c.getAnnotation(Requires.class);
        if (requires != null) {
            ArrayList<String> names = null;
            int id = 0;
            for (String name : requires.parameters()) {
                if (req.getParameter(name) != null) continue;
                if (names == null) {
                    names = new ArrayList<String>();
                }
                id = 1;
                names.add(name);
            }
            if (requires.group() && req.getGroup() == null) {
                id += 2;
            }
            if (requires.member() && req.getMember() == null) {
                id += 4;
            }
            if (requires.uri() && req.getURI() == null) {
                id += 8;
            }
            if (requires.database() && req.getDatabase() == null) {
                id += 128;
            }
            if (id > 0) {
                return new RequireErrorID(512 + id, RequireErrorID.toMessage(id, names));
            }
        }
        return null;
    }

    private static String toMessage(int id, List<String> names) {
        if ((id & 2) > 0) {
            return "Group not found";
        }
        if ((id & 4) > 0) {
            return "Member not found";
        }
        if ((id & 8) > 0) {
            return "URI not found";
        }
        if ((id & 0x80) > 0) {
            return "No database connection available";
        }
        StringBuilder message = new StringBuilder("Missing required parameter");
        if ((id & 1) > 0) {
            if (names != null && !names.isEmpty()) {
                for (String name : names) {
                    message.append(" parameter '").append(name).append("',");
                }
            } else {
                message.append(" parameter(s),");
            }
        }
        message.setLength(message.length() - 1);
        return message.toString();
    }

    public static boolean isNotFoundError(int id) {
        return (id & 2) > 0 || (id & 4) > 0 || (id & 8) > 0;
    }
}

