/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TransclusionHandler
extends DefaultHandler {
    private static final int BUFFER_SIZE = 4096;
    private final XMLWriter xml;
    private final UserDetails userDetails;
    private final Database db;
    private final String version;
    private final Publication publication;
    private boolean ignoreText = false;

    public TransclusionHandler(Database database, UserDetails ud, Writer out, String version, Publication pub) {
        this.db = database;
        this.userDetails = ud;
        this.xml = new XMLWriterNSImpl(out);
        this.version = version;
        this.publication = pub;
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) {
        this.xml.setPrefixMapping(uri, prefix);
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        boolean isMathType;
        try {
            this.xml.openElement(Strings.isEmpty((String)uri) ? null : uri, localName, true);
        }
        catch (IOException ex) {
            throw new SAXException("Failed to open element " + localName, ex);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String auri = Strings.isEmpty((String)atts.getURI(i)) ? null : atts.getURI(i);
            String aname = atts.getQName(i);
            try {
                if ("document".equals(localName) && "level".equals(aname)) {
                    this.xml.attribute("level", "processed");
                    continue;
                }
                this.xml.attribute(auri, atts.getLocalName(i), atts.getValue(i));
                continue;
            }
            catch (IOException ex) {
                throw new SAXException("Failed to add attribute \"" + atts.getLocalName(i) + "\" to element " + localName, ex);
            }
        }
        boolean bl = isMathType = "xref".equalsIgnoreCase(localName) && "math".equalsIgnoreCase(atts.getValue("type"));
        if ((uri == null || "".equals(uri)) && ("blockxref".equalsIgnoreCase(localName) && "transclude".equalsIgnoreCase(atts.getValue("type")) || isMathType)) {
            try {
                this.resolveTransclusion(atts.getValue("uriid"), atts.getValue("frag"), isMathType);
                this.ignoreText = true;
            }
            catch (TransclusionException e) {
                try {
                    this.xml.attribute("message", e.getMessage());
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to add message attribute to blockXref element", ex);
                }
                this.ignoreText = false;
            }
        }
    }

    @Override
    public final void endElement(String uri, String localName, String name) throws SAXException {
        this.ignoreText = false;
        try {
            this.xml.closeElement();
        }
        catch (IOException ex) {
            throw new SAXException("Failed to close element " + localName, ex);
        }
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.ignoreText) {
            return;
        }
        try {
            this.xml.writeText(ch, start, length);
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write text", ex);
        }
    }

    private void resolveTransclusion(String uriid, String fragment, boolean mathType) throws TransclusionException {
        Group group;
        URI uri;
        long uriID;
        if (uriid == null) {
            throw new TransclusionException("Invalid transclusion with no URI ID");
        }
        try {
            uriID = Long.parseLong(uriid);
        }
        catch (NumberFormatException ex) {
            throw new TransclusionException("Invalid transclusion with no URI ID " + uriid);
        }
        try {
            uri = DatabaseQuery.getURIById((Database)this.db, (Long)uriID);
        }
        catch (QueryFailedException e) {
            throw new TransclusionException("Invalid transclusion, no URI was found with ID " + uriid);
        }
        if (uri == null) {
            throw new TransclusionException("Invalid URI " + uriid);
        }
        if (mathType && "default".equals(fragment)) {
            if (TransclusionHandler.isNotMathType(uri.getType())) {
                throw new TransclusionException("XRefs of type 'math' must point to mediatypes: application/mathml+xml, application/x-tex or text/asciimath");
            }
        } else if (!URIRule.isPSML(uri)) {
            throw new TransclusionException("Only transclusions to PSML documents are supported here");
        }
        try {
            group = URIRule.getDefaultGroupForURI(uri);
            if (group == null || !GroupRule.userHasAccess(group, this.userDetails)) {
                group = URIRule.getGroupForURI(this.db, uri.getId(), this.userDetails);
            }
        }
        catch (DatabaseException ex) {
            throw new TransclusionException("Unable to load group for URI: " + ex.getMessage());
        }
        if (!GroupRule.userHasAccess(group, this.userDetails)) {
            throw new TransclusionException("Access denied");
        }
        try {
            int read;
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
            if (fragment != null && !"default".equals(fragment)) {
                resolver.setFragment(fragment);
                resolver.setFragmentInfo(true);
                resolver.setReverseXRefs(false);
            }
            resolver.setReleaseVersion(this.version);
            resolver.setPublication(this.publication, -1, false);
            InputStream in = resolver.getContent(this.db);
            StringBuilder psml = new StringBuilder();
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) != -1) {
                psml.append(new String(buffer, 0, read, StandardCharsets.UTF_8));
            }
            if (psml.charAt(0) == '\ufeff') {
                psml.deleteCharAt(0);
            }
            if ("<?xml ".equals(psml.substring(0, 6))) {
                psml.delete(0, psml.indexOf(">") + 1);
            }
            if ("stylesheet ".equals(psml.substring(0, 13))) {
                psml.delete(0, psml.indexOf(">") + 1);
            }
            if ("<document-fragment>".equals(psml.substring(0, 19))) {
                psml.delete(0, 19).delete(psml.length() - 21, psml.length() - 1);
            }
            boolean wrapMediaFragment = false;
            if (mathType) {
                if ("default".equals(fragment)) {
                    wrapMediaFragment = true;
                } else {
                    int startTag = psml.indexOf("<media-fragment");
                    int endTag = psml.indexOf(">", startTag + 1);
                    if (startTag != -1 && endTag != -1) {
                        Matcher matcher = Pattern.compile("\\<media-fragment(.{0,500}?)mediatype=([\"'])(.+?)([\"'])(.{0,500}?)>").matcher(psml.substring(startTag, endTag + 1));
                        if (!matcher.matches() || TransclusionHandler.isNotMathType(matcher.group(3))) {
                            throw new TransclusionException("XRefs of type 'math' must point to mediatypes: application/mathml+xml, application/x-tex or text/asciimath");
                        }
                    } else {
                        throw new TransclusionException("XRefs of type 'math' must point to mediatypes: application/mathml+xml, application/x-tex or text/asciimath");
                    }
                }
            }
            if (wrapMediaFragment) {
                this.xml.openElement("media-fragment");
                this.xml.attribute("id", "media");
                this.xml.attribute("mediatype", uri.getType());
            }
            if (RuleUtils.isXMLMediaType(uri.getType())) {
                this.xml.writeXML(psml.toString());
            } else {
                this.xml.writeText(psml.toString());
            }
            if (wrapMediaFragment) {
                this.xml.closeElement();
            }
        }
        catch (IOException ex) {
            throw new TransclusionException("Failed to read target document with URI ID " + uriid, ex);
        }
        catch (URIException ex) {
            throw new TransclusionException("Failed to load content from target document with URI ID " + uriid, ex);
        }
    }

    private static boolean isNotMathType(String mediatype) {
        return !"application/mathml+xml".equals(mediatype) && !"application/x-tex".equals(mediatype) && !"text/asciimath".equals(mediatype);
    }

    private static class TransclusionException
    extends Exception {
        private static final long serialVersionUID = 7733046469035213494L;

        TransclusionException(String msg) {
            super(msg);
        }

        TransclusionException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

