/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.document.PSMLContentUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.util.Pair;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StructureBuilder
extends DefaultHandler {
    private final Pattern SECTION_PATTERN = Pattern.compile("<section .*?id=\"([^\"]+)\"", 8);
    private final XMLWriter structureXML = new XMLStringWriter(XML.NamespaceAware.No);
    private boolean outputContentToStructure = false;
    protected boolean inCompare = false;
    protected boolean inPreviousSection = false;
    protected int inMediaFragment = 0;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final Map<String, String> fragmentIDs = new HashMap<String, String>();
    private final List<Pair<String, String>> renamedFragmentIDs = new ArrayList<Pair<String, String>>();
    private Stack<String> elements = new Stack();
    private @Nullable String oldStructure = null;
    private @Nullable Map<String, String> oldSections = null;

    public void setOldStructure(@Nullable String xml) {
        this.oldStructure = xml;
    }

    public void addExistingFragmentID(String fragmentID) {
        this.fragmentIDs.put(fragmentID.toLowerCase(), fragmentID);
    }

    public String getStructureXML() {
        return this.structureXML.toString();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String id;
        String element = localName == null || localName.isEmpty() ? qName : localName;
        boolean isSection = "section".equals(element);
        if (isSection && "false".equals(atts.getValue("overwrite")) && this.oldStructure != null && this.inMediaFragment == 0) {
            @Nullable String oldSection = this.findOldSection(atts.getValue("id"));
            if (oldSection != null) {
                try {
                    this.structureXML.writeXML(oldSection);
                    this.inPreviousSection = true;
                    return;
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to output previous structure element section: " + ex.getMessage(), ex);
                }
            }
        } else if (this.inPreviousSection) {
            return;
        }
        String dad = this.elements.isEmpty() ? null : this.elements.peek();
        boolean isFragment = PSMLContentUtils.isFragmentElement(element);
        if ("compareto".equals(element) || "compare".equals(element)) {
            this.inCompare = true;
        }
        if (this.inCompare) {
            return;
        }
        if (isFragment && !"true".equals(atts.getValue("deleted")) && this.inMediaFragment == 0 && (id = atts.getValue("id")) != null) {
            try {
                String existing = this.fragmentIDs.get(id.toLowerCase());
                if (existing != null && !existing.equals(id)) {
                    this.renamedFragmentIDs.add((Pair<String, String>)new Pair((Object)id, (Object)existing));
                    id = existing;
                }
                this.structureXML.openElement("fragment-ref");
                this.structureXML.attribute("id", id);
                this.structureXML.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write structure fragment " + id + ": " + ex.getMessage(), ex);
            }
        }
        this.outputContentToStructure = "title".equals(element) && "section".equals(dad) && this.inMediaFragment == 0;
        boolean isDocument = "document".equals(element);
        if ((isDocument || isSection || "title".equals(element) && "section".equals(dad) || "toc".equals(element)) && this.inMediaFragment == 0) {
            try {
                this.structureXML.openElement(element);
                if (isDocument) {
                    String lockstructure;
                    String editable = atts.getValue("edit");
                    if (editable != null) {
                        this.structureXML.attribute("edit", editable);
                    }
                    if ((lockstructure = atts.getValue("lockstructure")) != null) {
                        this.structureXML.attribute("lockstructure", lockstructure);
                    }
                } else {
                    for (int i = 0; i < atts.getLength(); ++i) {
                        this.structureXML.attribute(atts.getLocalName(i), atts.getValue(i));
                    }
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open structure element " + element + ": " + ex.getMessage(), ex);
            }
        }
        if (PSMLContentUtils.isMediaFragmentElement(element)) {
            ++this.inMediaFragment;
        }
        this.elements.push(element);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String element;
        String string = element = localName == null || localName.isEmpty() ? qName : localName;
        if (this.inPreviousSection) {
            if ("section".equals(element)) {
                this.inPreviousSection = false;
            }
            return;
        }
        if ("compareto".equals(element) || "compare".equals(element)) {
            this.inCompare = false;
            return;
        }
        if (this.inCompare) {
            return;
        }
        if (PSMLContentUtils.isMediaFragmentElement(element)) {
            --this.inMediaFragment;
        }
        this.elements.pop();
        if (this.inMediaFragment > 0) {
            return;
        }
        String dad = this.elements.isEmpty() ? null : this.elements.peek();
        this.outputContentToStructure = false;
        if ("document".equals(element) || "section".equals(element) || "title".equals(element) && "section".equals(dad) || "toc".equals(element)) {
            try {
                this.structureXML.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close structure element " + element + ": " + ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.outputContentToStructure) {
            try {
                this.structureXML.writeText(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException("Failed to output structure content: " + ex.getMessage(), ex);
            }
        }
    }

    public List<Pair<String, String>> getRenamedFragmentIDs() {
        return this.renamedFragmentIDs;
    }

    public Map<String, String> getFragmentIDs() {
        return this.fragmentIDs;
    }

    private @Nullable String findOldSection(@Nullable String id) {
        if (id == null || this.oldStructure == null) {
            return null;
        }
        if (this.oldSections == null) {
            this.findOldSections();
        }
        return this.oldSections.get(id);
    }

    private void findOldSections() {
        String[] oldSections;
        this.oldSections = new HashMap<String, String>();
        if (this.oldStructure == null) {
            return;
        }
        for (String oldSection : oldSections = this.oldStructure.split("<section ")) {
            Object sect = "<section " + oldSection;
            Matcher matcher = this.SECTION_PATTERN.matcher((CharSequence)sect);
            if (!matcher.find()) continue;
            if (!((String)sect).endsWith("</section>")) {
                int end = ((String)sect).indexOf("</section>");
                if (end > -1) {
                    sect = ((String)sect).substring(0, end + 10);
                } else {
                    int firstSlash = ((String)sect).indexOf(62);
                    if (firstSlash != -1 && ((String)sect).charAt(firstSlash - 1) == '/') {
                        sect = ((String)sect).substring(0, firstSlash + 1);
                    }
                }
            }
            this.oldSections.put(matcher.group(1), (String)sect);
        }
    }
}

