/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.document.PSMLFragmentLoader;
import com.pageseeder.base.rule.URIFetcher;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PSMLStructureHandler
extends DefaultHandler
implements PSMLContentBuilder.FragmentDetailsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSMLStructureHandler.class);
    private final URIFetcher uriFetcher;
    private final XMLWriter output;
    private final PSMLContentBuilder psmlBuilder;
    private boolean ignore = false;
    private boolean firstSectionGone = false;
    private PSMLFragmentLoader originalFragments = null;

    PSMLStructureHandler(PSMLContentBuilder builder, XMLWriter xml, URIFetcher urifetcher) {
        this.output = xml;
        this.psmlBuilder = builder;
        this.uriFetcher = urifetcher;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.output.setPrefixMapping(uri, prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (("section".equals(localName) || "toc".equals(localName)) && !this.firstSectionGone) {
            try {
                this.psmlBuilder.documentInfo(this.output);
                this.psmlBuilder.fragmentInfo(this.output, this);
                this.psmlBuilder.metadata(this.output, this);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to output metadata elements", (Throwable)ex);
                throw new SAXException("Failed to output metadata elements", ex);
            }
            this.firstSectionGone = true;
        }
        if ("fragment-ref".equals(localName)) {
            String id = attributes.getValue("id");
            if (id == null) {
                LOGGER.error("Invalid fragment has no 'id' attribute");
                throw new SAXException("Invalid fragment has no 'id' attribute");
            }
            try {
                this.psmlBuilder.fragment(id, this, true, true, this.output);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to output content for fragment {}", (Object)id, (Object)ex);
                throw new SAXException("Failed to output content for fragment " + id, ex);
            }
            this.ignore = true;
        } else {
            try {
                if ("document".equals(localName)) {
                    this.psmlBuilder.document(attributes, this.output);
                } else {
                    this.output.openElement(Strings.isEmpty((String)uri) ? null : uri, localName, true);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.output.attribute(Strings.isEmpty((String)attributes.getURI(i)) ? null : attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to output PSML content start element {}", (Object)localName, (Object)ex);
                throw new SAXException("Failed to output PSML content start element " + localName, ex);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.ignore) {
            try {
                this.output.closeElement();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to output PSML content end element {}", (Object)localName, (Object)ex);
                throw new SAXException("Failed to output PSML content end element " + localName, ex);
            }
        }
        if ("fragment-ref".equals(localName)) {
            this.ignore = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.writeText(ch, start, length);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to output PSML text content", (Throwable)ex);
            throw new SAXException("Failed to output PSML text content", ex);
        }
    }

    @Override
    public String getFragmentContent(String fragmentID) {
        if (this.originalFragments == null) {
            this.loadFragmentsFromContent();
        }
        return this.originalFragments.getFragmentContent(fragmentID);
    }

    @Override
    public String getLocatorContent(String fragmentID) {
        if (this.originalFragments == null) {
            this.loadFragmentsFromContent();
        }
        return this.originalFragments.getLocatorContent(fragmentID);
    }

    @Override
    public String getLabels(String fragmentID) {
        if (this.originalFragments == null) {
            this.loadFragmentsFromContent();
        }
        return this.originalFragments.getLabels(fragmentID);
    }

    @Override
    public String getModifiedDate(String fragmentID) {
        if (this.originalFragments == null) {
            this.loadFragmentsFromContent();
        }
        return this.originalFragments.getModifiedDate(fragmentID);
    }

    @Override
    public String getStructureModifiedDate() {
        if (this.originalFragments == null) {
            this.loadFragmentsFromContent();
        }
        return this.originalFragments.getStructureModifiedDate();
    }

    @Override
    public Collection<String> getFragments() {
        if (this.originalFragments == null) {
            this.loadFragmentsFromContent();
        }
        return this.originalFragments.getFragments();
    }

    private void loadFragmentsFromContent() {
        this.originalFragments = new PSMLFragmentLoader();
        try (InputStream in = this.uriFetcher.getContent();){
            XMLHelpers.parse(in, this.originalFragments);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to load content from file system", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to write content from file system", (Throwable)ex);
        }
    }
}

