/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.ObjectProperties;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PSMLContentUtils {
    public static final String STRUCTURE_FRAGMENT_ELEMENT_NAME = "fragment-ref";
    public static final Pattern FRAGMENT_PATTERN = Pattern.compile("^<(fragment|media-fragment|xref-fragment|properties-fragment)");

    private PSMLContentUtils() {
    }

    public static boolean isMediaFragmentElement(String name) {
        return "media-fragment".equals(name);
    }

    public static boolean isFragmentElement(String name) {
        return "fragment".equals(name) || "xref-fragment".equals(name) || "properties-fragment".equals(name) || PSMLContentUtils.isMediaFragmentElement(name);
    }

    public static String getFragmentType(XLink edit) {
        String props;
        String string = props = edit == null ? null : edit.getProperties();
        if (props == null) {
            return null;
        }
        Pattern p = Pattern.compile("ps-type=(.*?)\\|");
        Matcher m = p.matcher(props);
        if (!m.find()) {
            return null;
        }
        return m.group(1);
    }

    public static void setFragmentType(XLink edit, String type) {
        if (edit == null || type == null) {
            return;
        }
        ObjectProperties.setXLinkProperty((XLink)edit, (String)"ps-type", Collections.singletonList(type));
    }
}

