/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.MetadataFragmentLoader;
import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.document.PSMLContentHandler;
import com.pageseeder.base.document.PSMLFragmentLoader;
import com.pageseeder.base.document.PSMLStructureHandler;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.rule.ExternalURIFetcher;
import com.pageseeder.base.rule.InternalURIFetcher;
import com.pageseeder.base.rule.URIFetcher;
import com.pageseeder.base.rule.URIFetcherStatus;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PSMLContentResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSMLContentResolver.class);
    private URIFetcher uriFetch;
    private final Database db;
    private final URI uri;
    private final String groupName;
    private Long releaseId;
    private String fragment = null;
    private boolean fragmentinfo = false;
    private boolean reversexrefs = true;
    private Long draftMemberId = null;

    public PSMLContentResolver(Database d, URI u, String gn) {
        this.db = d;
        this.uri = u;
        this.groupName = gn;
    }

    PSMLContentResolver(Database d, URI u, URIFetcher uf, String gn) {
        this.db = d;
        this.uri = u;
        this.uriFetch = uf;
        this.groupName = gn;
    }

    public void setReleaseId(Long releaseid) {
        this.releaseId = releaseid;
    }

    public void setFragment(String frag, Long memberid, boolean fraginfo, boolean reversexrefs) {
        this.fragment = frag;
        this.draftMemberId = memberid;
        this.fragmentinfo = fraginfo;
        this.reversexrefs = reversexrefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent() throws URIException {
        try {
            Group mgrp;
            if (this.uriFetch == null) {
                this.uriFetch = URIs.isExternal((URI)this.uri) ? new ExternalURIFetcher(URIRule.getURIString(this.uri), null) : new InternalURIFetcher(this.uri, null);
                if (this.uriFetch.getStatus() != URIFetcherStatus.SUCCESS) {
                    throw new URIException("URIFetcher Status: " + this.uriFetch.getStatus() + " Message: " + this.uriFetch.getStatusMessage());
                }
            }
            Group group = mgrp = this.groupName == null ? null : DatabaseQuery.getGroupByName((Database)this.db, (String)this.groupName);
            if (mgrp == null && !URIs.isExternal((URI)this.uri)) {
                throw new DatabaseException("Group name=" + this.groupName + " does not exist");
            }
            PSMLContentBuilder builder = new PSMLContentBuilder(this.uri, mgrp, this.db);
            XLink release = null;
            if (this.releaseId != null && this.releaseId == 0L) {
                builder.setOriginalVersion();
            } else if (this.releaseId != null) {
                release = DatabaseQuery.getXLinkById((Database)this.db, (Long)this.releaseId);
                builder.setVersion(release);
            }
            if (this.draftMemberId != null) {
                builder.setDraftMemberId(this.draftMemberId);
            }
            XMLStringWriter psml = new XMLStringWriter(XML.NamespaceAware.Yes);
            try {
                if ("default".equals(this.fragment)) {
                    MetadataFragmentLoader loader = new MetadataFragmentLoader();
                    if (this.fragmentinfo) {
                        builder.metadata((XMLWriter)psml, loader);
                    } else {
                        builder.fragment(this.fragment, loader, true, false, (XMLWriter)psml);
                    }
                } else if (this.fragment != null) {
                    Locator loc;
                    PSMLContentBuilder.FragmentDetailsLoader loader = "application/vnd.pageseeder.psml+xml".equals(this.uri.getType()) ? new FragmentLoader(this.uriFetch) : new MetadataFragmentLoader();
                    Iterator locs = this.uri.getLocators((Object)Predicates.predicateLocatorFragment((Database)this.db, (String)this.fragment));
                    Locator locator = loc = locs.hasNext() ? (Locator)locs.next() : null;
                    if (this.fragmentinfo) {
                        XLink edit;
                        psml.openElement("document-fragment");
                        if (this.draftMemberId != null && (edit = builder.loadLastEditFragmentFromDB(this.fragment, false)) != null && "Documentation-Draft".equals(edit.getStatus())) {
                            psml.attribute("draft", "true");
                        }
                        builder.locator(loc, this.fragment, loader, this.reversexrefs, (XMLWriter)psml);
                    }
                    if (!builder.fragment(this.fragment, loader, true, false, (XMLWriter)psml) || loc != null && !this.fragment.equals(loc.getFragment())) {
                        psml = new XMLStringWriter(XML.NamespaceAware.Yes);
                        if (this.fragmentinfo) {
                            psml.emptyElement("document-fragment");
                        }
                    } else if (this.fragmentinfo) {
                        psml.closeElement();
                    }
                } else if (!"application/vnd.pageseeder.psml+xml".equals(this.uri.getType())) {
                    MetadataFragmentLoader loader = new MetadataFragmentLoader();
                    builder.document(null, (XMLWriter)psml);
                    builder.documentInfo((XMLWriter)psml);
                    builder.fragmentInfo((XMLWriter)psml, loader);
                    builder.metadata((XMLWriter)psml, loader);
                    Collection locs = this.uri.getLocatorsCol();
                    if (!(locs.isEmpty() || locs.size() == 1 && "default".equals(((Locator)locs.iterator().next()).getFragment()))) {
                        psml.openElement("fragments");
                        for (Locator loc : locs) {
                            if ("default".equals(loc.getFragment())) continue;
                            builder.fragment(loc.getFragment(), loader, true, true, (XMLWriter)psml);
                        }
                        psml.closeElement();
                    }
                    psml.closeElement();
                } else {
                    XLink structure = DatabaseQuery.getXLinkURIStructure((Database)this.db, (URI)this.uri, (Group)mgrp, (Date)(release != null ? release.getDate() : (this.releaseId != null ? this.uri.getDateCreated() : null)));
                    if (structure == null) {
                        if (this.uriFetch.getFile() == null) {
                            LOGGER.warn("Structure xlink not found for URI ID: " + this.uri.getId());
                        }
                        this.parsePSML(builder, (XMLWriter)psml);
                    } else {
                        this.parseStructure(builder, (XMLWriter)psml, ((Content)structure.getContents().next()).getData());
                    }
                }
            }
            finally {
                this.uriFetch.close();
            }
            return new ByteArrayInputStream(psml.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (DatabaseException | IOException ex) {
            throw new URIException(ex);
        }
    }

    private void parsePSML(PSMLContentBuilder builder, XMLWriter psml) throws IOException, URIException {
        try {
            XMLHelpers.parse(this.uriFetch.getContent(), new PSMLContentHandler(builder, psml));
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to parse original XML for URIID {}: {}", new Object[]{this.uri.getId(), ex.getMessage(), ex});
            throw new URIException(ex);
        }
    }

    private void parseStructure(PSMLContentBuilder builder, XMLWriter psml, String structure) throws URIException {
        PSMLStructureHandler handler = new PSMLStructureHandler(builder, psml, this.uriFetch);
        try {
            XMLHelpers.parse(new ByteArrayInputStream(structure.getBytes(StandardCharsets.UTF_8)), handler);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to parse structure XML: {}", (Object)ex.getMessage(), (Object)ex);
            throw new URIException(ex);
        }
    }

    private static class FragmentLoader
    implements PSMLContentBuilder.FragmentDetailsLoader {
        private final PSMLFragmentLoader loader = new PSMLFragmentLoader();
        private final URIFetcher fetcher;
        private boolean loaded = false;

        FragmentLoader(URIFetcher uriFetcher) {
            this.fetcher = uriFetcher;
        }

        private void ensureLoaded() {
            if (!this.loaded) {
                try {
                    XMLHelpers.parse(this.fetcher.getContent(), this.loader);
                }
                catch (FoundationException ex) {
                    LOGGER.error("Failed to parse original XML: {}", (Object)ex.getMessage(), (Object)ex);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to read original XML: {}", (Object)ex.getMessage(), (Object)ex);
                }
                this.loaded = true;
            }
        }

        @Override
        public String getFragmentContent(String fragmentID) {
            this.ensureLoaded();
            return this.loader.getFragmentContent(fragmentID);
        }

        @Override
        public String getLocatorContent(String fragmentID) {
            this.ensureLoaded();
            return this.loader.getLocatorContent(fragmentID);
        }

        @Override
        public String getLabels(String fragmentID) {
            this.ensureLoaded();
            return this.loader.getLabels(fragmentID);
        }

        @Override
        public String getModifiedDate(String fragmentID) {
            this.ensureLoaded();
            return this.loader.getModifiedDate(fragmentID);
        }

        @Override
        public String getStructureModifiedDate() {
            this.ensureLoaded();
            return this.loader.getStructureModifiedDate();
        }

        @Override
        public Collection<String> getFragments() {
            this.ensureLoaded();
            return this.loader.getFragments();
        }
    }
}

