/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.web;

import com.pageseeder.base.generator.ErrorID;

public enum WebhookErrorID implements ErrorID
{
    INVALID_CLIENT(5889, "Invalid client."),
    NAME_IN_USE(5890, "The name is already in use."),
    INVALID_URL(5891, "Invalid URL."),
    INVALID_OBJECT(5892, "Invalid object parameter, only \"minimal\" and \"basic\" are supported."),
    INVALID_FORMAT(5893, "Invalid format parameter, only \"xml\" and \"json\" are supported."),
    INVALID_PROJECT(5894, "Invalid project."),
    INVALID_GROUP(5895, "Invalid group."),
    INVALID_EVENT(5896, "Invalid event."),
    INVALID_STATUS(5897, "Invalid status."),
    PING_ERROR_HTTP_CODE(5898, "Error HTTP code."),
    PING_ERROR_HEADER(5899, "Invalid or missing PING header."),
    PING_ERROR_OTHER(5900, "Other error from ping request.");

    private final int id;
    private final String message;

    private WebhookErrorID(int id, String message) {
        if (id < 0) {
            throw new IndexOutOfBoundsException("Error ID must be >= 0");
        }
        this.id = id;
        this.message = message;
    }

    public int id() {
        return this.id;
    }

    public String message() {
        return this.message;
    }
}

