/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.manager;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesListener;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.db.model.XLink;
import com.pageseeder.webhook.event.Event;
import com.pageseeder.webhook.event.EventAction;
import com.pageseeder.webhook.event.EventBuilder;
import com.pageseeder.webhook.event.EventsCache;
import com.pageseeder.webhook.event.EventsCleanupThread;
import com.pageseeder.webhook.event.EventsThread;
import com.pageseeder.webhook.job.FailedJobsThread;
import com.pageseeder.webhook.job.Job;
import com.pageseeder.webhook.job.JobPoster;
import com.pageseeder.webhook.job.JobsQueue;
import com.pageseeder.webhook.job.JobsThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookManager
implements UniversallyPrintable,
ChangesListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebhookManager.class);
    private static @Nullable WebhookManager instance = null;
    private final ExecutorService threads = Executors.newFixedThreadPool(6, r -> {
        Thread t = new Thread(r, "ps-webhook-" + r.getClass().getSimpleName().toLowerCase());
        if (r instanceof EventsCleanupThread) {
            t.setPriority(2);
        }
        return t;
    });
    private final JobsQueue jobs = new JobsQueue();
    private final EventsCache events = new EventsCache();

    private WebhookManager() {
    }

    public static WebhookManager getInstance() {
        WebhookManager manager = instance;
        if (manager == null) {
            manager = instance = new WebhookManager();
        }
        return manager;
    }

    public static void updateSettings() {
        FailedJobsThread.MAX_RETRIES = GlobalSettings.getInt((String)"webhookRetries", (int)12);
        EventsThread.REQUEST_INTERVAL_SECONDS = GlobalSettings.getInt((String)"webhookRequestInterval", (int)5);
        EventsThread.REQUEST_SIZE_BYTES = GlobalSettings.getInt((String)"webhookRequestSize", (int)1400);
    }

    public void addEventFilters(Webhook webhook) {
        this.events.addFilters(webhook.getEventsCol());
    }

    private Set<String> getEventFilters(Database db) throws QueryFailedException {
        HashSet<String> filters = new HashSet<String>();
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add(Webhook.Status.active.name());
        statuses.add(Webhook.Status.error.name());
        statuses.add(Webhook.Status.warning.name());
        List webhooks = WebhookQuery.listWebhooksByStatus((Database)db, statuses);
        for (Webhook webhook : webhooks) {
            Collection events = webhook.getEventsCol();
            if (events.isEmpty()) {
                filters.add("*.*");
                continue;
            }
            filters.addAll(events);
        }
        return filters;
    }

    public void reloadEventFilters(Database db) throws QueryFailedException {
        this.events.setFilters(this.getEventFilters(db));
    }

    public void start() {
        WebhookManager.updateSettings();
        this.startThreads();
    }

    public void start(Database db) throws QueryFailedException {
        WebhookManager.updateSettings();
        this.events.setFilters(this.getEventFilters(db));
        this.startThreads();
    }

    private void startThreads() {
        ChangesManager.registerListener((ChangesListener)this);
        this.threads.execute(new EventsThread(this.events, this.jobs));
        this.threads.execute(new EventsCleanupThread(this.events, this.jobs));
        this.threads.execute(new JobsThread(this.jobs, this.events));
        this.threads.execute(new FailedJobsThread(this.jobs, this.events));
    }

    public void stop() {
        LOGGER.info("There was {} unprocessed webhook events at shutdown.", (Object)this.events.getNonQueuedEvents().size());
        LOGGER.info("There was {} unprocessed webhook jobs at shutdown.", (Object)this.jobs.getJobsCount());
        LOGGER.info("There was {} unprocessed failed webhook jobs at shutdown.", (Object)this.jobs.getFailJobsCount());
        EventsThread.stop();
        EventsCleanupThread.stop();
        JobsThread.stop();
        FailedJobsThread.stop();
        this.threads.shutdownNow();
        try {
            this.threads.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LoggerFactory.getLogger(WebhookManager.class).warn("Webhook manager interrupted when waiting for threads to terminate");
        }
        this.events.close();
        this.jobs.close();
    }

    public void print(OutputPrinter out) {
        out.startObject("current-state");
        this.events.print(out);
        this.jobs.print(out);
        out.endObject();
    }

    public Event getEvent(String id) {
        return this.events.get(id);
    }

    public Job getJob(Long id) {
        return this.jobs.get(id);
    }

    public Job getFailedJob(Long id) {
        return this.jobs.getFailed(id);
    }

    public void createMembership(Database db, @Nullable ChangesBatch batch, MemberForGroup membership) {
        EventBuilder builder = new EventBuilder(Event.Object.membership, EventAction.created);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.membership(membership).contextGroup(membership.getGroup()).build());
    }

    public void modifyMembership(Database db, @Nullable ChangesBatch batch, MemberForGroup membership) {
        EventBuilder builder = new EventBuilder(Event.Object.membership, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.membership(membership).contextGroup(membership.getGroup()).build());
    }

    public void deleteMembership(Database db, @Nullable ChangesBatch batch, Long membershipid, Group group) {
        EventBuilder builder = new EventBuilder(Event.Object.membership, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.membership(membershipid).contextGroup(group).build());
    }

    public void createMember(Database db, @Nullable ChangesBatch batch, Member member) {
        EventBuilder builder = new EventBuilder(Event.Object.member, EventAction.created);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.member(member).build());
    }

    public void modifyMember(Database db, @Nullable ChangesBatch batch, Member member) {
        EventBuilder builder = new EventBuilder(Event.Object.member, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.member(member).build());
    }

    public void deleteMember(Database db, @Nullable ChangesBatch batch, Long memberid, String username, String email) {
        EventBuilder builder = new EventBuilder(Event.Object.member, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.member(memberid, username, email).build());
    }

    public void deleteGroup(Database db, @Nullable ChangesBatch batch, Long groupid, String name) {
        EventBuilder builder = new EventBuilder(Event.Object.group, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.group(groupid, name).build());
    }

    public void createGroup(Database db, @Nullable ChangesBatch batch, Group group) {
        EventBuilder builder = new EventBuilder(Event.Object.group, EventAction.created);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        builder.group(group);
        String dadProject = GroupRule.getParentProjectName((String)group.getName());
        try {
            builder.contextGroup(DatabaseQuery.getGroupByName((Database)db, (String)dadProject));
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load context project {}", (Object)dadProject, (Object)ex);
        }
        this.events.add(builder.build());
    }

    public void renameGroup(Database db, @Nullable ChangesBatch batch, Group group, String name) {
        EventBuilder builder = new EventBuilder(Event.Object.group, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.group(group).contextGroup(group.getId(), name).build());
    }

    public void modifyGroup(Database db, @Nullable ChangesBatch batch, Group group) {
        EventBuilder builder = new EventBuilder(Event.Object.group, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.group(group).contextGroup(group).build());
    }

    public void modifyGroupProperties(Database db, @Nullable ChangesBatch batch, Group group) {
        EventBuilder builder = new EventBuilder(Event.Object.groupproperties, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.groupProperties(group, db).contextGroup(group).build());
    }

    public void archiveGroup(Database db, @Nullable ChangesBatch batch, Group group, String name) {
        EventBuilder builder = new EventBuilder(Event.Object.group, EventAction.archived);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.group(group).contextGroup(group.getId(), name).build());
    }

    public void createProject(Database db, @Nullable ChangesBatch batch, Group project) {
        EventBuilder builder = new EventBuilder(Event.Object.project, EventAction.created);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        builder.project(project);
        String dadProject = GroupRule.getParentProjectName((String)project.getName());
        if (dadProject != null) {
            try {
                builder.contextGroup(DatabaseQuery.getGroupByName((Database)db, (String)dadProject));
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load context project {}", (Object)dadProject, (Object)ex);
            }
        }
        this.events.add(builder.build());
    }

    public void modifyProject(Database db, @Nullable ChangesBatch batch, Group project) {
        EventBuilder builder = new EventBuilder(Event.Object.project, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.project(project).contextGroup(project).build());
    }

    public void renameProject(Database db, @Nullable ChangesBatch batch, Group project, String name) {
        EventBuilder builder = new EventBuilder(Event.Object.project, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.project(project).contextGroup(project.getId(), name).build());
    }

    public void archiveProject(Database db, @Nullable ChangesBatch batch, Group project, String name) {
        EventBuilder builder = new EventBuilder(Event.Object.project, EventAction.archived);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.project(project).contextGroup(project.getId(), name).build());
    }

    public void deleteProject(Database db, @Nullable ChangesBatch batch, Long projectid, String name) {
        EventBuilder builder = new EventBuilder(Event.Object.project, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.project(projectid, name).build());
    }

    public void createVersion(Database db, @Nullable ChangesBatch batch, URI uri, XLink version, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.uri, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.uri(uri).build());
    }

    public void archiveVersion(Database db, @Nullable ChangesBatch batch, URI uri, XLink version, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.uri, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.uri(uri).build());
    }

    public void createWorkflow(Database db, @Nullable ChangesBatch batch, XLink workflow, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.workflow, EventAction.updated);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.workflow(workflow, db).contextGroups(groups).build());
    }

    public void deleteWorkflow(Database db, @Nullable ChangesBatch batch, Long rootxlinkid, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.workflow, EventAction.updated);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.workflow(rootxlinkid).contextGroups(groups).build());
    }

    public void taskUpdated(Database db, @Nullable ChangesBatch batch, XLink task, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.task, EventAction.updated);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.task(task, groups, db).contextGroups(groups).build());
    }

    public void taskUpdated(Database db, @Nullable ChangesBatch batch, Long rootxlinkid, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.task, EventAction.updated);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.task(rootxlinkid).contextGroups(groups).build());
    }

    public void createComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        EventBuilder builder;
        if (comment.getStatus() != null) {
            this.taskUpdated(db, batch, comment, groups);
        }
        if (!this.events.includeEvent((builder = new EventBuilder(Event.Object.comment, EventAction.created)).getEventType())) {
            return;
        }
        this.events.add(builder.comment(comment, db).contextGroups(groups).build());
    }

    public void modifyComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        EventBuilder builder;
        if (comment.getStatus() != null) {
            this.taskUpdated(db, batch, comment, groups);
        }
        if (!this.events.includeEvent((builder = new EventBuilder(Event.Object.comment, EventAction.modified)).getEventType())) {
            return;
        }
        this.events.add(builder.comment(comment, db).contextGroups(groups).build());
    }

    public void archiveComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        EventBuilder builder;
        if (comment.getStatus() != null) {
            this.taskUpdated(db, batch, comment, groups);
        }
        if (!this.events.includeEvent((builder = new EventBuilder(Event.Object.comment, EventAction.archived)).getEventType())) {
            return;
        }
        this.events.add(builder.comment(comment, db).contextGroups(groups).build());
    }

    public void unarchiveComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        EventBuilder builder;
        if (comment.getStatus() != null) {
            this.taskUpdated(db, batch, comment, groups);
        }
        if (!this.events.includeEvent((builder = new EventBuilder(Event.Object.comment, EventAction.unarchived)).getEventType())) {
            return;
        }
        this.events.add(builder.comment(comment, db).contextGroups(groups).build());
    }

    public void deleteComment(Database db, @Nullable ChangesBatch batch, Long commentid, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.comment, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.comment(commentid).contextGroups(groups).build());
    }

    public void createURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.uri, EventAction.created);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        if (groups != null && groups.size() == 1 && uri.getPath().equals(GlobalSettings.getSitePrefix() + "/" + groups.iterator().next().getName().replace('-', '/'))) {
            return;
        }
        this.events.add(builder.uri(uri).contextGroups(groups).build());
    }

    public void modifyURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.uri, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.uri(uri).contextGroups(groups).build());
    }

    public void archiveURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.uri, EventAction.archived);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.uri(uri).contextGroups(groups).build());
    }

    public void deleteDocument(Database db, @Nullable ChangesBatch batch, Long uriid, String docid, String path, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.uri, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.uri(uriid, docid, path).contextGroups(groups).build());
    }

    public void deleteURL(Database db, @Nullable ChangesBatch batch, Long uriid, String docid, String path, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.uri, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.uri(uriid, docid, path).contextGroups(groups).build());
    }

    public void deleteFolder(Database db, @Nullable ChangesBatch batch, Long uriid, String docid, String path, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.uri, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.uri(uriid, docid, path).contextGroups(groups).build());
    }

    public void createPublication(Database db, @Nullable ChangesBatch batch, Publication pub, Collection<URI> added) {
        EventBuilder builder = new EventBuilder(Event.Object.publication, EventAction.created);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        try {
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)pub.getDefaultGroupId());
            if (group != null) {
                URI uri;
                builder.publication(pub, added, null, null, null);
                if (added.isEmpty() && (uri = DatabaseQuery.getURIById((Database)db, (Long)pub.getRootURIId())) != null) {
                    builder = new EventBuilder(Event.Object.publication, EventAction.created).publication(pub, Collections.singleton(uri), null, null, null);
                }
                this.events.add(builder.contextGroup(group).build());
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load default group or root URI for publication {}", (Object)pub.getId(), (Object)ex);
        }
    }

    public void modifyPublication(Database db, @Nullable ChangesBatch batch, Publication pub, Collection<URI> added, Collection<URI> modified, Collection<URI> removed, Collection<Long> deletedUriids) {
        EventBuilder builder = new EventBuilder(Event.Object.publication, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        try {
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)pub.getDefaultGroupId());
            if (group != null) {
                this.events.add(builder.publication(pub, added, modified, removed, deletedUriids).contextGroup(group).build());
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load default group for publication {}", (Object)pub.getId(), (Object)ex);
        }
    }

    public void deletePublication(Database db, @Nullable ChangesBatch batch, Publication pub, Collection<URI> removed) {
        EventBuilder builder = new EventBuilder(Event.Object.publication, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        try {
            Group group = DatabaseQuery.getGroupById((Database)db, (Long)pub.getDefaultGroupId());
            if (group != null) {
                this.events.add(builder.publication(pub, null, null, removed, null).contextGroup(group).build());
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load default group for publication {}", (Object)pub.getId(), (Object)ex);
        }
    }

    public void createGroupfolder(Database db, @Nullable ChangesBatch batch, GroupURI groupfolder, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.groupfolder, EventAction.created);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.groupfolder(groupfolder, db).contextGroups(groups).build());
    }

    public void modifyGroupfolder(Database db, @Nullable ChangesBatch batch, GroupURI groupfolder, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.groupfolder, EventAction.modified);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.groupfolder(groupfolder, db).contextGroups(groups).build());
    }

    public void deleteGroupfolder(Database db, @Nullable ChangesBatch batch, Long guriid, String path, Collection<Group> groups) {
        EventBuilder builder = new EventBuilder(Event.Object.groupfolder, EventAction.deleted);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.groupfolder(guriid, path).contextGroups(groups).build());
    }

    public void serverStart(Database db) {
        EventBuilder builder = new EventBuilder(Event.Object.server, EventAction.started);
        if (!this.events.includeEvent(builder.getEventType())) {
            return;
        }
        this.events.add(builder.server().build());
    }

    public void startSendPing(long webhookid) {
        this.threads.execute(() -> this.sendPing(webhookid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable JobPoster sendPing(long webhookid) {
        Transaction tr;
        Database db;
        try {
            db = Database.open();
            tr = new Transaction(db);
            tr.begin();
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to open database", (Throwable)ex);
            return null;
        }
        try {
            Webhook webhook;
            try {
                webhook = WebhookQuery.getWebhook((Database)db, (Long)webhookid);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load webhook with ID {}", (Object)webhookid, (Object)ex);
                tr.abort();
                JobPoster jobPoster = null;
                if (db != null) {
                    db.close();
                }
                return jobPoster;
            }
            if (webhook == null) {
                LOGGER.error("Failed to load webhook with ID {}", (Object)webhookid);
                tr.abort();
                JobPoster ex = null;
                return ex;
            }
            JobPoster poster = new JobPoster();
            poster.post(webhook, Collections.singleton(new EventBuilder(Event.Object.webhook, EventAction.ping).webhook(webhook).build()));
            try {
                tr.commit();
            }
            catch (CommitTransactionException ex) {
                LOGGER.error("Failed to commit transaction", (Throwable)ex);
            }
            JobPoster jobPoster = poster;
            return jobPoster;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

