/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.job;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.webhook.job.Job;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class JobsQueue
implements UniversallyPrintable {
    private final Cache jobsCache = CacheManager.getInstance().getCache("webhook-jobs");
    private final Cache failedJobsCache = CacheManager.getInstance().getCache("webhook-failed-jobs");
    private final AtomicLong currentID;
    private final AtomicLong retrieveID;

    public JobsQueue() {
        Long id;
        Long start = -1L;
        Long retrieve = -1L;
        for (Object key : this.jobsCache.getKeys()) {
            id = (Long)key;
            if (id > start) {
                start = id;
            }
            if (retrieve != -1L && retrieve <= id) continue;
            retrieve = id;
        }
        if (start == -1L) {
            for (Object key : this.failedJobsCache.getKeys()) {
                id = (Long)key;
                if (id <= start) continue;
                start = id;
            }
            retrieve = start + 1L;
        }
        this.currentID = new AtomicLong(start + 1L);
        this.retrieveID = new AtomicLong(retrieve);
    }

    public Job add(Long webhookid, Collection<String> evts) {
        Job created = new Job(this.currentID.getAndIncrement(), webhookid, new ArrayList<String>(evts));
        this.jobsCache.put(new Element((Serializable)created.getID(), (Serializable)created));
        return created;
    }

    public Job get(Long id) {
        Element cached = this.jobsCache.get((Serializable)id);
        return cached == null ? null : (Job)cached.getObjectValue();
    }

    public Job getFailed(Long id) {
        Element cached = this.failedJobsCache.get((Serializable)id);
        return cached == null ? null : (Job)cached.getObjectValue();
    }

    public Job next() {
        Element cached = this.jobsCache.removeAndReturnElement((Object)this.retrieveID.get());
        if (cached != null) {
            this.retrieveID.incrementAndGet();
            return (Job)cached.getObjectValue();
        }
        return null;
    }

    public Collection<String> getAllEventIDs() {
        Element cached;
        ArrayList<String> ids = new ArrayList<String>();
        for (Object id : this.jobsCache.getKeys()) {
            cached = this.jobsCache.get(id);
            if (cached == null) continue;
            ids.addAll(((Job)cached.getObjectValue()).getEvents());
        }
        for (Object id : this.failedJobsCache.getKeys()) {
            cached = this.failedJobsCache.get(id);
            if (cached == null) continue;
            ids.addAll(((Job)cached.getObjectValue()).getEvents());
        }
        return ids;
    }

    public void addFailed(Job job) {
        Job created = job.increaseRetries();
        this.failedJobsCache.put(new Element((Serializable)created.getID(), (Serializable)created));
    }

    public List<Long> getFailedJobIDs() {
        ArrayList<Long> keys = new ArrayList<Long>(this.failedJobsCache.getKeys());
        Collections.sort(keys);
        return keys;
    }

    public Job getFailedJob(Long id) {
        Element cached = this.failedJobsCache.get((Serializable)id);
        return cached == null ? null : (Job)cached.getObjectValue();
    }

    public void removeFailed(Long id) {
        this.failedJobsCache.remove((Serializable)id);
    }

    public int getJobsCount() {
        return this.jobsCache.getSize();
    }

    public int getFailJobsCount() {
        return this.failedJobsCache.getSize();
    }

    public void close() {
        this.jobsCache.dispose();
        this.failedJobsCache.dispose();
    }

    public void print(OutputPrinter out) {
        Element cached;
        out.startObject("jobs");
        out.startObject("queued");
        out.field("count", (long)this.jobsCache.getKeysWithExpiryCheck().size());
        out.startCollection("objects", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Object id : this.jobsCache.getKeys()) {
            cached = this.jobsCache.get(id);
            if (cached == null) continue;
            ((Job)cached.getObjectValue()).print(out);
        }
        out.endCollection();
        out.endObject();
        out.startObject("queued-failed");
        out.field("count", (long)this.failedJobsCache.getKeysWithExpiryCheck().size());
        out.startCollection("objects", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Object id : this.failedJobsCache.getKeys()) {
            cached = this.failedJobsCache.get(id);
            if (cached == null) continue;
            ((Job)cached.getObjectValue()).print(out);
        }
        out.endCollection();
        out.endObject();
        out.endObject();
    }
}

