/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.job;

import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.event.Event;
import com.pageseeder.webhook.event.EventsCache;
import com.pageseeder.webhook.job.Job;
import com.pageseeder.webhook.job.JobPoster;
import com.pageseeder.webhook.job.JobsQueue;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedJobsThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailedJobsThread.class);
    private static boolean SHOULD_STOP = false;
    public static int MAX_RETRIES = 12;
    private static final int DELAY = 10000;
    private final JobsQueue queue;
    private final EventsCache eventsCache;
    private final JobPoster poster;

    public FailedJobsThread(JobsQueue q, EventsCache evts) {
        this.queue = q;
        this.eventsCache = evts;
        this.poster = new JobPoster();
    }

    @Override
    public void run() {
        do {
            try {
                List<Long> jobIDs = this.queue.getFailedJobIDs();
                for (Long id : jobIDs) {
                    Job job = this.queue.getFailed(id);
                    if (job.getRetryDateTime() >= System.currentTimeMillis()) continue;
                    this.processJob(job);
                }
            }
            catch (Throwable ex) {
                LOGGER.error("Webhook faied job thread error", ex);
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                if (SHOULD_STOP) continue;
                LOGGER.warn("Failed jobs thread interrupted, closing!");
                break;
            }
        } while (!SHOULD_STOP);
    }

    public static void stop() {
        SHOULD_STOP = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJob(Job job) {
        Database db = null;
        Transaction tr = null;
        try {
            db = Database.open();
            tr = new Transaction(db);
            tr.begin();
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to open database", (Throwable)ex);
            return;
        }
        try {
            Webhook webhook;
            try {
                webhook = WebhookQuery.getWebhook((Database)db, (Long)job.getWebhoookID());
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load webhook with ID {}", (Object)job.getWebhoookID(), (Object)ex);
                tr.abort();
                if (db != null) {
                    db.close();
                }
                db = null;
                return;
            }
            if (webhook == null) {
                LOGGER.warn("Failed to load webhook with ID {}", (Object)job.getWebhoookID());
                this.queue.removeFailed(job.getID());
                tr.abort();
                return;
            }
            Webhook.Status status = webhook.getStatus();
            if (status == Webhook.Status.pending || status == Webhook.Status.disabled || status == Webhook.Status.unreachable) {
                LOGGER.info("Ignoring webhook with ID {} and status {}", (Object)job.getWebhoookID(), (Object)webhook.getStatus());
                this.queue.removeFailed(job.getID());
                tr.abort();
                return;
            }
            ArrayList<Event> events = new ArrayList<Event>();
            for (String eventID : job.getEvents()) {
                Event event = this.eventsCache.get(eventID);
                if (event == null) {
                    LOGGER.error("Failed to load event with ID {} from cache for webhook {} with URL {}", new Object[]{eventID, webhook.getId(), webhook.getURL()});
                    webhook.setStatus(Webhook.Status.error);
                    continue;
                }
                events.add(event);
            }
            if (!this.poster.post(webhook, events)) {
                if (job.getRetryNumber() == MAX_RETRIES) {
                    webhook.setStatus(Webhook.Status.unreachable);
                    this.queue.removeFailed(job.getID());
                } else {
                    webhook.setStatus(Webhook.Status.warning);
                    this.queue.addFailed(job);
                }
            } else {
                this.queue.removeFailed(job.getID());
            }
            try {
                tr.commit();
            }
            catch (CommitTransactionException ex) {
                LOGGER.error("Failed to commit transaction", (Throwable)ex);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
            db = null;
        }
    }
}

