/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.event;

import com.pageseeder.webhook.event.EventsCache;
import com.pageseeder.webhook.job.JobsQueue;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsCleanupThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsCleanupThread.class);
    private static boolean SHOULD_STOP = false;
    private final EventsCache cache;
    private final JobsQueue queue;
    private static final int DELAY = 1800000;

    public EventsCleanupThread(EventsCache ecache, JobsQueue jqueue) {
        this.cache = ecache;
        this.queue = jqueue;
    }

    @Override
    public void run() {
        do {
            try {
                Long last = this.cache.getLastProcessedTimestamp();
                Collection<String> ids = this.queue.getAllEventIDs();
                this.cache.removeEventsWithoutID(ids, last);
            }
            catch (Throwable ex) {
                LOGGER.error("Webhook cleanup thread error", ex);
            }
            try {
                Thread.sleep(1800000L);
            }
            catch (InterruptedException ex) {
                if (SHOULD_STOP) continue;
                LOGGER.warn("Events thread interrupted, closing!");
                break;
            }
        } while (!SHOULD_STOP);
    }

    public static void stop() {
        SHOULD_STOP = true;
    }
}

